/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire
 * dataset again or to crawl only folders that were added since the last crawler run. For more information, see <a
 * href="https://docs.aws.amazon.com/glue/latest/dg/incremental-crawls.html">Incremental Crawls in Glue</a> in the
 * developer guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecrawlPolicy implements SdkPojo, Serializable, ToCopyableBuilder<RecrawlPolicy.Builder, RecrawlPolicy> {
    private static final SdkField<String> RECRAWL_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecrawlBehavior").getter(getter(RecrawlPolicy::recrawlBehaviorAsString))
            .setter(setter(Builder::recrawlBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecrawlBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECRAWL_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recrawlBehavior;

    private RecrawlPolicy(BuilderImpl builder) {
        this.recrawlBehavior = builder.recrawlBehavior;
    }

    /**
     * <p>
     * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last
     * crawler run.
     * </p>
     * <p>
     * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
     * </p>
     * <p>
     * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last
     * crawler run.
     * </p>
     * <p>
     * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recrawlBehavior}
     * will return {@link RecrawlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recrawlBehaviorAsString}.
     * </p>
     * 
     * @return Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the
     *         last crawler run.</p>
     *         <p>
     *         A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
     *         </p>
     *         <p>
     *         A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the
     *         last crawler run.
     *         </p>
     *         <p>
     *         A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3
     *         events.
     * @see RecrawlBehavior
     */
    public final RecrawlBehavior recrawlBehavior() {
        return RecrawlBehavior.fromValue(recrawlBehavior);
    }

    /**
     * <p>
     * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last
     * crawler run.
     * </p>
     * <p>
     * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
     * </p>
     * <p>
     * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last
     * crawler run.
     * </p>
     * <p>
     * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recrawlBehavior}
     * will return {@link RecrawlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recrawlBehaviorAsString}.
     * </p>
     * 
     * @return Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the
     *         last crawler run.</p>
     *         <p>
     *         A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
     *         </p>
     *         <p>
     *         A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the
     *         last crawler run.
     *         </p>
     *         <p>
     *         A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3
     *         events.
     * @see RecrawlBehavior
     */
    public final String recrawlBehaviorAsString() {
        return recrawlBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recrawlBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecrawlPolicy)) {
            return false;
        }
        RecrawlPolicy other = (RecrawlPolicy) obj;
        return Objects.equals(recrawlBehaviorAsString(), other.recrawlBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecrawlPolicy").add("RecrawlBehavior", recrawlBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecrawlBehavior":
            return Optional.ofNullable(clazz.cast(recrawlBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecrawlPolicy, T> g) {
        return obj -> g.apply((RecrawlPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecrawlPolicy> {
        /**
         * <p>
         * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last
         * crawler run.
         * </p>
         * <p>
         * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         * </p>
         * <p>
         * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last
         * crawler run.
         * </p>
         * <p>
         * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
         * </p>
         * 
         * @param recrawlBehavior
         *        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the
         *        last crawler run.</p>
         *        <p>
         *        A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         *        </p>
         *        <p>
         *        A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since
         *        the last crawler run.
         *        </p>
         *        <p>
         *        A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3
         *        events.
         * @see RecrawlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecrawlBehavior
         */
        Builder recrawlBehavior(String recrawlBehavior);

        /**
         * <p>
         * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last
         * crawler run.
         * </p>
         * <p>
         * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         * </p>
         * <p>
         * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last
         * crawler run.
         * </p>
         * <p>
         * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
         * </p>
         * 
         * @param recrawlBehavior
         *        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the
         *        last crawler run.</p>
         *        <p>
         *        A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         *        </p>
         *        <p>
         *        A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since
         *        the last crawler run.
         *        </p>
         *        <p>
         *        A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3
         *        events.
         * @see RecrawlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecrawlBehavior
         */
        Builder recrawlBehavior(RecrawlBehavior recrawlBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String recrawlBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(RecrawlPolicy model) {
            recrawlBehavior(model.recrawlBehavior);
        }

        public final String getRecrawlBehavior() {
            return recrawlBehavior;
        }

        public final void setRecrawlBehavior(String recrawlBehavior) {
            this.recrawlBehavior = recrawlBehavior;
        }

        @Override
        public final Builder recrawlBehavior(String recrawlBehavior) {
            this.recrawlBehavior = recrawlBehavior;
            return this;
        }

        @Override
        public final Builder recrawlBehavior(RecrawlBehavior recrawlBehavior) {
            this.recrawlBehavior(recrawlBehavior == null ? null : recrawlBehavior.toString());
            return this;
        }

        @Override
        public RecrawlPolicy build() {
            return new RecrawlPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
