/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;

public class GetMLTaskRunsIterable
implements SdkIterable<GetMlTaskRunsResponse> {
    private final GlueClient client;
    private final GetMlTaskRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMLTaskRunsIterable(GlueClient client, GetMlTaskRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetMlTaskRunsResponseFetcher();
    }

    public Iterator<GetMlTaskRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetMlTaskRunsResponseFetcher
    implements SyncPageFetcher<GetMlTaskRunsResponse> {
        private GetMlTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetMlTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMlTaskRunsResponse nextPage(GetMlTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return GetMLTaskRunsIterable.this.client.getMLTaskRuns(GetMLTaskRunsIterable.this.firstRequest);
            }
            return GetMLTaskRunsIterable.this.client.getMLTaskRuns((GetMlTaskRunsRequest)((Object)GetMLTaskRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

