/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.FieldName;
import software.amazon.awssdk.services.glue.model.FilterOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrawlsFilter> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(CrawlsFilter.getter(CrawlsFilter::fieldNameAsString)).setter(CrawlsFilter.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> FILTER_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterOperator").getter(CrawlsFilter.getter(CrawlsFilter::filterOperatorAsString)).setter(CrawlsFilter.setter(Builder::filterOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperator").build()}).build();
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldValue").getter(CrawlsFilter.getter(CrawlsFilter::fieldValue)).setter(CrawlsFilter.setter(Builder::fieldValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, FILTER_OPERATOR_FIELD, FIELD_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String filterOperator;
    private final String fieldValue;

    private CrawlsFilter(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.filterOperator = builder.filterOperator;
        this.fieldValue = builder.fieldValue;
    }

    public final FieldName fieldName() {
        return FieldName.fromValue(this.fieldName);
    }

    public final String fieldNameAsString() {
        return this.fieldName;
    }

    public final FilterOperator filterOperator() {
        return FilterOperator.fromValue(this.filterOperator);
    }

    public final String filterOperatorAsString() {
        return this.filterOperator;
    }

    public final String fieldValue() {
        return this.fieldValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlsFilter)) {
            return false;
        }
        CrawlsFilter other = (CrawlsFilter)obj;
        return Objects.equals(this.fieldNameAsString(), other.fieldNameAsString()) && Objects.equals(this.filterOperatorAsString(), other.filterOperatorAsString()) && Objects.equals(this.fieldValue(), other.fieldValue());
    }

    public final String toString() {
        return ToString.builder((String)"CrawlsFilter").add("FieldName", (Object)this.fieldNameAsString()).add("FilterOperator", (Object)this.filterOperatorAsString()).add("FieldValue", (Object)this.fieldValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldNameAsString()));
            }
            case "FilterOperator": {
                return Optional.ofNullable(clazz.cast(this.filterOperatorAsString()));
            }
            case "FieldValue": {
                return Optional.ofNullable(clazz.cast(this.fieldValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlsFilter, T> g) {
        return obj -> g.apply((CrawlsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String filterOperator;
        private String fieldValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlsFilter model) {
            this.fieldName(model.fieldName);
            this.filterOperator(model.filterOperator);
            this.fieldValue(model.fieldValue);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(FieldName fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final String getFilterOperator() {
            return this.filterOperator;
        }

        public final void setFilterOperator(String filterOperator) {
            this.filterOperator = filterOperator;
        }

        @Override
        public final Builder filterOperator(String filterOperator) {
            this.filterOperator = filterOperator;
            return this;
        }

        @Override
        public final Builder filterOperator(FilterOperator filterOperator) {
            this.filterOperator(filterOperator == null ? null : filterOperator.toString());
            return this;
        }

        public final String getFieldValue() {
            return this.fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public CrawlsFilter build() {
            return new CrawlsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrawlsFilter> {
        public Builder fieldName(String var1);

        public Builder fieldName(FieldName var1);

        public Builder filterOperator(String var1);

        public Builder filterOperator(FilterOperator var1);

        public Builder fieldValue(String var1);
    }
}

