/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that locates records in the dataset that have missing values and adds a new field with a value
 * determined by imputation. The input data set is used to train the machine learning model that determines what the
 * missing value should be.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FillMissingValues implements SdkPojo, Serializable,
        ToCopyableBuilder<FillMissingValues.Builder, FillMissingValues> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FillMissingValues::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(FillMissingValues::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPUTED_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImputedPath").getter(getter(FillMissingValues::imputedPath)).setter(setter(Builder::imputedPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImputedPath").build()).build();

    private static final SdkField<String> FILLED_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilledPath").getter(getter(FillMissingValues::filledPath)).setter(setter(Builder::filledPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilledPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            IMPUTED_PATH_FIELD, FILLED_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String imputedPath;

    private final String filledPath;

    private FillMissingValues(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.imputedPath = builder.imputedPath;
        this.filledPath = builder.filledPath;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A JSON path to a variable in the data structure for the dataset that is imputed.
     * </p>
     * 
     * @return A JSON path to a variable in the data structure for the dataset that is imputed.
     */
    public final String imputedPath() {
        return imputedPath;
    }

    /**
     * <p>
     * A JSON path to a variable in the data structure for the dataset that is filled.
     * </p>
     * 
     * @return A JSON path to a variable in the data structure for the dataset that is filled.
     */
    public final String filledPath() {
        return filledPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imputedPath());
        hashCode = 31 * hashCode + Objects.hashCode(filledPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FillMissingValues)) {
            return false;
        }
        FillMissingValues other = (FillMissingValues) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(imputedPath(), other.imputedPath())
                && Objects.equals(filledPath(), other.filledPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FillMissingValues").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("ImputedPath", imputedPath()).add("FilledPath", filledPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "ImputedPath":
            return Optional.ofNullable(clazz.cast(imputedPath()));
        case "FilledPath":
            return Optional.ofNullable(clazz.cast(filledPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FillMissingValues, T> g) {
        return obj -> g.apply((FillMissingValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FillMissingValues> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the dataset that is imputed.
         * </p>
         * 
         * @param imputedPath
         *        A JSON path to a variable in the data structure for the dataset that is imputed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imputedPath(String imputedPath);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the dataset that is filled.
         * </p>
         * 
         * @param filledPath
         *        A JSON path to a variable in the data structure for the dataset that is filled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filledPath(String filledPath);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String imputedPath;

        private String filledPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FillMissingValues model) {
            name(model.name);
            inputs(model.inputs);
            imputedPath(model.imputedPath);
            filledPath(model.filledPath);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getImputedPath() {
            return imputedPath;
        }

        public final void setImputedPath(String imputedPath) {
            this.imputedPath = imputedPath;
        }

        @Override
        public final Builder imputedPath(String imputedPath) {
            this.imputedPath = imputedPath;
            return this;
        }

        public final String getFilledPath() {
            return filledPath;
        }

        public final void setFilledPath(String filledPath) {
            this.filledPath = filledPath;
        }

        @Override
        public final Builder filledPath(String filledPath) {
            this.filledPath = filledPath;
            return this;
        }

        @Override
        public FillMissingValues build() {
            return new FillMissingValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
