/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>CodeGenConfigurationNode</code> enumerates all valid Node types. One and only one of its member variables can
 * be populated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeGenConfigurationNode implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeGenConfigurationNode.Builder, CodeGenConfigurationNode> {
    private static final SdkField<AthenaConnectorSource> ATHENA_CONNECTOR_SOURCE_FIELD = SdkField
            .<AthenaConnectorSource> builder(MarshallingType.SDK_POJO).memberName("AthenaConnectorSource")
            .getter(getter(CodeGenConfigurationNode::athenaConnectorSource)).setter(setter(Builder::athenaConnectorSource))
            .constructor(AthenaConnectorSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaConnectorSource").build())
            .build();

    private static final SdkField<JDBCConnectorSource> JDBC_CONNECTOR_SOURCE_FIELD = SdkField
            .<JDBCConnectorSource> builder(MarshallingType.SDK_POJO).memberName("JDBCConnectorSource")
            .getter(getter(CodeGenConfigurationNode::jdbcConnectorSource)).setter(setter(Builder::jdbcConnectorSource))
            .constructor(JDBCConnectorSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JDBCConnectorSource").build())
            .build();

    private static final SdkField<SparkConnectorSource> SPARK_CONNECTOR_SOURCE_FIELD = SdkField
            .<SparkConnectorSource> builder(MarshallingType.SDK_POJO).memberName("SparkConnectorSource")
            .getter(getter(CodeGenConfigurationNode::sparkConnectorSource)).setter(setter(Builder::sparkConnectorSource))
            .constructor(SparkConnectorSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkConnectorSource").build())
            .build();

    private static final SdkField<CatalogSource> CATALOG_SOURCE_FIELD = SdkField
            .<CatalogSource> builder(MarshallingType.SDK_POJO).memberName("CatalogSource")
            .getter(getter(CodeGenConfigurationNode::catalogSource)).setter(setter(Builder::catalogSource))
            .constructor(CatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogSource").build()).build();

    private static final SdkField<RedshiftSource> REDSHIFT_SOURCE_FIELD = SdkField
            .<RedshiftSource> builder(MarshallingType.SDK_POJO).memberName("RedshiftSource")
            .getter(getter(CodeGenConfigurationNode::redshiftSource)).setter(setter(Builder::redshiftSource))
            .constructor(RedshiftSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSource").build()).build();

    private static final SdkField<S3CatalogSource> S3_CATALOG_SOURCE_FIELD = SdkField
            .<S3CatalogSource> builder(MarshallingType.SDK_POJO).memberName("S3CatalogSource")
            .getter(getter(CodeGenConfigurationNode::s3CatalogSource)).setter(setter(Builder::s3CatalogSource))
            .constructor(S3CatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CatalogSource").build()).build();

    private static final SdkField<S3CsvSource> S3_CSV_SOURCE_FIELD = SdkField.<S3CsvSource> builder(MarshallingType.SDK_POJO)
            .memberName("S3CsvSource").getter(getter(CodeGenConfigurationNode::s3CsvSource)).setter(setter(Builder::s3CsvSource))
            .constructor(S3CsvSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CsvSource").build()).build();

    private static final SdkField<S3JsonSource> S3_JSON_SOURCE_FIELD = SdkField.<S3JsonSource> builder(MarshallingType.SDK_POJO)
            .memberName("S3JsonSource").getter(getter(CodeGenConfigurationNode::s3JsonSource))
            .setter(setter(Builder::s3JsonSource)).constructor(S3JsonSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3JsonSource").build()).build();

    private static final SdkField<S3ParquetSource> S3_PARQUET_SOURCE_FIELD = SdkField
            .<S3ParquetSource> builder(MarshallingType.SDK_POJO).memberName("S3ParquetSource")
            .getter(getter(CodeGenConfigurationNode::s3ParquetSource)).setter(setter(Builder::s3ParquetSource))
            .constructor(S3ParquetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ParquetSource").build()).build();

    private static final SdkField<RelationalCatalogSource> RELATIONAL_CATALOG_SOURCE_FIELD = SdkField
            .<RelationalCatalogSource> builder(MarshallingType.SDK_POJO).memberName("RelationalCatalogSource")
            .getter(getter(CodeGenConfigurationNode::relationalCatalogSource)).setter(setter(Builder::relationalCatalogSource))
            .constructor(RelationalCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationalCatalogSource").build())
            .build();

    private static final SdkField<DynamoDBCatalogSource> DYNAMO_DB_CATALOG_SOURCE_FIELD = SdkField
            .<DynamoDBCatalogSource> builder(MarshallingType.SDK_POJO).memberName("DynamoDBCatalogSource")
            .getter(getter(CodeGenConfigurationNode::dynamoDBCatalogSource)).setter(setter(Builder::dynamoDBCatalogSource))
            .constructor(DynamoDBCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBCatalogSource").build())
            .build();

    private static final SdkField<JDBCConnectorTarget> JDBC_CONNECTOR_TARGET_FIELD = SdkField
            .<JDBCConnectorTarget> builder(MarshallingType.SDK_POJO).memberName("JDBCConnectorTarget")
            .getter(getter(CodeGenConfigurationNode::jdbcConnectorTarget)).setter(setter(Builder::jdbcConnectorTarget))
            .constructor(JDBCConnectorTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JDBCConnectorTarget").build())
            .build();

    private static final SdkField<SparkConnectorTarget> SPARK_CONNECTOR_TARGET_FIELD = SdkField
            .<SparkConnectorTarget> builder(MarshallingType.SDK_POJO).memberName("SparkConnectorTarget")
            .getter(getter(CodeGenConfigurationNode::sparkConnectorTarget)).setter(setter(Builder::sparkConnectorTarget))
            .constructor(SparkConnectorTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkConnectorTarget").build())
            .build();

    private static final SdkField<BasicCatalogTarget> CATALOG_TARGET_FIELD = SdkField
            .<BasicCatalogTarget> builder(MarshallingType.SDK_POJO).memberName("CatalogTarget")
            .getter(getter(CodeGenConfigurationNode::catalogTarget)).setter(setter(Builder::catalogTarget))
            .constructor(BasicCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogTarget").build()).build();

    private static final SdkField<RedshiftTarget> REDSHIFT_TARGET_FIELD = SdkField
            .<RedshiftTarget> builder(MarshallingType.SDK_POJO).memberName("RedshiftTarget")
            .getter(getter(CodeGenConfigurationNode::redshiftTarget)).setter(setter(Builder::redshiftTarget))
            .constructor(RedshiftTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTarget").build()).build();

    private static final SdkField<S3CatalogTarget> S3_CATALOG_TARGET_FIELD = SdkField
            .<S3CatalogTarget> builder(MarshallingType.SDK_POJO).memberName("S3CatalogTarget")
            .getter(getter(CodeGenConfigurationNode::s3CatalogTarget)).setter(setter(Builder::s3CatalogTarget))
            .constructor(S3CatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CatalogTarget").build()).build();

    private static final SdkField<S3GlueParquetTarget> S3_GLUE_PARQUET_TARGET_FIELD = SdkField
            .<S3GlueParquetTarget> builder(MarshallingType.SDK_POJO).memberName("S3GlueParquetTarget")
            .getter(getter(CodeGenConfigurationNode::s3GlueParquetTarget)).setter(setter(Builder::s3GlueParquetTarget))
            .constructor(S3GlueParquetTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3GlueParquetTarget").build())
            .build();

    private static final SdkField<S3DirectTarget> S3_DIRECT_TARGET_FIELD = SdkField
            .<S3DirectTarget> builder(MarshallingType.SDK_POJO).memberName("S3DirectTarget")
            .getter(getter(CodeGenConfigurationNode::s3DirectTarget)).setter(setter(Builder::s3DirectTarget))
            .constructor(S3DirectTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DirectTarget").build()).build();

    private static final SdkField<ApplyMapping> APPLY_MAPPING_FIELD = SdkField.<ApplyMapping> builder(MarshallingType.SDK_POJO)
            .memberName("ApplyMapping").getter(getter(CodeGenConfigurationNode::applyMapping))
            .setter(setter(Builder::applyMapping)).constructor(ApplyMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyMapping").build()).build();

    private static final SdkField<SelectFields> SELECT_FIELDS_FIELD = SdkField.<SelectFields> builder(MarshallingType.SDK_POJO)
            .memberName("SelectFields").getter(getter(CodeGenConfigurationNode::selectFields))
            .setter(setter(Builder::selectFields)).constructor(SelectFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectFields").build()).build();

    private static final SdkField<DropFields> DROP_FIELDS_FIELD = SdkField.<DropFields> builder(MarshallingType.SDK_POJO)
            .memberName("DropFields").getter(getter(CodeGenConfigurationNode::dropFields)).setter(setter(Builder::dropFields))
            .constructor(DropFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DropFields").build()).build();

    private static final SdkField<RenameField> RENAME_FIELD_FIELD = SdkField.<RenameField> builder(MarshallingType.SDK_POJO)
            .memberName("RenameField").getter(getter(CodeGenConfigurationNode::renameField)).setter(setter(Builder::renameField))
            .constructor(RenameField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameField").build()).build();

    private static final SdkField<Spigot> SPIGOT_FIELD = SdkField.<Spigot> builder(MarshallingType.SDK_POJO).memberName("Spigot")
            .getter(getter(CodeGenConfigurationNode::spigot)).setter(setter(Builder::spigot)).constructor(Spigot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spigot").build()).build();

    private static final SdkField<Join> JOIN_FIELD = SdkField.<Join> builder(MarshallingType.SDK_POJO).memberName("Join")
            .getter(getter(CodeGenConfigurationNode::join)).setter(setter(Builder::join)).constructor(Join::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Join").build()).build();

    private static final SdkField<SplitFields> SPLIT_FIELDS_FIELD = SdkField.<SplitFields> builder(MarshallingType.SDK_POJO)
            .memberName("SplitFields").getter(getter(CodeGenConfigurationNode::splitFields)).setter(setter(Builder::splitFields))
            .constructor(SplitFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitFields").build()).build();

    private static final SdkField<SelectFromCollection> SELECT_FROM_COLLECTION_FIELD = SdkField
            .<SelectFromCollection> builder(MarshallingType.SDK_POJO).memberName("SelectFromCollection")
            .getter(getter(CodeGenConfigurationNode::selectFromCollection)).setter(setter(Builder::selectFromCollection))
            .constructor(SelectFromCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectFromCollection").build())
            .build();

    private static final SdkField<FillMissingValues> FILL_MISSING_VALUES_FIELD = SdkField
            .<FillMissingValues> builder(MarshallingType.SDK_POJO).memberName("FillMissingValues")
            .getter(getter(CodeGenConfigurationNode::fillMissingValues)).setter(setter(Builder::fillMissingValues))
            .constructor(FillMissingValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillMissingValues").build()).build();

    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(CodeGenConfigurationNode::filter)).setter(setter(Builder::filter)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<CustomCode> CUSTOM_CODE_FIELD = SdkField.<CustomCode> builder(MarshallingType.SDK_POJO)
            .memberName("CustomCode").getter(getter(CodeGenConfigurationNode::customCode)).setter(setter(Builder::customCode))
            .constructor(CustomCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCode").build()).build();

    private static final SdkField<SparkSQL> SPARK_SQL_FIELD = SdkField.<SparkSQL> builder(MarshallingType.SDK_POJO)
            .memberName("SparkSQL").getter(getter(CodeGenConfigurationNode::sparkSQL)).setter(setter(Builder::sparkSQL))
            .constructor(SparkSQL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkSQL").build()).build();

    private static final SdkField<DirectKinesisSource> DIRECT_KINESIS_SOURCE_FIELD = SdkField
            .<DirectKinesisSource> builder(MarshallingType.SDK_POJO).memberName("DirectKinesisSource")
            .getter(getter(CodeGenConfigurationNode::directKinesisSource)).setter(setter(Builder::directKinesisSource))
            .constructor(DirectKinesisSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectKinesisSource").build())
            .build();

    private static final SdkField<DirectKafkaSource> DIRECT_KAFKA_SOURCE_FIELD = SdkField
            .<DirectKafkaSource> builder(MarshallingType.SDK_POJO).memberName("DirectKafkaSource")
            .getter(getter(CodeGenConfigurationNode::directKafkaSource)).setter(setter(Builder::directKafkaSource))
            .constructor(DirectKafkaSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectKafkaSource").build()).build();

    private static final SdkField<CatalogKinesisSource> CATALOG_KINESIS_SOURCE_FIELD = SdkField
            .<CatalogKinesisSource> builder(MarshallingType.SDK_POJO).memberName("CatalogKinesisSource")
            .getter(getter(CodeGenConfigurationNode::catalogKinesisSource)).setter(setter(Builder::catalogKinesisSource))
            .constructor(CatalogKinesisSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogKinesisSource").build())
            .build();

    private static final SdkField<CatalogKafkaSource> CATALOG_KAFKA_SOURCE_FIELD = SdkField
            .<CatalogKafkaSource> builder(MarshallingType.SDK_POJO).memberName("CatalogKafkaSource")
            .getter(getter(CodeGenConfigurationNode::catalogKafkaSource)).setter(setter(Builder::catalogKafkaSource))
            .constructor(CatalogKafkaSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogKafkaSource").build())
            .build();

    private static final SdkField<DropNullFields> DROP_NULL_FIELDS_FIELD = SdkField
            .<DropNullFields> builder(MarshallingType.SDK_POJO).memberName("DropNullFields")
            .getter(getter(CodeGenConfigurationNode::dropNullFields)).setter(setter(Builder::dropNullFields))
            .constructor(DropNullFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DropNullFields").build()).build();

    private static final SdkField<Merge> MERGE_FIELD = SdkField.<Merge> builder(MarshallingType.SDK_POJO).memberName("Merge")
            .getter(getter(CodeGenConfigurationNode::merge)).setter(setter(Builder::merge)).constructor(Merge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Merge").build()).build();

    private static final SdkField<Union> UNION_FIELD = SdkField.<Union> builder(MarshallingType.SDK_POJO).memberName("Union")
            .getter(getter(CodeGenConfigurationNode::union)).setter(setter(Builder::union)).constructor(Union::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Union").build()).build();

    private static final SdkField<PIIDetection> PII_DETECTION_FIELD = SdkField.<PIIDetection> builder(MarshallingType.SDK_POJO)
            .memberName("PIIDetection").getter(getter(CodeGenConfigurationNode::piiDetection))
            .setter(setter(Builder::piiDetection)).constructor(PIIDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PIIDetection").build()).build();

    private static final SdkField<Aggregate> AGGREGATE_FIELD = SdkField.<Aggregate> builder(MarshallingType.SDK_POJO)
            .memberName("Aggregate").getter(getter(CodeGenConfigurationNode::aggregate)).setter(setter(Builder::aggregate))
            .constructor(Aggregate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregate").build()).build();

    private static final SdkField<DropDuplicates> DROP_DUPLICATES_FIELD = SdkField
            .<DropDuplicates> builder(MarshallingType.SDK_POJO).memberName("DropDuplicates")
            .getter(getter(CodeGenConfigurationNode::dropDuplicates)).setter(setter(Builder::dropDuplicates))
            .constructor(DropDuplicates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DropDuplicates").build()).build();

    private static final SdkField<GovernedCatalogTarget> GOVERNED_CATALOG_TARGET_FIELD = SdkField
            .<GovernedCatalogTarget> builder(MarshallingType.SDK_POJO).memberName("GovernedCatalogTarget")
            .getter(getter(CodeGenConfigurationNode::governedCatalogTarget)).setter(setter(Builder::governedCatalogTarget))
            .constructor(GovernedCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GovernedCatalogTarget").build())
            .build();

    private static final SdkField<GovernedCatalogSource> GOVERNED_CATALOG_SOURCE_FIELD = SdkField
            .<GovernedCatalogSource> builder(MarshallingType.SDK_POJO).memberName("GovernedCatalogSource")
            .getter(getter(CodeGenConfigurationNode::governedCatalogSource)).setter(setter(Builder::governedCatalogSource))
            .constructor(GovernedCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GovernedCatalogSource").build())
            .build();

    private static final SdkField<MicrosoftSQLServerCatalogSource> MICROSOFT_SQL_SERVER_CATALOG_SOURCE_FIELD = SdkField
            .<MicrosoftSQLServerCatalogSource> builder(MarshallingType.SDK_POJO)
            .memberName("MicrosoftSQLServerCatalogSource")
            .getter(getter(CodeGenConfigurationNode::microsoftSQLServerCatalogSource))
            .setter(setter(Builder::microsoftSQLServerCatalogSource))
            .constructor(MicrosoftSQLServerCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSQLServerCatalogSource")
                    .build()).build();

    private static final SdkField<MySQLCatalogSource> MY_SQL_CATALOG_SOURCE_FIELD = SdkField
            .<MySQLCatalogSource> builder(MarshallingType.SDK_POJO).memberName("MySQLCatalogSource")
            .getter(getter(CodeGenConfigurationNode::mySQLCatalogSource)).setter(setter(Builder::mySQLCatalogSource))
            .constructor(MySQLCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySQLCatalogSource").build())
            .build();

    private static final SdkField<OracleSQLCatalogSource> ORACLE_SQL_CATALOG_SOURCE_FIELD = SdkField
            .<OracleSQLCatalogSource> builder(MarshallingType.SDK_POJO).memberName("OracleSQLCatalogSource")
            .getter(getter(CodeGenConfigurationNode::oracleSQLCatalogSource)).setter(setter(Builder::oracleSQLCatalogSource))
            .constructor(OracleSQLCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSQLCatalogSource").build())
            .build();

    private static final SdkField<PostgreSQLCatalogSource> POSTGRE_SQL_CATALOG_SOURCE_FIELD = SdkField
            .<PostgreSQLCatalogSource> builder(MarshallingType.SDK_POJO).memberName("PostgreSQLCatalogSource")
            .getter(getter(CodeGenConfigurationNode::postgreSQLCatalogSource)).setter(setter(Builder::postgreSQLCatalogSource))
            .constructor(PostgreSQLCatalogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSQLCatalogSource").build())
            .build();

    private static final SdkField<MicrosoftSQLServerCatalogTarget> MICROSOFT_SQL_SERVER_CATALOG_TARGET_FIELD = SdkField
            .<MicrosoftSQLServerCatalogTarget> builder(MarshallingType.SDK_POJO)
            .memberName("MicrosoftSQLServerCatalogTarget")
            .getter(getter(CodeGenConfigurationNode::microsoftSQLServerCatalogTarget))
            .setter(setter(Builder::microsoftSQLServerCatalogTarget))
            .constructor(MicrosoftSQLServerCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSQLServerCatalogTarget")
                    .build()).build();

    private static final SdkField<MySQLCatalogTarget> MY_SQL_CATALOG_TARGET_FIELD = SdkField
            .<MySQLCatalogTarget> builder(MarshallingType.SDK_POJO).memberName("MySQLCatalogTarget")
            .getter(getter(CodeGenConfigurationNode::mySQLCatalogTarget)).setter(setter(Builder::mySQLCatalogTarget))
            .constructor(MySQLCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySQLCatalogTarget").build())
            .build();

    private static final SdkField<OracleSQLCatalogTarget> ORACLE_SQL_CATALOG_TARGET_FIELD = SdkField
            .<OracleSQLCatalogTarget> builder(MarshallingType.SDK_POJO).memberName("OracleSQLCatalogTarget")
            .getter(getter(CodeGenConfigurationNode::oracleSQLCatalogTarget)).setter(setter(Builder::oracleSQLCatalogTarget))
            .constructor(OracleSQLCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSQLCatalogTarget").build())
            .build();

    private static final SdkField<PostgreSQLCatalogTarget> POSTGRE_SQL_CATALOG_TARGET_FIELD = SdkField
            .<PostgreSQLCatalogTarget> builder(MarshallingType.SDK_POJO).memberName("PostgreSQLCatalogTarget")
            .getter(getter(CodeGenConfigurationNode::postgreSQLCatalogTarget)).setter(setter(Builder::postgreSQLCatalogTarget))
            .constructor(PostgreSQLCatalogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSQLCatalogTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_CONNECTOR_SOURCE_FIELD,
            JDBC_CONNECTOR_SOURCE_FIELD, SPARK_CONNECTOR_SOURCE_FIELD, CATALOG_SOURCE_FIELD, REDSHIFT_SOURCE_FIELD,
            S3_CATALOG_SOURCE_FIELD, S3_CSV_SOURCE_FIELD, S3_JSON_SOURCE_FIELD, S3_PARQUET_SOURCE_FIELD,
            RELATIONAL_CATALOG_SOURCE_FIELD, DYNAMO_DB_CATALOG_SOURCE_FIELD, JDBC_CONNECTOR_TARGET_FIELD,
            SPARK_CONNECTOR_TARGET_FIELD, CATALOG_TARGET_FIELD, REDSHIFT_TARGET_FIELD, S3_CATALOG_TARGET_FIELD,
            S3_GLUE_PARQUET_TARGET_FIELD, S3_DIRECT_TARGET_FIELD, APPLY_MAPPING_FIELD, SELECT_FIELDS_FIELD, DROP_FIELDS_FIELD,
            RENAME_FIELD_FIELD, SPIGOT_FIELD, JOIN_FIELD, SPLIT_FIELDS_FIELD, SELECT_FROM_COLLECTION_FIELD,
            FILL_MISSING_VALUES_FIELD, FILTER_FIELD, CUSTOM_CODE_FIELD, SPARK_SQL_FIELD, DIRECT_KINESIS_SOURCE_FIELD,
            DIRECT_KAFKA_SOURCE_FIELD, CATALOG_KINESIS_SOURCE_FIELD, CATALOG_KAFKA_SOURCE_FIELD, DROP_NULL_FIELDS_FIELD,
            MERGE_FIELD, UNION_FIELD, PII_DETECTION_FIELD, AGGREGATE_FIELD, DROP_DUPLICATES_FIELD, GOVERNED_CATALOG_TARGET_FIELD,
            GOVERNED_CATALOG_SOURCE_FIELD, MICROSOFT_SQL_SERVER_CATALOG_SOURCE_FIELD, MY_SQL_CATALOG_SOURCE_FIELD,
            ORACLE_SQL_CATALOG_SOURCE_FIELD, POSTGRE_SQL_CATALOG_SOURCE_FIELD, MICROSOFT_SQL_SERVER_CATALOG_TARGET_FIELD,
            MY_SQL_CATALOG_TARGET_FIELD, ORACLE_SQL_CATALOG_TARGET_FIELD, POSTGRE_SQL_CATALOG_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final AthenaConnectorSource athenaConnectorSource;

    private final JDBCConnectorSource jdbcConnectorSource;

    private final SparkConnectorSource sparkConnectorSource;

    private final CatalogSource catalogSource;

    private final RedshiftSource redshiftSource;

    private final S3CatalogSource s3CatalogSource;

    private final S3CsvSource s3CsvSource;

    private final S3JsonSource s3JsonSource;

    private final S3ParquetSource s3ParquetSource;

    private final RelationalCatalogSource relationalCatalogSource;

    private final DynamoDBCatalogSource dynamoDBCatalogSource;

    private final JDBCConnectorTarget jdbcConnectorTarget;

    private final SparkConnectorTarget sparkConnectorTarget;

    private final BasicCatalogTarget catalogTarget;

    private final RedshiftTarget redshiftTarget;

    private final S3CatalogTarget s3CatalogTarget;

    private final S3GlueParquetTarget s3GlueParquetTarget;

    private final S3DirectTarget s3DirectTarget;

    private final ApplyMapping applyMapping;

    private final SelectFields selectFields;

    private final DropFields dropFields;

    private final RenameField renameField;

    private final Spigot spigot;

    private final Join join;

    private final SplitFields splitFields;

    private final SelectFromCollection selectFromCollection;

    private final FillMissingValues fillMissingValues;

    private final Filter filter;

    private final CustomCode customCode;

    private final SparkSQL sparkSQL;

    private final DirectKinesisSource directKinesisSource;

    private final DirectKafkaSource directKafkaSource;

    private final CatalogKinesisSource catalogKinesisSource;

    private final CatalogKafkaSource catalogKafkaSource;

    private final DropNullFields dropNullFields;

    private final Merge merge;

    private final Union union;

    private final PIIDetection piiDetection;

    private final Aggregate aggregate;

    private final DropDuplicates dropDuplicates;

    private final GovernedCatalogTarget governedCatalogTarget;

    private final GovernedCatalogSource governedCatalogSource;

    private final MicrosoftSQLServerCatalogSource microsoftSQLServerCatalogSource;

    private final MySQLCatalogSource mySQLCatalogSource;

    private final OracleSQLCatalogSource oracleSQLCatalogSource;

    private final PostgreSQLCatalogSource postgreSQLCatalogSource;

    private final MicrosoftSQLServerCatalogTarget microsoftSQLServerCatalogTarget;

    private final MySQLCatalogTarget mySQLCatalogTarget;

    private final OracleSQLCatalogTarget oracleSQLCatalogTarget;

    private final PostgreSQLCatalogTarget postgreSQLCatalogTarget;

    private CodeGenConfigurationNode(BuilderImpl builder) {
        this.athenaConnectorSource = builder.athenaConnectorSource;
        this.jdbcConnectorSource = builder.jdbcConnectorSource;
        this.sparkConnectorSource = builder.sparkConnectorSource;
        this.catalogSource = builder.catalogSource;
        this.redshiftSource = builder.redshiftSource;
        this.s3CatalogSource = builder.s3CatalogSource;
        this.s3CsvSource = builder.s3CsvSource;
        this.s3JsonSource = builder.s3JsonSource;
        this.s3ParquetSource = builder.s3ParquetSource;
        this.relationalCatalogSource = builder.relationalCatalogSource;
        this.dynamoDBCatalogSource = builder.dynamoDBCatalogSource;
        this.jdbcConnectorTarget = builder.jdbcConnectorTarget;
        this.sparkConnectorTarget = builder.sparkConnectorTarget;
        this.catalogTarget = builder.catalogTarget;
        this.redshiftTarget = builder.redshiftTarget;
        this.s3CatalogTarget = builder.s3CatalogTarget;
        this.s3GlueParquetTarget = builder.s3GlueParquetTarget;
        this.s3DirectTarget = builder.s3DirectTarget;
        this.applyMapping = builder.applyMapping;
        this.selectFields = builder.selectFields;
        this.dropFields = builder.dropFields;
        this.renameField = builder.renameField;
        this.spigot = builder.spigot;
        this.join = builder.join;
        this.splitFields = builder.splitFields;
        this.selectFromCollection = builder.selectFromCollection;
        this.fillMissingValues = builder.fillMissingValues;
        this.filter = builder.filter;
        this.customCode = builder.customCode;
        this.sparkSQL = builder.sparkSQL;
        this.directKinesisSource = builder.directKinesisSource;
        this.directKafkaSource = builder.directKafkaSource;
        this.catalogKinesisSource = builder.catalogKinesisSource;
        this.catalogKafkaSource = builder.catalogKafkaSource;
        this.dropNullFields = builder.dropNullFields;
        this.merge = builder.merge;
        this.union = builder.union;
        this.piiDetection = builder.piiDetection;
        this.aggregate = builder.aggregate;
        this.dropDuplicates = builder.dropDuplicates;
        this.governedCatalogTarget = builder.governedCatalogTarget;
        this.governedCatalogSource = builder.governedCatalogSource;
        this.microsoftSQLServerCatalogSource = builder.microsoftSQLServerCatalogSource;
        this.mySQLCatalogSource = builder.mySQLCatalogSource;
        this.oracleSQLCatalogSource = builder.oracleSQLCatalogSource;
        this.postgreSQLCatalogSource = builder.postgreSQLCatalogSource;
        this.microsoftSQLServerCatalogTarget = builder.microsoftSQLServerCatalogTarget;
        this.mySQLCatalogTarget = builder.mySQLCatalogTarget;
        this.oracleSQLCatalogTarget = builder.oracleSQLCatalogTarget;
        this.postgreSQLCatalogTarget = builder.postgreSQLCatalogTarget;
    }

    /**
     * <p>
     * Specifies a connector to an Amazon Athena data source.
     * </p>
     * 
     * @return Specifies a connector to an Amazon Athena data source.
     */
    public final AthenaConnectorSource athenaConnectorSource() {
        return athenaConnectorSource;
    }

    /**
     * <p>
     * Specifies a connector to a JDBC data source.
     * </p>
     * 
     * @return Specifies a connector to a JDBC data source.
     */
    public final JDBCConnectorSource jdbcConnectorSource() {
        return jdbcConnectorSource;
    }

    /**
     * <p>
     * Specifies a connector to an Apache Spark data source.
     * </p>
     * 
     * @return Specifies a connector to an Apache Spark data source.
     */
    public final SparkConnectorSource sparkConnectorSource() {
        return sparkConnectorSource;
    }

    /**
     * <p>
     * Specifies a data store in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a data store in the Glue Data Catalog.
     */
    public final CatalogSource catalogSource() {
        return catalogSource;
    }

    /**
     * <p>
     * Specifies an Amazon Redshift data store.
     * </p>
     * 
     * @return Specifies an Amazon Redshift data store.
     */
    public final RedshiftSource redshiftSource() {
        return redshiftSource;
    }

    /**
     * <p>
     * Specifies an Amazon S3 data store in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies an Amazon S3 data store in the Glue Data Catalog.
     */
    public final S3CatalogSource s3CatalogSource() {
        return s3CatalogSource;
    }

    /**
     * <p>
     * Specifies a command-separated value (CSV) data store stored in Amazon S3.
     * </p>
     * 
     * @return Specifies a command-separated value (CSV) data store stored in Amazon S3.
     */
    public final S3CsvSource s3CsvSource() {
        return s3CsvSource;
    }

    /**
     * <p>
     * Specifies a JSON data store stored in Amazon S3.
     * </p>
     * 
     * @return Specifies a JSON data store stored in Amazon S3.
     */
    public final S3JsonSource s3JsonSource() {
        return s3JsonSource;
    }

    /**
     * <p>
     * Specifies an Apache Parquet data store stored in Amazon S3.
     * </p>
     * 
     * @return Specifies an Apache Parquet data store stored in Amazon S3.
     */
    public final S3ParquetSource s3ParquetSource() {
        return s3ParquetSource;
    }

    /**
     * Returns the value of the RelationalCatalogSource property for this object.
     * 
     * @return The value of the RelationalCatalogSource property for this object.
     */
    public final RelationalCatalogSource relationalCatalogSource() {
        return relationalCatalogSource;
    }

    /**
     * Returns the value of the DynamoDBCatalogSource property for this object.
     * 
     * @return The value of the DynamoDBCatalogSource property for this object.
     */
    public final DynamoDBCatalogSource dynamoDBCatalogSource() {
        return dynamoDBCatalogSource;
    }

    /**
     * <p>
     * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
     * </p>
     * 
     * @return Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
     */
    public final JDBCConnectorTarget jdbcConnectorTarget() {
        return jdbcConnectorTarget;
    }

    /**
     * <p>
     * Specifies a target that uses an Apache Spark connector.
     * </p>
     * 
     * @return Specifies a target that uses an Apache Spark connector.
     */
    public final SparkConnectorTarget sparkConnectorTarget() {
        return sparkConnectorTarget;
    }

    /**
     * <p>
     * Specifies a target that uses a Glue Data Catalog table.
     * </p>
     * 
     * @return Specifies a target that uses a Glue Data Catalog table.
     */
    public final BasicCatalogTarget catalogTarget() {
        return catalogTarget;
    }

    /**
     * <p>
     * Specifies a target that uses Amazon Redshift.
     * </p>
     * 
     * @return Specifies a target that uses Amazon Redshift.
     */
    public final RedshiftTarget redshiftTarget() {
        return redshiftTarget;
    }

    /**
     * <p>
     * Specifies a data target that writes to Amazon S3 using the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a data target that writes to Amazon S3 using the Glue Data Catalog.
     */
    public final S3CatalogTarget s3CatalogTarget() {
        return s3CatalogTarget;
    }

    /**
     * <p>
     * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
     * </p>
     * 
     * @return Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
     */
    public final S3GlueParquetTarget s3GlueParquetTarget() {
        return s3GlueParquetTarget;
    }

    /**
     * <p>
     * Specifies a data target that writes to Amazon S3.
     * </p>
     * 
     * @return Specifies a data target that writes to Amazon S3.
     */
    public final S3DirectTarget s3DirectTarget() {
        return s3DirectTarget;
    }

    /**
     * <p>
     * Specifies a transform that maps data property keys in the data source to data property keys in the data target.
     * You can rename keys, modify the data types for keys, and choose which keys to drop from the dataset.
     * </p>
     * 
     * @return Specifies a transform that maps data property keys in the data source to data property keys in the data
     *         target. You can rename keys, modify the data types for keys, and choose which keys to drop from the
     *         dataset.
     */
    public final ApplyMapping applyMapping() {
        return applyMapping;
    }

    /**
     * <p>
     * Specifies a transform that chooses the data property keys that you want to keep.
     * </p>
     * 
     * @return Specifies a transform that chooses the data property keys that you want to keep.
     */
    public final SelectFields selectFields() {
        return selectFields;
    }

    /**
     * <p>
     * Specifies a transform that chooses the data property keys that you want to drop.
     * </p>
     * 
     * @return Specifies a transform that chooses the data property keys that you want to drop.
     */
    public final DropFields dropFields() {
        return dropFields;
    }

    /**
     * <p>
     * Specifies a transform that renames a single data property key.
     * </p>
     * 
     * @return Specifies a transform that renames a single data property key.
     */
    public final RenameField renameField() {
        return renameField;
    }

    /**
     * <p>
     * Specifies a transform that writes samples of the data to an Amazon S3 bucket.
     * </p>
     * 
     * @return Specifies a transform that writes samples of the data to an Amazon S3 bucket.
     */
    public final Spigot spigot() {
        return spigot;
    }

    /**
     * <p>
     * Specifies a transform that joins two datasets into one dataset using a comparison phrase on the specified data
     * property keys. You can use inner, outer, left, right, left semi, and left anti joins.
     * </p>
     * 
     * @return Specifies a transform that joins two datasets into one dataset using a comparison phrase on the specified
     *         data property keys. You can use inner, outer, left, right, left semi, and left anti joins.
     */
    public final Join join() {
        return join;
    }

    /**
     * <p>
     * Specifies a transform that splits data property keys into two <code>DynamicFrames</code>. The output is a
     * collection of <code>DynamicFrames</code>: one with selected data property keys, and one with the remaining data
     * property keys.
     * </p>
     * 
     * @return Specifies a transform that splits data property keys into two <code>DynamicFrames</code>. The output is a
     *         collection of <code>DynamicFrames</code>: one with selected data property keys, and one with the
     *         remaining data property keys.
     */
    public final SplitFields splitFields() {
        return splitFields;
    }

    /**
     * <p>
     * Specifies a transform that chooses one <code>DynamicFrame</code> from a collection of <code>DynamicFrames</code>.
     * The output is the selected <code>DynamicFrame</code>
     * </p>
     * 
     * @return Specifies a transform that chooses one <code>DynamicFrame</code> from a collection of
     *         <code>DynamicFrames</code>. The output is the selected <code>DynamicFrame</code>
     */
    public final SelectFromCollection selectFromCollection() {
        return selectFromCollection;
    }

    /**
     * <p>
     * Specifies a transform that locates records in the dataset that have missing values and adds a new field with a
     * value determined by imputation. The input data set is used to train the machine learning model that determines
     * what the missing value should be.
     * </p>
     * 
     * @return Specifies a transform that locates records in the dataset that have missing values and adds a new field
     *         with a value determined by imputation. The input data set is used to train the machine learning model
     *         that determines what the missing value should be.
     */
    public final FillMissingValues fillMissingValues() {
        return fillMissingValues;
    }

    /**
     * <p>
     * Specifies a transform that splits a dataset into two, based on a filter condition.
     * </p>
     * 
     * @return Specifies a transform that splits a dataset into two, based on a filter condition.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * <p>
     * Specifies a transform that uses custom code you provide to perform the data transformation. The output is a
     * collection of DynamicFrames.
     * </p>
     * 
     * @return Specifies a transform that uses custom code you provide to perform the data transformation. The output is
     *         a collection of DynamicFrames.
     */
    public final CustomCode customCode() {
        return customCode;
    }

    /**
     * <p>
     * Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The output is a
     * single <code>DynamicFrame</code>.
     * </p>
     * 
     * @return Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The
     *         output is a single <code>DynamicFrame</code>.
     */
    public final SparkSQL sparkSQL() {
        return sparkSQL;
    }

    /**
     * <p>
     * Specifies a direct Amazon Kinesis data source.
     * </p>
     * 
     * @return Specifies a direct Amazon Kinesis data source.
     */
    public final DirectKinesisSource directKinesisSource() {
        return directKinesisSource;
    }

    /**
     * <p>
     * Specifies an Apache Kafka data store.
     * </p>
     * 
     * @return Specifies an Apache Kafka data store.
     */
    public final DirectKafkaSource directKafkaSource() {
        return directKafkaSource;
    }

    /**
     * <p>
     * Specifies a Kinesis data source in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a Kinesis data source in the Glue Data Catalog.
     */
    public final CatalogKinesisSource catalogKinesisSource() {
        return catalogKinesisSource;
    }

    /**
     * <p>
     * Specifies an Apache Kafka data store in the Data Catalog.
     * </p>
     * 
     * @return Specifies an Apache Kafka data store in the Data Catalog.
     */
    public final CatalogKafkaSource catalogKafkaSource() {
        return catalogKafkaSource;
    }

    /**
     * <p>
     * Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By default,
     * Glue Studio will recognize null objects, but some values such as empty strings, strings that are "null", -1
     * integers or other placeholders such as zeros, are not automatically recognized as nulls.
     * </p>
     * 
     * @return Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By
     *         default, Glue Studio will recognize null objects, but some values such as empty strings, strings that are
     *         "null", -1 integers or other placeholders such as zeros, are not automatically recognized as nulls.
     */
    public final DropNullFields dropNullFields() {
        return dropNullFields;
    }

    /**
     * <p>
     * Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code> based on
     * the specified primary keys to identify records. Duplicate records (records with the same primary keys) are not
     * de-duplicated.
     * </p>
     * 
     * @return Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code>
     *         based on the specified primary keys to identify records. Duplicate records (records with the same primary
     *         keys) are not de-duplicated.
     */
    public final Merge merge() {
        return merge;
    }

    /**
     * <p>
     * Specifies a transform that combines the rows from two or more datasets into a single result.
     * </p>
     * 
     * @return Specifies a transform that combines the rows from two or more datasets into a single result.
     */
    public final Union union() {
        return union;
    }

    /**
     * <p>
     * Specifies a transform that identifies, removes or masks PII data.
     * </p>
     * 
     * @return Specifies a transform that identifies, removes or masks PII data.
     */
    public final PIIDetection piiDetection() {
        return piiDetection;
    }

    /**
     * <p>
     * Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified function.
     * </p>
     * 
     * @return Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified
     *         function.
     */
    public final Aggregate aggregate() {
        return aggregate;
    }

    /**
     * <p>
     * Specifies a transform that removes rows of repeating data from a data set.
     * </p>
     * 
     * @return Specifies a transform that removes rows of repeating data from a data set.
     */
    public final DropDuplicates dropDuplicates() {
        return dropDuplicates;
    }

    /**
     * <p>
     * Specifies a data target that writes to a goverened catalog.
     * </p>
     * 
     * @return Specifies a data target that writes to a goverened catalog.
     */
    public final GovernedCatalogTarget governedCatalogTarget() {
        return governedCatalogTarget;
    }

    /**
     * <p>
     * Specifies a data source in a goverened Data Catalog.
     * </p>
     * 
     * @return Specifies a data source in a goverened Data Catalog.
     */
    public final GovernedCatalogSource governedCatalogSource() {
        return governedCatalogSource;
    }

    /**
     * <p>
     * Specifies a Microsoft SQL server data source in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a Microsoft SQL server data source in the Glue Data Catalog.
     */
    public final MicrosoftSQLServerCatalogSource microsoftSQLServerCatalogSource() {
        return microsoftSQLServerCatalogSource;
    }

    /**
     * <p>
     * Specifies a MySQL data source in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a MySQL data source in the Glue Data Catalog.
     */
    public final MySQLCatalogSource mySQLCatalogSource() {
        return mySQLCatalogSource;
    }

    /**
     * <p>
     * Specifies an Oracle data source in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies an Oracle data source in the Glue Data Catalog.
     */
    public final OracleSQLCatalogSource oracleSQLCatalogSource() {
        return oracleSQLCatalogSource;
    }

    /**
     * <p>
     * Specifies a PostgresSQL data source in the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies a PostgresSQL data source in the Glue Data Catalog.
     */
    public final PostgreSQLCatalogSource postgreSQLCatalogSource() {
        return postgreSQLCatalogSource;
    }

    /**
     * <p>
     * Specifies a target that uses Microsoft SQL.
     * </p>
     * 
     * @return Specifies a target that uses Microsoft SQL.
     */
    public final MicrosoftSQLServerCatalogTarget microsoftSQLServerCatalogTarget() {
        return microsoftSQLServerCatalogTarget;
    }

    /**
     * <p>
     * Specifies a target that uses MySQL.
     * </p>
     * 
     * @return Specifies a target that uses MySQL.
     */
    public final MySQLCatalogTarget mySQLCatalogTarget() {
        return mySQLCatalogTarget;
    }

    /**
     * <p>
     * Specifies a target that uses Oracle SQL.
     * </p>
     * 
     * @return Specifies a target that uses Oracle SQL.
     */
    public final OracleSQLCatalogTarget oracleSQLCatalogTarget() {
        return oracleSQLCatalogTarget;
    }

    /**
     * <p>
     * Specifies a target that uses Postgres SQL.
     * </p>
     * 
     * @return Specifies a target that uses Postgres SQL.
     */
    public final PostgreSQLCatalogTarget postgreSQLCatalogTarget() {
        return postgreSQLCatalogTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(athenaConnectorSource());
        hashCode = 31 * hashCode + Objects.hashCode(jdbcConnectorSource());
        hashCode = 31 * hashCode + Objects.hashCode(sparkConnectorSource());
        hashCode = 31 * hashCode + Objects.hashCode(catalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftSource());
        hashCode = 31 * hashCode + Objects.hashCode(s3CatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(s3CsvSource());
        hashCode = 31 * hashCode + Objects.hashCode(s3JsonSource());
        hashCode = 31 * hashCode + Objects.hashCode(s3ParquetSource());
        hashCode = 31 * hashCode + Objects.hashCode(relationalCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(jdbcConnectorTarget());
        hashCode = 31 * hashCode + Objects.hashCode(sparkConnectorTarget());
        hashCode = 31 * hashCode + Objects.hashCode(catalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftTarget());
        hashCode = 31 * hashCode + Objects.hashCode(s3CatalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(s3GlueParquetTarget());
        hashCode = 31 * hashCode + Objects.hashCode(s3DirectTarget());
        hashCode = 31 * hashCode + Objects.hashCode(applyMapping());
        hashCode = 31 * hashCode + Objects.hashCode(selectFields());
        hashCode = 31 * hashCode + Objects.hashCode(dropFields());
        hashCode = 31 * hashCode + Objects.hashCode(renameField());
        hashCode = 31 * hashCode + Objects.hashCode(spigot());
        hashCode = 31 * hashCode + Objects.hashCode(join());
        hashCode = 31 * hashCode + Objects.hashCode(splitFields());
        hashCode = 31 * hashCode + Objects.hashCode(selectFromCollection());
        hashCode = 31 * hashCode + Objects.hashCode(fillMissingValues());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(customCode());
        hashCode = 31 * hashCode + Objects.hashCode(sparkSQL());
        hashCode = 31 * hashCode + Objects.hashCode(directKinesisSource());
        hashCode = 31 * hashCode + Objects.hashCode(directKafkaSource());
        hashCode = 31 * hashCode + Objects.hashCode(catalogKinesisSource());
        hashCode = 31 * hashCode + Objects.hashCode(catalogKafkaSource());
        hashCode = 31 * hashCode + Objects.hashCode(dropNullFields());
        hashCode = 31 * hashCode + Objects.hashCode(merge());
        hashCode = 31 * hashCode + Objects.hashCode(union());
        hashCode = 31 * hashCode + Objects.hashCode(piiDetection());
        hashCode = 31 * hashCode + Objects.hashCode(aggregate());
        hashCode = 31 * hashCode + Objects.hashCode(dropDuplicates());
        hashCode = 31 * hashCode + Objects.hashCode(governedCatalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(governedCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftSQLServerCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(mySQLCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(oracleSQLCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(postgreSQLCatalogSource());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftSQLServerCatalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(mySQLCatalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(oracleSQLCatalogTarget());
        hashCode = 31 * hashCode + Objects.hashCode(postgreSQLCatalogTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenConfigurationNode)) {
            return false;
        }
        CodeGenConfigurationNode other = (CodeGenConfigurationNode) obj;
        return Objects.equals(athenaConnectorSource(), other.athenaConnectorSource())
                && Objects.equals(jdbcConnectorSource(), other.jdbcConnectorSource())
                && Objects.equals(sparkConnectorSource(), other.sparkConnectorSource())
                && Objects.equals(catalogSource(), other.catalogSource())
                && Objects.equals(redshiftSource(), other.redshiftSource())
                && Objects.equals(s3CatalogSource(), other.s3CatalogSource())
                && Objects.equals(s3CsvSource(), other.s3CsvSource()) && Objects.equals(s3JsonSource(), other.s3JsonSource())
                && Objects.equals(s3ParquetSource(), other.s3ParquetSource())
                && Objects.equals(relationalCatalogSource(), other.relationalCatalogSource())
                && Objects.equals(dynamoDBCatalogSource(), other.dynamoDBCatalogSource())
                && Objects.equals(jdbcConnectorTarget(), other.jdbcConnectorTarget())
                && Objects.equals(sparkConnectorTarget(), other.sparkConnectorTarget())
                && Objects.equals(catalogTarget(), other.catalogTarget())
                && Objects.equals(redshiftTarget(), other.redshiftTarget())
                && Objects.equals(s3CatalogTarget(), other.s3CatalogTarget())
                && Objects.equals(s3GlueParquetTarget(), other.s3GlueParquetTarget())
                && Objects.equals(s3DirectTarget(), other.s3DirectTarget())
                && Objects.equals(applyMapping(), other.applyMapping()) && Objects.equals(selectFields(), other.selectFields())
                && Objects.equals(dropFields(), other.dropFields()) && Objects.equals(renameField(), other.renameField())
                && Objects.equals(spigot(), other.spigot()) && Objects.equals(join(), other.join())
                && Objects.equals(splitFields(), other.splitFields())
                && Objects.equals(selectFromCollection(), other.selectFromCollection())
                && Objects.equals(fillMissingValues(), other.fillMissingValues()) && Objects.equals(filter(), other.filter())
                && Objects.equals(customCode(), other.customCode()) && Objects.equals(sparkSQL(), other.sparkSQL())
                && Objects.equals(directKinesisSource(), other.directKinesisSource())
                && Objects.equals(directKafkaSource(), other.directKafkaSource())
                && Objects.equals(catalogKinesisSource(), other.catalogKinesisSource())
                && Objects.equals(catalogKafkaSource(), other.catalogKafkaSource())
                && Objects.equals(dropNullFields(), other.dropNullFields()) && Objects.equals(merge(), other.merge())
                && Objects.equals(union(), other.union()) && Objects.equals(piiDetection(), other.piiDetection())
                && Objects.equals(aggregate(), other.aggregate()) && Objects.equals(dropDuplicates(), other.dropDuplicates())
                && Objects.equals(governedCatalogTarget(), other.governedCatalogTarget())
                && Objects.equals(governedCatalogSource(), other.governedCatalogSource())
                && Objects.equals(microsoftSQLServerCatalogSource(), other.microsoftSQLServerCatalogSource())
                && Objects.equals(mySQLCatalogSource(), other.mySQLCatalogSource())
                && Objects.equals(oracleSQLCatalogSource(), other.oracleSQLCatalogSource())
                && Objects.equals(postgreSQLCatalogSource(), other.postgreSQLCatalogSource())
                && Objects.equals(microsoftSQLServerCatalogTarget(), other.microsoftSQLServerCatalogTarget())
                && Objects.equals(mySQLCatalogTarget(), other.mySQLCatalogTarget())
                && Objects.equals(oracleSQLCatalogTarget(), other.oracleSQLCatalogTarget())
                && Objects.equals(postgreSQLCatalogTarget(), other.postgreSQLCatalogTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeGenConfigurationNode").add("AthenaConnectorSource", athenaConnectorSource())
                .add("JDBCConnectorSource", jdbcConnectorSource()).add("SparkConnectorSource", sparkConnectorSource())
                .add("CatalogSource", catalogSource()).add("RedshiftSource", redshiftSource())
                .add("S3CatalogSource", s3CatalogSource()).add("S3CsvSource", s3CsvSource()).add("S3JsonSource", s3JsonSource())
                .add("S3ParquetSource", s3ParquetSource()).add("RelationalCatalogSource", relationalCatalogSource())
                .add("DynamoDBCatalogSource", dynamoDBCatalogSource()).add("JDBCConnectorTarget", jdbcConnectorTarget())
                .add("SparkConnectorTarget", sparkConnectorTarget()).add("CatalogTarget", catalogTarget())
                .add("RedshiftTarget", redshiftTarget()).add("S3CatalogTarget", s3CatalogTarget())
                .add("S3GlueParquetTarget", s3GlueParquetTarget()).add("S3DirectTarget", s3DirectTarget())
                .add("ApplyMapping", applyMapping()).add("SelectFields", selectFields()).add("DropFields", dropFields())
                .add("RenameField", renameField()).add("Spigot", spigot()).add("Join", join()).add("SplitFields", splitFields())
                .add("SelectFromCollection", selectFromCollection()).add("FillMissingValues", fillMissingValues())
                .add("Filter", filter()).add("CustomCode", customCode()).add("SparkSQL", sparkSQL())
                .add("DirectKinesisSource", directKinesisSource()).add("DirectKafkaSource", directKafkaSource())
                .add("CatalogKinesisSource", catalogKinesisSource()).add("CatalogKafkaSource", catalogKafkaSource())
                .add("DropNullFields", dropNullFields()).add("Merge", merge()).add("Union", union())
                .add("PIIDetection", piiDetection()).add("Aggregate", aggregate()).add("DropDuplicates", dropDuplicates())
                .add("GovernedCatalogTarget", governedCatalogTarget()).add("GovernedCatalogSource", governedCatalogSource())
                .add("MicrosoftSQLServerCatalogSource", microsoftSQLServerCatalogSource())
                .add("MySQLCatalogSource", mySQLCatalogSource()).add("OracleSQLCatalogSource", oracleSQLCatalogSource())
                .add("PostgreSQLCatalogSource", postgreSQLCatalogSource())
                .add("MicrosoftSQLServerCatalogTarget", microsoftSQLServerCatalogTarget())
                .add("MySQLCatalogTarget", mySQLCatalogTarget()).add("OracleSQLCatalogTarget", oracleSQLCatalogTarget())
                .add("PostgreSQLCatalogTarget", postgreSQLCatalogTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AthenaConnectorSource":
            return Optional.ofNullable(clazz.cast(athenaConnectorSource()));
        case "JDBCConnectorSource":
            return Optional.ofNullable(clazz.cast(jdbcConnectorSource()));
        case "SparkConnectorSource":
            return Optional.ofNullable(clazz.cast(sparkConnectorSource()));
        case "CatalogSource":
            return Optional.ofNullable(clazz.cast(catalogSource()));
        case "RedshiftSource":
            return Optional.ofNullable(clazz.cast(redshiftSource()));
        case "S3CatalogSource":
            return Optional.ofNullable(clazz.cast(s3CatalogSource()));
        case "S3CsvSource":
            return Optional.ofNullable(clazz.cast(s3CsvSource()));
        case "S3JsonSource":
            return Optional.ofNullable(clazz.cast(s3JsonSource()));
        case "S3ParquetSource":
            return Optional.ofNullable(clazz.cast(s3ParquetSource()));
        case "RelationalCatalogSource":
            return Optional.ofNullable(clazz.cast(relationalCatalogSource()));
        case "DynamoDBCatalogSource":
            return Optional.ofNullable(clazz.cast(dynamoDBCatalogSource()));
        case "JDBCConnectorTarget":
            return Optional.ofNullable(clazz.cast(jdbcConnectorTarget()));
        case "SparkConnectorTarget":
            return Optional.ofNullable(clazz.cast(sparkConnectorTarget()));
        case "CatalogTarget":
            return Optional.ofNullable(clazz.cast(catalogTarget()));
        case "RedshiftTarget":
            return Optional.ofNullable(clazz.cast(redshiftTarget()));
        case "S3CatalogTarget":
            return Optional.ofNullable(clazz.cast(s3CatalogTarget()));
        case "S3GlueParquetTarget":
            return Optional.ofNullable(clazz.cast(s3GlueParquetTarget()));
        case "S3DirectTarget":
            return Optional.ofNullable(clazz.cast(s3DirectTarget()));
        case "ApplyMapping":
            return Optional.ofNullable(clazz.cast(applyMapping()));
        case "SelectFields":
            return Optional.ofNullable(clazz.cast(selectFields()));
        case "DropFields":
            return Optional.ofNullable(clazz.cast(dropFields()));
        case "RenameField":
            return Optional.ofNullable(clazz.cast(renameField()));
        case "Spigot":
            return Optional.ofNullable(clazz.cast(spigot()));
        case "Join":
            return Optional.ofNullable(clazz.cast(join()));
        case "SplitFields":
            return Optional.ofNullable(clazz.cast(splitFields()));
        case "SelectFromCollection":
            return Optional.ofNullable(clazz.cast(selectFromCollection()));
        case "FillMissingValues":
            return Optional.ofNullable(clazz.cast(fillMissingValues()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "CustomCode":
            return Optional.ofNullable(clazz.cast(customCode()));
        case "SparkSQL":
            return Optional.ofNullable(clazz.cast(sparkSQL()));
        case "DirectKinesisSource":
            return Optional.ofNullable(clazz.cast(directKinesisSource()));
        case "DirectKafkaSource":
            return Optional.ofNullable(clazz.cast(directKafkaSource()));
        case "CatalogKinesisSource":
            return Optional.ofNullable(clazz.cast(catalogKinesisSource()));
        case "CatalogKafkaSource":
            return Optional.ofNullable(clazz.cast(catalogKafkaSource()));
        case "DropNullFields":
            return Optional.ofNullable(clazz.cast(dropNullFields()));
        case "Merge":
            return Optional.ofNullable(clazz.cast(merge()));
        case "Union":
            return Optional.ofNullable(clazz.cast(union()));
        case "PIIDetection":
            return Optional.ofNullable(clazz.cast(piiDetection()));
        case "Aggregate":
            return Optional.ofNullable(clazz.cast(aggregate()));
        case "DropDuplicates":
            return Optional.ofNullable(clazz.cast(dropDuplicates()));
        case "GovernedCatalogTarget":
            return Optional.ofNullable(clazz.cast(governedCatalogTarget()));
        case "GovernedCatalogSource":
            return Optional.ofNullable(clazz.cast(governedCatalogSource()));
        case "MicrosoftSQLServerCatalogSource":
            return Optional.ofNullable(clazz.cast(microsoftSQLServerCatalogSource()));
        case "MySQLCatalogSource":
            return Optional.ofNullable(clazz.cast(mySQLCatalogSource()));
        case "OracleSQLCatalogSource":
            return Optional.ofNullable(clazz.cast(oracleSQLCatalogSource()));
        case "PostgreSQLCatalogSource":
            return Optional.ofNullable(clazz.cast(postgreSQLCatalogSource()));
        case "MicrosoftSQLServerCatalogTarget":
            return Optional.ofNullable(clazz.cast(microsoftSQLServerCatalogTarget()));
        case "MySQLCatalogTarget":
            return Optional.ofNullable(clazz.cast(mySQLCatalogTarget()));
        case "OracleSQLCatalogTarget":
            return Optional.ofNullable(clazz.cast(oracleSQLCatalogTarget()));
        case "PostgreSQLCatalogTarget":
            return Optional.ofNullable(clazz.cast(postgreSQLCatalogTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeGenConfigurationNode, T> g) {
        return obj -> g.apply((CodeGenConfigurationNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeGenConfigurationNode> {
        /**
         * <p>
         * Specifies a connector to an Amazon Athena data source.
         * </p>
         * 
         * @param athenaConnectorSource
         *        Specifies a connector to an Amazon Athena data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaConnectorSource(AthenaConnectorSource athenaConnectorSource);

        /**
         * <p>
         * Specifies a connector to an Amazon Athena data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaConnectorSource.Builder} avoiding
         * the need to create one manually via {@link AthenaConnectorSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaConnectorSource.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaConnectorSource(AthenaConnectorSource)}.
         * 
         * @param athenaConnectorSource
         *        a consumer that will call methods on {@link AthenaConnectorSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaConnectorSource(AthenaConnectorSource)
         */
        default Builder athenaConnectorSource(Consumer<AthenaConnectorSource.Builder> athenaConnectorSource) {
            return athenaConnectorSource(AthenaConnectorSource.builder().applyMutation(athenaConnectorSource).build());
        }

        /**
         * <p>
         * Specifies a connector to a JDBC data source.
         * </p>
         * 
         * @param jdbcConnectorSource
         *        Specifies a connector to a JDBC data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcConnectorSource(JDBCConnectorSource jdbcConnectorSource);

        /**
         * <p>
         * Specifies a connector to a JDBC data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link JDBCConnectorSource.Builder} avoiding the
         * need to create one manually via {@link JDBCConnectorSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JDBCConnectorSource.Builder#build()} is called immediately and
         * its result is passed to {@link #jdbcConnectorSource(JDBCConnectorSource)}.
         * 
         * @param jdbcConnectorSource
         *        a consumer that will call methods on {@link JDBCConnectorSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jdbcConnectorSource(JDBCConnectorSource)
         */
        default Builder jdbcConnectorSource(Consumer<JDBCConnectorSource.Builder> jdbcConnectorSource) {
            return jdbcConnectorSource(JDBCConnectorSource.builder().applyMutation(jdbcConnectorSource).build());
        }

        /**
         * <p>
         * Specifies a connector to an Apache Spark data source.
         * </p>
         * 
         * @param sparkConnectorSource
         *        Specifies a connector to an Apache Spark data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkConnectorSource(SparkConnectorSource sparkConnectorSource);

        /**
         * <p>
         * Specifies a connector to an Apache Spark data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkConnectorSource.Builder} avoiding
         * the need to create one manually via {@link SparkConnectorSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkConnectorSource.Builder#build()} is called immediately and
         * its result is passed to {@link #sparkConnectorSource(SparkConnectorSource)}.
         * 
         * @param sparkConnectorSource
         *        a consumer that will call methods on {@link SparkConnectorSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkConnectorSource(SparkConnectorSource)
         */
        default Builder sparkConnectorSource(Consumer<SparkConnectorSource.Builder> sparkConnectorSource) {
            return sparkConnectorSource(SparkConnectorSource.builder().applyMutation(sparkConnectorSource).build());
        }

        /**
         * <p>
         * Specifies a data store in the Glue Data Catalog.
         * </p>
         * 
         * @param catalogSource
         *        Specifies a data store in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogSource(CatalogSource catalogSource);

        /**
         * <p>
         * Specifies a data store in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogSource.Builder} avoiding the need
         * to create one manually via {@link CatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogSource.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogSource(CatalogSource)}.
         * 
         * @param catalogSource
         *        a consumer that will call methods on {@link CatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogSource(CatalogSource)
         */
        default Builder catalogSource(Consumer<CatalogSource.Builder> catalogSource) {
            return catalogSource(CatalogSource.builder().applyMutation(catalogSource).build());
        }

        /**
         * <p>
         * Specifies an Amazon Redshift data store.
         * </p>
         * 
         * @param redshiftSource
         *        Specifies an Amazon Redshift data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftSource(RedshiftSource redshiftSource);

        /**
         * <p>
         * Specifies an Amazon Redshift data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftSource.Builder} avoiding the need
         * to create one manually via {@link RedshiftSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftSource.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftSource(RedshiftSource)}.
         * 
         * @param redshiftSource
         *        a consumer that will call methods on {@link RedshiftSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftSource(RedshiftSource)
         */
        default Builder redshiftSource(Consumer<RedshiftSource.Builder> redshiftSource) {
            return redshiftSource(RedshiftSource.builder().applyMutation(redshiftSource).build());
        }

        /**
         * <p>
         * Specifies an Amazon S3 data store in the Glue Data Catalog.
         * </p>
         * 
         * @param s3CatalogSource
         *        Specifies an Amazon S3 data store in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CatalogSource(S3CatalogSource s3CatalogSource);

        /**
         * <p>
         * Specifies an Amazon S3 data store in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3CatalogSource.Builder} avoiding the
         * need to create one manually via {@link S3CatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3CatalogSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3CatalogSource(S3CatalogSource)}.
         * 
         * @param s3CatalogSource
         *        a consumer that will call methods on {@link S3CatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3CatalogSource(S3CatalogSource)
         */
        default Builder s3CatalogSource(Consumer<S3CatalogSource.Builder> s3CatalogSource) {
            return s3CatalogSource(S3CatalogSource.builder().applyMutation(s3CatalogSource).build());
        }

        /**
         * <p>
         * Specifies a command-separated value (CSV) data store stored in Amazon S3.
         * </p>
         * 
         * @param s3CsvSource
         *        Specifies a command-separated value (CSV) data store stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CsvSource(S3CsvSource s3CsvSource);

        /**
         * <p>
         * Specifies a command-separated value (CSV) data store stored in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3CsvSource.Builder} avoiding the need to
         * create one manually via {@link S3CsvSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3CsvSource.Builder#build()} is called immediately and its result
         * is passed to {@link #s3CsvSource(S3CsvSource)}.
         * 
         * @param s3CsvSource
         *        a consumer that will call methods on {@link S3CsvSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3CsvSource(S3CsvSource)
         */
        default Builder s3CsvSource(Consumer<S3CsvSource.Builder> s3CsvSource) {
            return s3CsvSource(S3CsvSource.builder().applyMutation(s3CsvSource).build());
        }

        /**
         * <p>
         * Specifies a JSON data store stored in Amazon S3.
         * </p>
         * 
         * @param s3JsonSource
         *        Specifies a JSON data store stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JsonSource(S3JsonSource s3JsonSource);

        /**
         * <p>
         * Specifies a JSON data store stored in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3JsonSource.Builder} avoiding the need
         * to create one manually via {@link S3JsonSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3JsonSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3JsonSource(S3JsonSource)}.
         * 
         * @param s3JsonSource
         *        a consumer that will call methods on {@link S3JsonSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JsonSource(S3JsonSource)
         */
        default Builder s3JsonSource(Consumer<S3JsonSource.Builder> s3JsonSource) {
            return s3JsonSource(S3JsonSource.builder().applyMutation(s3JsonSource).build());
        }

        /**
         * <p>
         * Specifies an Apache Parquet data store stored in Amazon S3.
         * </p>
         * 
         * @param s3ParquetSource
         *        Specifies an Apache Parquet data store stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ParquetSource(S3ParquetSource s3ParquetSource);

        /**
         * <p>
         * Specifies an Apache Parquet data store stored in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ParquetSource.Builder} avoiding the
         * need to create one manually via {@link S3ParquetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ParquetSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3ParquetSource(S3ParquetSource)}.
         * 
         * @param s3ParquetSource
         *        a consumer that will call methods on {@link S3ParquetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ParquetSource(S3ParquetSource)
         */
        default Builder s3ParquetSource(Consumer<S3ParquetSource.Builder> s3ParquetSource) {
            return s3ParquetSource(S3ParquetSource.builder().applyMutation(s3ParquetSource).build());
        }

        /**
         * Sets the value of the RelationalCatalogSource property for this object.
         *
         * @param relationalCatalogSource
         *        The new value for the RelationalCatalogSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalCatalogSource(RelationalCatalogSource relationalCatalogSource);

        /**
         * Sets the value of the RelationalCatalogSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RelationalCatalogSource.Builder} avoiding
         * the need to create one manually via {@link RelationalCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelationalCatalogSource.Builder#build()} is called immediately
         * and its result is passed to {@link #relationalCatalogSource(RelationalCatalogSource)}.
         * 
         * @param relationalCatalogSource
         *        a consumer that will call methods on {@link RelationalCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalCatalogSource(RelationalCatalogSource)
         */
        default Builder relationalCatalogSource(Consumer<RelationalCatalogSource.Builder> relationalCatalogSource) {
            return relationalCatalogSource(RelationalCatalogSource.builder().applyMutation(relationalCatalogSource).build());
        }

        /**
         * Sets the value of the DynamoDBCatalogSource property for this object.
         *
         * @param dynamoDBCatalogSource
         *        The new value for the DynamoDBCatalogSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBCatalogSource(DynamoDBCatalogSource dynamoDBCatalogSource);

        /**
         * Sets the value of the DynamoDBCatalogSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DynamoDBCatalogSource.Builder} avoiding
         * the need to create one manually via {@link DynamoDBCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamoDBCatalogSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dynamoDBCatalogSource(DynamoDBCatalogSource)}.
         * 
         * @param dynamoDBCatalogSource
         *        a consumer that will call methods on {@link DynamoDBCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBCatalogSource(DynamoDBCatalogSource)
         */
        default Builder dynamoDBCatalogSource(Consumer<DynamoDBCatalogSource.Builder> dynamoDBCatalogSource) {
            return dynamoDBCatalogSource(DynamoDBCatalogSource.builder().applyMutation(dynamoDBCatalogSource).build());
        }

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * </p>
         * 
         * @param jdbcConnectorTarget
         *        Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcConnectorTarget(JDBCConnectorTarget jdbcConnectorTarget);

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * </p>
         * This is a convenience method that creates an instance of the {@link JDBCConnectorTarget.Builder} avoiding the
         * need to create one manually via {@link JDBCConnectorTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JDBCConnectorTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #jdbcConnectorTarget(JDBCConnectorTarget)}.
         * 
         * @param jdbcConnectorTarget
         *        a consumer that will call methods on {@link JDBCConnectorTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jdbcConnectorTarget(JDBCConnectorTarget)
         */
        default Builder jdbcConnectorTarget(Consumer<JDBCConnectorTarget.Builder> jdbcConnectorTarget) {
            return jdbcConnectorTarget(JDBCConnectorTarget.builder().applyMutation(jdbcConnectorTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses an Apache Spark connector.
         * </p>
         * 
         * @param sparkConnectorTarget
         *        Specifies a target that uses an Apache Spark connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkConnectorTarget(SparkConnectorTarget sparkConnectorTarget);

        /**
         * <p>
         * Specifies a target that uses an Apache Spark connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkConnectorTarget.Builder} avoiding
         * the need to create one manually via {@link SparkConnectorTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkConnectorTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #sparkConnectorTarget(SparkConnectorTarget)}.
         * 
         * @param sparkConnectorTarget
         *        a consumer that will call methods on {@link SparkConnectorTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkConnectorTarget(SparkConnectorTarget)
         */
        default Builder sparkConnectorTarget(Consumer<SparkConnectorTarget.Builder> sparkConnectorTarget) {
            return sparkConnectorTarget(SparkConnectorTarget.builder().applyMutation(sparkConnectorTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses a Glue Data Catalog table.
         * </p>
         * 
         * @param catalogTarget
         *        Specifies a target that uses a Glue Data Catalog table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogTarget(BasicCatalogTarget catalogTarget);

        /**
         * <p>
         * Specifies a target that uses a Glue Data Catalog table.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicCatalogTarget.Builder} avoiding the
         * need to create one manually via {@link BasicCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicCatalogTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogTarget(BasicCatalogTarget)}.
         * 
         * @param catalogTarget
         *        a consumer that will call methods on {@link BasicCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogTarget(BasicCatalogTarget)
         */
        default Builder catalogTarget(Consumer<BasicCatalogTarget.Builder> catalogTarget) {
            return catalogTarget(BasicCatalogTarget.builder().applyMutation(catalogTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses Amazon Redshift.
         * </p>
         * 
         * @param redshiftTarget
         *        Specifies a target that uses Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftTarget(RedshiftTarget redshiftTarget);

        /**
         * <p>
         * Specifies a target that uses Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftTarget.Builder} avoiding the need
         * to create one manually via {@link RedshiftTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftTarget(RedshiftTarget)}.
         * 
         * @param redshiftTarget
         *        a consumer that will call methods on {@link RedshiftTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftTarget(RedshiftTarget)
         */
        default Builder redshiftTarget(Consumer<RedshiftTarget.Builder> redshiftTarget) {
            return redshiftTarget(RedshiftTarget.builder().applyMutation(redshiftTarget).build());
        }

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 using the Glue Data Catalog.
         * </p>
         * 
         * @param s3CatalogTarget
         *        Specifies a data target that writes to Amazon S3 using the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CatalogTarget(S3CatalogTarget s3CatalogTarget);

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 using the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3CatalogTarget.Builder} avoiding the
         * need to create one manually via {@link S3CatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3CatalogTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #s3CatalogTarget(S3CatalogTarget)}.
         * 
         * @param s3CatalogTarget
         *        a consumer that will call methods on {@link S3CatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3CatalogTarget(S3CatalogTarget)
         */
        default Builder s3CatalogTarget(Consumer<S3CatalogTarget.Builder> s3CatalogTarget) {
            return s3CatalogTarget(S3CatalogTarget.builder().applyMutation(s3CatalogTarget).build());
        }

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * </p>
         * 
         * @param s3GlueParquetTarget
         *        Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3GlueParquetTarget(S3GlueParquetTarget s3GlueParquetTarget);

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3GlueParquetTarget.Builder} avoiding the
         * need to create one manually via {@link S3GlueParquetTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3GlueParquetTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #s3GlueParquetTarget(S3GlueParquetTarget)}.
         * 
         * @param s3GlueParquetTarget
         *        a consumer that will call methods on {@link S3GlueParquetTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3GlueParquetTarget(S3GlueParquetTarget)
         */
        default Builder s3GlueParquetTarget(Consumer<S3GlueParquetTarget.Builder> s3GlueParquetTarget) {
            return s3GlueParquetTarget(S3GlueParquetTarget.builder().applyMutation(s3GlueParquetTarget).build());
        }

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3.
         * </p>
         * 
         * @param s3DirectTarget
         *        Specifies a data target that writes to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DirectTarget(S3DirectTarget s3DirectTarget);

        /**
         * <p>
         * Specifies a data target that writes to Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DirectTarget.Builder} avoiding the need
         * to create one manually via {@link S3DirectTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DirectTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DirectTarget(S3DirectTarget)}.
         * 
         * @param s3DirectTarget
         *        a consumer that will call methods on {@link S3DirectTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DirectTarget(S3DirectTarget)
         */
        default Builder s3DirectTarget(Consumer<S3DirectTarget.Builder> s3DirectTarget) {
            return s3DirectTarget(S3DirectTarget.builder().applyMutation(s3DirectTarget).build());
        }

        /**
         * <p>
         * Specifies a transform that maps data property keys in the data source to data property keys in the data
         * target. You can rename keys, modify the data types for keys, and choose which keys to drop from the dataset.
         * </p>
         * 
         * @param applyMapping
         *        Specifies a transform that maps data property keys in the data source to data property keys in the
         *        data target. You can rename keys, modify the data types for keys, and choose which keys to drop from
         *        the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyMapping(ApplyMapping applyMapping);

        /**
         * <p>
         * Specifies a transform that maps data property keys in the data source to data property keys in the data
         * target. You can rename keys, modify the data types for keys, and choose which keys to drop from the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplyMapping.Builder} avoiding the need
         * to create one manually via {@link ApplyMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplyMapping.Builder#build()} is called immediately and its
         * result is passed to {@link #applyMapping(ApplyMapping)}.
         * 
         * @param applyMapping
         *        a consumer that will call methods on {@link ApplyMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applyMapping(ApplyMapping)
         */
        default Builder applyMapping(Consumer<ApplyMapping.Builder> applyMapping) {
            return applyMapping(ApplyMapping.builder().applyMutation(applyMapping).build());
        }

        /**
         * <p>
         * Specifies a transform that chooses the data property keys that you want to keep.
         * </p>
         * 
         * @param selectFields
         *        Specifies a transform that chooses the data property keys that you want to keep.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectFields(SelectFields selectFields);

        /**
         * <p>
         * Specifies a transform that chooses the data property keys that you want to keep.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectFields.Builder} avoiding the need
         * to create one manually via {@link SelectFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectFields.Builder#build()} is called immediately and its
         * result is passed to {@link #selectFields(SelectFields)}.
         * 
         * @param selectFields
         *        a consumer that will call methods on {@link SelectFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectFields(SelectFields)
         */
        default Builder selectFields(Consumer<SelectFields.Builder> selectFields) {
            return selectFields(SelectFields.builder().applyMutation(selectFields).build());
        }

        /**
         * <p>
         * Specifies a transform that chooses the data property keys that you want to drop.
         * </p>
         * 
         * @param dropFields
         *        Specifies a transform that chooses the data property keys that you want to drop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropFields(DropFields dropFields);

        /**
         * <p>
         * Specifies a transform that chooses the data property keys that you want to drop.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropFields.Builder} avoiding the need to
         * create one manually via {@link DropFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropFields.Builder#build()} is called immediately and its result
         * is passed to {@link #dropFields(DropFields)}.
         * 
         * @param dropFields
         *        a consumer that will call methods on {@link DropFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dropFields(DropFields)
         */
        default Builder dropFields(Consumer<DropFields.Builder> dropFields) {
            return dropFields(DropFields.builder().applyMutation(dropFields).build());
        }

        /**
         * <p>
         * Specifies a transform that renames a single data property key.
         * </p>
         * 
         * @param renameField
         *        Specifies a transform that renames a single data property key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameField(RenameField renameField);

        /**
         * <p>
         * Specifies a transform that renames a single data property key.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenameField.Builder} avoiding the need to
         * create one manually via {@link RenameField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenameField.Builder#build()} is called immediately and its result
         * is passed to {@link #renameField(RenameField)}.
         * 
         * @param renameField
         *        a consumer that will call methods on {@link RenameField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renameField(RenameField)
         */
        default Builder renameField(Consumer<RenameField.Builder> renameField) {
            return renameField(RenameField.builder().applyMutation(renameField).build());
        }

        /**
         * <p>
         * Specifies a transform that writes samples of the data to an Amazon S3 bucket.
         * </p>
         * 
         * @param spigot
         *        Specifies a transform that writes samples of the data to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spigot(Spigot spigot);

        /**
         * <p>
         * Specifies a transform that writes samples of the data to an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link Spigot.Builder} avoiding the need to
         * create one manually via {@link Spigot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Spigot.Builder#build()} is called immediately and its result is
         * passed to {@link #spigot(Spigot)}.
         * 
         * @param spigot
         *        a consumer that will call methods on {@link Spigot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spigot(Spigot)
         */
        default Builder spigot(Consumer<Spigot.Builder> spigot) {
            return spigot(Spigot.builder().applyMutation(spigot).build());
        }

        /**
         * <p>
         * Specifies a transform that joins two datasets into one dataset using a comparison phrase on the specified
         * data property keys. You can use inner, outer, left, right, left semi, and left anti joins.
         * </p>
         * 
         * @param join
         *        Specifies a transform that joins two datasets into one dataset using a comparison phrase on the
         *        specified data property keys. You can use inner, outer, left, right, left semi, and left anti joins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder join(Join join);

        /**
         * <p>
         * Specifies a transform that joins two datasets into one dataset using a comparison phrase on the specified
         * data property keys. You can use inner, outer, left, right, left semi, and left anti joins.
         * </p>
         * This is a convenience method that creates an instance of the {@link Join.Builder} avoiding the need to create
         * one manually via {@link Join#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Join.Builder#build()} is called immediately and its result is
         * passed to {@link #join(Join)}.
         * 
         * @param join
         *        a consumer that will call methods on {@link Join.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #join(Join)
         */
        default Builder join(Consumer<Join.Builder> join) {
            return join(Join.builder().applyMutation(join).build());
        }

        /**
         * <p>
         * Specifies a transform that splits data property keys into two <code>DynamicFrames</code>. The output is a
         * collection of <code>DynamicFrames</code>: one with selected data property keys, and one with the remaining
         * data property keys.
         * </p>
         * 
         * @param splitFields
         *        Specifies a transform that splits data property keys into two <code>DynamicFrames</code>. The output
         *        is a collection of <code>DynamicFrames</code>: one with selected data property keys, and one with the
         *        remaining data property keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitFields(SplitFields splitFields);

        /**
         * <p>
         * Specifies a transform that splits data property keys into two <code>DynamicFrames</code>. The output is a
         * collection of <code>DynamicFrames</code>: one with selected data property keys, and one with the remaining
         * data property keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link SplitFields.Builder} avoiding the need to
         * create one manually via {@link SplitFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SplitFields.Builder#build()} is called immediately and its result
         * is passed to {@link #splitFields(SplitFields)}.
         * 
         * @param splitFields
         *        a consumer that will call methods on {@link SplitFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitFields(SplitFields)
         */
        default Builder splitFields(Consumer<SplitFields.Builder> splitFields) {
            return splitFields(SplitFields.builder().applyMutation(splitFields).build());
        }

        /**
         * <p>
         * Specifies a transform that chooses one <code>DynamicFrame</code> from a collection of
         * <code>DynamicFrames</code>. The output is the selected <code>DynamicFrame</code>
         * </p>
         * 
         * @param selectFromCollection
         *        Specifies a transform that chooses one <code>DynamicFrame</code> from a collection of
         *        <code>DynamicFrames</code>. The output is the selected <code>DynamicFrame</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectFromCollection(SelectFromCollection selectFromCollection);

        /**
         * <p>
         * Specifies a transform that chooses one <code>DynamicFrame</code> from a collection of
         * <code>DynamicFrames</code>. The output is the selected <code>DynamicFrame</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectFromCollection.Builder} avoiding
         * the need to create one manually via {@link SelectFromCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectFromCollection.Builder#build()} is called immediately and
         * its result is passed to {@link #selectFromCollection(SelectFromCollection)}.
         * 
         * @param selectFromCollection
         *        a consumer that will call methods on {@link SelectFromCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectFromCollection(SelectFromCollection)
         */
        default Builder selectFromCollection(Consumer<SelectFromCollection.Builder> selectFromCollection) {
            return selectFromCollection(SelectFromCollection.builder().applyMutation(selectFromCollection).build());
        }

        /**
         * <p>
         * Specifies a transform that locates records in the dataset that have missing values and adds a new field with
         * a value determined by imputation. The input data set is used to train the machine learning model that
         * determines what the missing value should be.
         * </p>
         * 
         * @param fillMissingValues
         *        Specifies a transform that locates records in the dataset that have missing values and adds a new
         *        field with a value determined by imputation. The input data set is used to train the machine learning
         *        model that determines what the missing value should be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillMissingValues(FillMissingValues fillMissingValues);

        /**
         * <p>
         * Specifies a transform that locates records in the dataset that have missing values and adds a new field with
         * a value determined by imputation. The input data set is used to train the machine learning model that
         * determines what the missing value should be.
         * </p>
         * This is a convenience method that creates an instance of the {@link FillMissingValues.Builder} avoiding the
         * need to create one manually via {@link FillMissingValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FillMissingValues.Builder#build()} is called immediately and its
         * result is passed to {@link #fillMissingValues(FillMissingValues)}.
         * 
         * @param fillMissingValues
         *        a consumer that will call methods on {@link FillMissingValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillMissingValues(FillMissingValues)
         */
        default Builder fillMissingValues(Consumer<FillMissingValues.Builder> fillMissingValues) {
            return fillMissingValues(FillMissingValues.builder().applyMutation(fillMissingValues).build());
        }

        /**
         * <p>
         * Specifies a transform that splits a dataset into two, based on a filter condition.
         * </p>
         * 
         * @param filter
         *        Specifies a transform that splits a dataset into two, based on a filter condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * Specifies a transform that splits a dataset into two, based on a filter condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Specifies a transform that uses custom code you provide to perform the data transformation. The output is a
         * collection of DynamicFrames.
         * </p>
         * 
         * @param customCode
         *        Specifies a transform that uses custom code you provide to perform the data transformation. The output
         *        is a collection of DynamicFrames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCode(CustomCode customCode);

        /**
         * <p>
         * Specifies a transform that uses custom code you provide to perform the data transformation. The output is a
         * collection of DynamicFrames.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomCode.Builder} avoiding the need to
         * create one manually via {@link CustomCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomCode.Builder#build()} is called immediately and its result
         * is passed to {@link #customCode(CustomCode)}.
         * 
         * @param customCode
         *        a consumer that will call methods on {@link CustomCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCode(CustomCode)
         */
        default Builder customCode(Consumer<CustomCode.Builder> customCode) {
            return customCode(CustomCode.builder().applyMutation(customCode).build());
        }

        /**
         * <p>
         * Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The output is
         * a single <code>DynamicFrame</code>.
         * </p>
         * 
         * @param sparkSQL
         *        Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The
         *        output is a single <code>DynamicFrame</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSQL(SparkSQL sparkSQL);

        /**
         * <p>
         * Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The output is
         * a single <code>DynamicFrame</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkSQL.Builder} avoiding the need to
         * create one manually via {@link SparkSQL#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkSQL.Builder#build()} is called immediately and its result is
         * passed to {@link #sparkSQL(SparkSQL)}.
         * 
         * @param sparkSQL
         *        a consumer that will call methods on {@link SparkSQL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkSQL(SparkSQL)
         */
        default Builder sparkSQL(Consumer<SparkSQL.Builder> sparkSQL) {
            return sparkSQL(SparkSQL.builder().applyMutation(sparkSQL).build());
        }

        /**
         * <p>
         * Specifies a direct Amazon Kinesis data source.
         * </p>
         * 
         * @param directKinesisSource
         *        Specifies a direct Amazon Kinesis data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directKinesisSource(DirectKinesisSource directKinesisSource);

        /**
         * <p>
         * Specifies a direct Amazon Kinesis data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectKinesisSource.Builder} avoiding the
         * need to create one manually via {@link DirectKinesisSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectKinesisSource.Builder#build()} is called immediately and
         * its result is passed to {@link #directKinesisSource(DirectKinesisSource)}.
         * 
         * @param directKinesisSource
         *        a consumer that will call methods on {@link DirectKinesisSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directKinesisSource(DirectKinesisSource)
         */
        default Builder directKinesisSource(Consumer<DirectKinesisSource.Builder> directKinesisSource) {
            return directKinesisSource(DirectKinesisSource.builder().applyMutation(directKinesisSource).build());
        }

        /**
         * <p>
         * Specifies an Apache Kafka data store.
         * </p>
         * 
         * @param directKafkaSource
         *        Specifies an Apache Kafka data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directKafkaSource(DirectKafkaSource directKafkaSource);

        /**
         * <p>
         * Specifies an Apache Kafka data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectKafkaSource.Builder} avoiding the
         * need to create one manually via {@link DirectKafkaSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectKafkaSource.Builder#build()} is called immediately and its
         * result is passed to {@link #directKafkaSource(DirectKafkaSource)}.
         * 
         * @param directKafkaSource
         *        a consumer that will call methods on {@link DirectKafkaSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directKafkaSource(DirectKafkaSource)
         */
        default Builder directKafkaSource(Consumer<DirectKafkaSource.Builder> directKafkaSource) {
            return directKafkaSource(DirectKafkaSource.builder().applyMutation(directKafkaSource).build());
        }

        /**
         * <p>
         * Specifies a Kinesis data source in the Glue Data Catalog.
         * </p>
         * 
         * @param catalogKinesisSource
         *        Specifies a Kinesis data source in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogKinesisSource(CatalogKinesisSource catalogKinesisSource);

        /**
         * <p>
         * Specifies a Kinesis data source in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogKinesisSource.Builder} avoiding
         * the need to create one manually via {@link CatalogKinesisSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogKinesisSource.Builder#build()} is called immediately and
         * its result is passed to {@link #catalogKinesisSource(CatalogKinesisSource)}.
         * 
         * @param catalogKinesisSource
         *        a consumer that will call methods on {@link CatalogKinesisSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogKinesisSource(CatalogKinesisSource)
         */
        default Builder catalogKinesisSource(Consumer<CatalogKinesisSource.Builder> catalogKinesisSource) {
            return catalogKinesisSource(CatalogKinesisSource.builder().applyMutation(catalogKinesisSource).build());
        }

        /**
         * <p>
         * Specifies an Apache Kafka data store in the Data Catalog.
         * </p>
         * 
         * @param catalogKafkaSource
         *        Specifies an Apache Kafka data store in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogKafkaSource(CatalogKafkaSource catalogKafkaSource);

        /**
         * <p>
         * Specifies an Apache Kafka data store in the Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogKafkaSource.Builder} avoiding the
         * need to create one manually via {@link CatalogKafkaSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogKafkaSource.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogKafkaSource(CatalogKafkaSource)}.
         * 
         * @param catalogKafkaSource
         *        a consumer that will call methods on {@link CatalogKafkaSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogKafkaSource(CatalogKafkaSource)
         */
        default Builder catalogKafkaSource(Consumer<CatalogKafkaSource.Builder> catalogKafkaSource) {
            return catalogKafkaSource(CatalogKafkaSource.builder().applyMutation(catalogKafkaSource).build());
        }

        /**
         * <p>
         * Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By
         * default, Glue Studio will recognize null objects, but some values such as empty strings, strings that are
         * "null", -1 integers or other placeholders such as zeros, are not automatically recognized as nulls.
         * </p>
         * 
         * @param dropNullFields
         *        Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By
         *        default, Glue Studio will recognize null objects, but some values such as empty strings, strings that
         *        are "null", -1 integers or other placeholders such as zeros, are not automatically recognized as
         *        nulls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropNullFields(DropNullFields dropNullFields);

        /**
         * <p>
         * Specifies a transform that removes columns from the dataset if all values in the column are 'null'. By
         * default, Glue Studio will recognize null objects, but some values such as empty strings, strings that are
         * "null", -1 integers or other placeholders such as zeros, are not automatically recognized as nulls.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropNullFields.Builder} avoiding the need
         * to create one manually via {@link DropNullFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropNullFields.Builder#build()} is called immediately and its
         * result is passed to {@link #dropNullFields(DropNullFields)}.
         * 
         * @param dropNullFields
         *        a consumer that will call methods on {@link DropNullFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dropNullFields(DropNullFields)
         */
        default Builder dropNullFields(Consumer<DropNullFields.Builder> dropNullFields) {
            return dropNullFields(DropNullFields.builder().applyMutation(dropNullFields).build());
        }

        /**
         * <p>
         * Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code> based
         * on the specified primary keys to identify records. Duplicate records (records with the same primary keys) are
         * not de-duplicated.
         * </p>
         * 
         * @param merge
         *        Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code>
         *        based on the specified primary keys to identify records. Duplicate records (records with the same
         *        primary keys) are not de-duplicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder merge(Merge merge);

        /**
         * <p>
         * Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code> based
         * on the specified primary keys to identify records. Duplicate records (records with the same primary keys) are
         * not de-duplicated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Merge.Builder} avoiding the need to
         * create one manually via {@link Merge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Merge.Builder#build()} is called immediately and its result is
         * passed to {@link #merge(Merge)}.
         * 
         * @param merge
         *        a consumer that will call methods on {@link Merge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #merge(Merge)
         */
        default Builder merge(Consumer<Merge.Builder> merge) {
            return merge(Merge.builder().applyMutation(merge).build());
        }

        /**
         * <p>
         * Specifies a transform that combines the rows from two or more datasets into a single result.
         * </p>
         * 
         * @param union
         *        Specifies a transform that combines the rows from two or more datasets into a single result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder union(Union union);

        /**
         * <p>
         * Specifies a transform that combines the rows from two or more datasets into a single result.
         * </p>
         * This is a convenience method that creates an instance of the {@link Union.Builder} avoiding the need to
         * create one manually via {@link Union#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Union.Builder#build()} is called immediately and its result is
         * passed to {@link #union(Union)}.
         * 
         * @param union
         *        a consumer that will call methods on {@link Union.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #union(Union)
         */
        default Builder union(Consumer<Union.Builder> union) {
            return union(Union.builder().applyMutation(union).build());
        }

        /**
         * <p>
         * Specifies a transform that identifies, removes or masks PII data.
         * </p>
         * 
         * @param piiDetection
         *        Specifies a transform that identifies, removes or masks PII data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiDetection(PIIDetection piiDetection);

        /**
         * <p>
         * Specifies a transform that identifies, removes or masks PII data.
         * </p>
         * This is a convenience method that creates an instance of the {@link PIIDetection.Builder} avoiding the need
         * to create one manually via {@link PIIDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PIIDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #piiDetection(PIIDetection)}.
         * 
         * @param piiDetection
         *        a consumer that will call methods on {@link PIIDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiDetection(PIIDetection)
         */
        default Builder piiDetection(Consumer<PIIDetection.Builder> piiDetection) {
            return piiDetection(PIIDetection.builder().applyMutation(piiDetection).build());
        }

        /**
         * <p>
         * Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified
         * function.
         * </p>
         * 
         * @param aggregate
         *        Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified
         *        function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregate(Aggregate aggregate);

        /**
         * <p>
         * Specifies a transform that groups rows by chosen fields and computes the aggregated value by specified
         * function.
         * </p>
         * This is a convenience method that creates an instance of the {@link Aggregate.Builder} avoiding the need to
         * create one manually via {@link Aggregate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Aggregate.Builder#build()} is called immediately and its result
         * is passed to {@link #aggregate(Aggregate)}.
         * 
         * @param aggregate
         *        a consumer that will call methods on {@link Aggregate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregate(Aggregate)
         */
        default Builder aggregate(Consumer<Aggregate.Builder> aggregate) {
            return aggregate(Aggregate.builder().applyMutation(aggregate).build());
        }

        /**
         * <p>
         * Specifies a transform that removes rows of repeating data from a data set.
         * </p>
         * 
         * @param dropDuplicates
         *        Specifies a transform that removes rows of repeating data from a data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropDuplicates(DropDuplicates dropDuplicates);

        /**
         * <p>
         * Specifies a transform that removes rows of repeating data from a data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropDuplicates.Builder} avoiding the need
         * to create one manually via {@link DropDuplicates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropDuplicates.Builder#build()} is called immediately and its
         * result is passed to {@link #dropDuplicates(DropDuplicates)}.
         * 
         * @param dropDuplicates
         *        a consumer that will call methods on {@link DropDuplicates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dropDuplicates(DropDuplicates)
         */
        default Builder dropDuplicates(Consumer<DropDuplicates.Builder> dropDuplicates) {
            return dropDuplicates(DropDuplicates.builder().applyMutation(dropDuplicates).build());
        }

        /**
         * <p>
         * Specifies a data target that writes to a goverened catalog.
         * </p>
         * 
         * @param governedCatalogTarget
         *        Specifies a data target that writes to a goverened catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedCatalogTarget(GovernedCatalogTarget governedCatalogTarget);

        /**
         * <p>
         * Specifies a data target that writes to a goverened catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link GovernedCatalogTarget.Builder} avoiding
         * the need to create one manually via {@link GovernedCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GovernedCatalogTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #governedCatalogTarget(GovernedCatalogTarget)}.
         * 
         * @param governedCatalogTarget
         *        a consumer that will call methods on {@link GovernedCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #governedCatalogTarget(GovernedCatalogTarget)
         */
        default Builder governedCatalogTarget(Consumer<GovernedCatalogTarget.Builder> governedCatalogTarget) {
            return governedCatalogTarget(GovernedCatalogTarget.builder().applyMutation(governedCatalogTarget).build());
        }

        /**
         * <p>
         * Specifies a data source in a goverened Data Catalog.
         * </p>
         * 
         * @param governedCatalogSource
         *        Specifies a data source in a goverened Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedCatalogSource(GovernedCatalogSource governedCatalogSource);

        /**
         * <p>
         * Specifies a data source in a goverened Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link GovernedCatalogSource.Builder} avoiding
         * the need to create one manually via {@link GovernedCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GovernedCatalogSource.Builder#build()} is called immediately and
         * its result is passed to {@link #governedCatalogSource(GovernedCatalogSource)}.
         * 
         * @param governedCatalogSource
         *        a consumer that will call methods on {@link GovernedCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #governedCatalogSource(GovernedCatalogSource)
         */
        default Builder governedCatalogSource(Consumer<GovernedCatalogSource.Builder> governedCatalogSource) {
            return governedCatalogSource(GovernedCatalogSource.builder().applyMutation(governedCatalogSource).build());
        }

        /**
         * <p>
         * Specifies a Microsoft SQL server data source in the Glue Data Catalog.
         * </p>
         * 
         * @param microsoftSQLServerCatalogSource
         *        Specifies a Microsoft SQL server data source in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftSQLServerCatalogSource(MicrosoftSQLServerCatalogSource microsoftSQLServerCatalogSource);

        /**
         * <p>
         * Specifies a Microsoft SQL server data source in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link MicrosoftSQLServerCatalogSource.Builder}
         * avoiding the need to create one manually via {@link MicrosoftSQLServerCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftSQLServerCatalogSource.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #microsoftSQLServerCatalogSource(MicrosoftSQLServerCatalogSource)}.
         * 
         * @param microsoftSQLServerCatalogSource
         *        a consumer that will call methods on {@link MicrosoftSQLServerCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftSQLServerCatalogSource(MicrosoftSQLServerCatalogSource)
         */
        default Builder microsoftSQLServerCatalogSource(
                Consumer<MicrosoftSQLServerCatalogSource.Builder> microsoftSQLServerCatalogSource) {
            return microsoftSQLServerCatalogSource(MicrosoftSQLServerCatalogSource.builder()
                    .applyMutation(microsoftSQLServerCatalogSource).build());
        }

        /**
         * <p>
         * Specifies a MySQL data source in the Glue Data Catalog.
         * </p>
         * 
         * @param mySQLCatalogSource
         *        Specifies a MySQL data source in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mySQLCatalogSource(MySQLCatalogSource mySQLCatalogSource);

        /**
         * <p>
         * Specifies a MySQL data source in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link MySQLCatalogSource.Builder} avoiding the
         * need to create one manually via {@link MySQLCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MySQLCatalogSource.Builder#build()} is called immediately and its
         * result is passed to {@link #mySQLCatalogSource(MySQLCatalogSource)}.
         * 
         * @param mySQLCatalogSource
         *        a consumer that will call methods on {@link MySQLCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mySQLCatalogSource(MySQLCatalogSource)
         */
        default Builder mySQLCatalogSource(Consumer<MySQLCatalogSource.Builder> mySQLCatalogSource) {
            return mySQLCatalogSource(MySQLCatalogSource.builder().applyMutation(mySQLCatalogSource).build());
        }

        /**
         * <p>
         * Specifies an Oracle data source in the Glue Data Catalog.
         * </p>
         * 
         * @param oracleSQLCatalogSource
         *        Specifies an Oracle data source in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oracleSQLCatalogSource(OracleSQLCatalogSource oracleSQLCatalogSource);

        /**
         * <p>
         * Specifies an Oracle data source in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link OracleSQLCatalogSource.Builder} avoiding
         * the need to create one manually via {@link OracleSQLCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OracleSQLCatalogSource.Builder#build()} is called immediately and
         * its result is passed to {@link #oracleSQLCatalogSource(OracleSQLCatalogSource)}.
         * 
         * @param oracleSQLCatalogSource
         *        a consumer that will call methods on {@link OracleSQLCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oracleSQLCatalogSource(OracleSQLCatalogSource)
         */
        default Builder oracleSQLCatalogSource(Consumer<OracleSQLCatalogSource.Builder> oracleSQLCatalogSource) {
            return oracleSQLCatalogSource(OracleSQLCatalogSource.builder().applyMutation(oracleSQLCatalogSource).build());
        }

        /**
         * <p>
         * Specifies a PostgresSQL data source in the Glue Data Catalog.
         * </p>
         * 
         * @param postgreSQLCatalogSource
         *        Specifies a PostgresSQL data source in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postgreSQLCatalogSource(PostgreSQLCatalogSource postgreSQLCatalogSource);

        /**
         * <p>
         * Specifies a PostgresSQL data source in the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostgreSQLCatalogSource.Builder} avoiding
         * the need to create one manually via {@link PostgreSQLCatalogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostgreSQLCatalogSource.Builder#build()} is called immediately
         * and its result is passed to {@link #postgreSQLCatalogSource(PostgreSQLCatalogSource)}.
         * 
         * @param postgreSQLCatalogSource
         *        a consumer that will call methods on {@link PostgreSQLCatalogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postgreSQLCatalogSource(PostgreSQLCatalogSource)
         */
        default Builder postgreSQLCatalogSource(Consumer<PostgreSQLCatalogSource.Builder> postgreSQLCatalogSource) {
            return postgreSQLCatalogSource(PostgreSQLCatalogSource.builder().applyMutation(postgreSQLCatalogSource).build());
        }

        /**
         * <p>
         * Specifies a target that uses Microsoft SQL.
         * </p>
         * 
         * @param microsoftSQLServerCatalogTarget
         *        Specifies a target that uses Microsoft SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftSQLServerCatalogTarget(MicrosoftSQLServerCatalogTarget microsoftSQLServerCatalogTarget);

        /**
         * <p>
         * Specifies a target that uses Microsoft SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link MicrosoftSQLServerCatalogTarget.Builder}
         * avoiding the need to create one manually via {@link MicrosoftSQLServerCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftSQLServerCatalogTarget.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #microsoftSQLServerCatalogTarget(MicrosoftSQLServerCatalogTarget)}.
         * 
         * @param microsoftSQLServerCatalogTarget
         *        a consumer that will call methods on {@link MicrosoftSQLServerCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftSQLServerCatalogTarget(MicrosoftSQLServerCatalogTarget)
         */
        default Builder microsoftSQLServerCatalogTarget(
                Consumer<MicrosoftSQLServerCatalogTarget.Builder> microsoftSQLServerCatalogTarget) {
            return microsoftSQLServerCatalogTarget(MicrosoftSQLServerCatalogTarget.builder()
                    .applyMutation(microsoftSQLServerCatalogTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses MySQL.
         * </p>
         * 
         * @param mySQLCatalogTarget
         *        Specifies a target that uses MySQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mySQLCatalogTarget(MySQLCatalogTarget mySQLCatalogTarget);

        /**
         * <p>
         * Specifies a target that uses MySQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link MySQLCatalogTarget.Builder} avoiding the
         * need to create one manually via {@link MySQLCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MySQLCatalogTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #mySQLCatalogTarget(MySQLCatalogTarget)}.
         * 
         * @param mySQLCatalogTarget
         *        a consumer that will call methods on {@link MySQLCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mySQLCatalogTarget(MySQLCatalogTarget)
         */
        default Builder mySQLCatalogTarget(Consumer<MySQLCatalogTarget.Builder> mySQLCatalogTarget) {
            return mySQLCatalogTarget(MySQLCatalogTarget.builder().applyMutation(mySQLCatalogTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses Oracle SQL.
         * </p>
         * 
         * @param oracleSQLCatalogTarget
         *        Specifies a target that uses Oracle SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oracleSQLCatalogTarget(OracleSQLCatalogTarget oracleSQLCatalogTarget);

        /**
         * <p>
         * Specifies a target that uses Oracle SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link OracleSQLCatalogTarget.Builder} avoiding
         * the need to create one manually via {@link OracleSQLCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OracleSQLCatalogTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #oracleSQLCatalogTarget(OracleSQLCatalogTarget)}.
         * 
         * @param oracleSQLCatalogTarget
         *        a consumer that will call methods on {@link OracleSQLCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oracleSQLCatalogTarget(OracleSQLCatalogTarget)
         */
        default Builder oracleSQLCatalogTarget(Consumer<OracleSQLCatalogTarget.Builder> oracleSQLCatalogTarget) {
            return oracleSQLCatalogTarget(OracleSQLCatalogTarget.builder().applyMutation(oracleSQLCatalogTarget).build());
        }

        /**
         * <p>
         * Specifies a target that uses Postgres SQL.
         * </p>
         * 
         * @param postgreSQLCatalogTarget
         *        Specifies a target that uses Postgres SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postgreSQLCatalogTarget(PostgreSQLCatalogTarget postgreSQLCatalogTarget);

        /**
         * <p>
         * Specifies a target that uses Postgres SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostgreSQLCatalogTarget.Builder} avoiding
         * the need to create one manually via {@link PostgreSQLCatalogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostgreSQLCatalogTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #postgreSQLCatalogTarget(PostgreSQLCatalogTarget)}.
         * 
         * @param postgreSQLCatalogTarget
         *        a consumer that will call methods on {@link PostgreSQLCatalogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postgreSQLCatalogTarget(PostgreSQLCatalogTarget)
         */
        default Builder postgreSQLCatalogTarget(Consumer<PostgreSQLCatalogTarget.Builder> postgreSQLCatalogTarget) {
            return postgreSQLCatalogTarget(PostgreSQLCatalogTarget.builder().applyMutation(postgreSQLCatalogTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AthenaConnectorSource athenaConnectorSource;

        private JDBCConnectorSource jdbcConnectorSource;

        private SparkConnectorSource sparkConnectorSource;

        private CatalogSource catalogSource;

        private RedshiftSource redshiftSource;

        private S3CatalogSource s3CatalogSource;

        private S3CsvSource s3CsvSource;

        private S3JsonSource s3JsonSource;

        private S3ParquetSource s3ParquetSource;

        private RelationalCatalogSource relationalCatalogSource;

        private DynamoDBCatalogSource dynamoDBCatalogSource;

        private JDBCConnectorTarget jdbcConnectorTarget;

        private SparkConnectorTarget sparkConnectorTarget;

        private BasicCatalogTarget catalogTarget;

        private RedshiftTarget redshiftTarget;

        private S3CatalogTarget s3CatalogTarget;

        private S3GlueParquetTarget s3GlueParquetTarget;

        private S3DirectTarget s3DirectTarget;

        private ApplyMapping applyMapping;

        private SelectFields selectFields;

        private DropFields dropFields;

        private RenameField renameField;

        private Spigot spigot;

        private Join join;

        private SplitFields splitFields;

        private SelectFromCollection selectFromCollection;

        private FillMissingValues fillMissingValues;

        private Filter filter;

        private CustomCode customCode;

        private SparkSQL sparkSQL;

        private DirectKinesisSource directKinesisSource;

        private DirectKafkaSource directKafkaSource;

        private CatalogKinesisSource catalogKinesisSource;

        private CatalogKafkaSource catalogKafkaSource;

        private DropNullFields dropNullFields;

        private Merge merge;

        private Union union;

        private PIIDetection piiDetection;

        private Aggregate aggregate;

        private DropDuplicates dropDuplicates;

        private GovernedCatalogTarget governedCatalogTarget;

        private GovernedCatalogSource governedCatalogSource;

        private MicrosoftSQLServerCatalogSource microsoftSQLServerCatalogSource;

        private MySQLCatalogSource mySQLCatalogSource;

        private OracleSQLCatalogSource oracleSQLCatalogSource;

        private PostgreSQLCatalogSource postgreSQLCatalogSource;

        private MicrosoftSQLServerCatalogTarget microsoftSQLServerCatalogTarget;

        private MySQLCatalogTarget mySQLCatalogTarget;

        private OracleSQLCatalogTarget oracleSQLCatalogTarget;

        private PostgreSQLCatalogTarget postgreSQLCatalogTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenConfigurationNode model) {
            athenaConnectorSource(model.athenaConnectorSource);
            jdbcConnectorSource(model.jdbcConnectorSource);
            sparkConnectorSource(model.sparkConnectorSource);
            catalogSource(model.catalogSource);
            redshiftSource(model.redshiftSource);
            s3CatalogSource(model.s3CatalogSource);
            s3CsvSource(model.s3CsvSource);
            s3JsonSource(model.s3JsonSource);
            s3ParquetSource(model.s3ParquetSource);
            relationalCatalogSource(model.relationalCatalogSource);
            dynamoDBCatalogSource(model.dynamoDBCatalogSource);
            jdbcConnectorTarget(model.jdbcConnectorTarget);
            sparkConnectorTarget(model.sparkConnectorTarget);
            catalogTarget(model.catalogTarget);
            redshiftTarget(model.redshiftTarget);
            s3CatalogTarget(model.s3CatalogTarget);
            s3GlueParquetTarget(model.s3GlueParquetTarget);
            s3DirectTarget(model.s3DirectTarget);
            applyMapping(model.applyMapping);
            selectFields(model.selectFields);
            dropFields(model.dropFields);
            renameField(model.renameField);
            spigot(model.spigot);
            join(model.join);
            splitFields(model.splitFields);
            selectFromCollection(model.selectFromCollection);
            fillMissingValues(model.fillMissingValues);
            filter(model.filter);
            customCode(model.customCode);
            sparkSQL(model.sparkSQL);
            directKinesisSource(model.directKinesisSource);
            directKafkaSource(model.directKafkaSource);
            catalogKinesisSource(model.catalogKinesisSource);
            catalogKafkaSource(model.catalogKafkaSource);
            dropNullFields(model.dropNullFields);
            merge(model.merge);
            union(model.union);
            piiDetection(model.piiDetection);
            aggregate(model.aggregate);
            dropDuplicates(model.dropDuplicates);
            governedCatalogTarget(model.governedCatalogTarget);
            governedCatalogSource(model.governedCatalogSource);
            microsoftSQLServerCatalogSource(model.microsoftSQLServerCatalogSource);
            mySQLCatalogSource(model.mySQLCatalogSource);
            oracleSQLCatalogSource(model.oracleSQLCatalogSource);
            postgreSQLCatalogSource(model.postgreSQLCatalogSource);
            microsoftSQLServerCatalogTarget(model.microsoftSQLServerCatalogTarget);
            mySQLCatalogTarget(model.mySQLCatalogTarget);
            oracleSQLCatalogTarget(model.oracleSQLCatalogTarget);
            postgreSQLCatalogTarget(model.postgreSQLCatalogTarget);
        }

        public final AthenaConnectorSource.Builder getAthenaConnectorSource() {
            return athenaConnectorSource != null ? athenaConnectorSource.toBuilder() : null;
        }

        public final void setAthenaConnectorSource(AthenaConnectorSource.BuilderImpl athenaConnectorSource) {
            this.athenaConnectorSource = athenaConnectorSource != null ? athenaConnectorSource.build() : null;
        }

        @Override
        public final Builder athenaConnectorSource(AthenaConnectorSource athenaConnectorSource) {
            this.athenaConnectorSource = athenaConnectorSource;
            return this;
        }

        public final JDBCConnectorSource.Builder getJdbcConnectorSource() {
            return jdbcConnectorSource != null ? jdbcConnectorSource.toBuilder() : null;
        }

        public final void setJdbcConnectorSource(JDBCConnectorSource.BuilderImpl jdbcConnectorSource) {
            this.jdbcConnectorSource = jdbcConnectorSource != null ? jdbcConnectorSource.build() : null;
        }

        @Override
        public final Builder jdbcConnectorSource(JDBCConnectorSource jdbcConnectorSource) {
            this.jdbcConnectorSource = jdbcConnectorSource;
            return this;
        }

        public final SparkConnectorSource.Builder getSparkConnectorSource() {
            return sparkConnectorSource != null ? sparkConnectorSource.toBuilder() : null;
        }

        public final void setSparkConnectorSource(SparkConnectorSource.BuilderImpl sparkConnectorSource) {
            this.sparkConnectorSource = sparkConnectorSource != null ? sparkConnectorSource.build() : null;
        }

        @Override
        public final Builder sparkConnectorSource(SparkConnectorSource sparkConnectorSource) {
            this.sparkConnectorSource = sparkConnectorSource;
            return this;
        }

        public final CatalogSource.Builder getCatalogSource() {
            return catalogSource != null ? catalogSource.toBuilder() : null;
        }

        public final void setCatalogSource(CatalogSource.BuilderImpl catalogSource) {
            this.catalogSource = catalogSource != null ? catalogSource.build() : null;
        }

        @Override
        public final Builder catalogSource(CatalogSource catalogSource) {
            this.catalogSource = catalogSource;
            return this;
        }

        public final RedshiftSource.Builder getRedshiftSource() {
            return redshiftSource != null ? redshiftSource.toBuilder() : null;
        }

        public final void setRedshiftSource(RedshiftSource.BuilderImpl redshiftSource) {
            this.redshiftSource = redshiftSource != null ? redshiftSource.build() : null;
        }

        @Override
        public final Builder redshiftSource(RedshiftSource redshiftSource) {
            this.redshiftSource = redshiftSource;
            return this;
        }

        public final S3CatalogSource.Builder getS3CatalogSource() {
            return s3CatalogSource != null ? s3CatalogSource.toBuilder() : null;
        }

        public final void setS3CatalogSource(S3CatalogSource.BuilderImpl s3CatalogSource) {
            this.s3CatalogSource = s3CatalogSource != null ? s3CatalogSource.build() : null;
        }

        @Override
        public final Builder s3CatalogSource(S3CatalogSource s3CatalogSource) {
            this.s3CatalogSource = s3CatalogSource;
            return this;
        }

        public final S3CsvSource.Builder getS3CsvSource() {
            return s3CsvSource != null ? s3CsvSource.toBuilder() : null;
        }

        public final void setS3CsvSource(S3CsvSource.BuilderImpl s3CsvSource) {
            this.s3CsvSource = s3CsvSource != null ? s3CsvSource.build() : null;
        }

        @Override
        public final Builder s3CsvSource(S3CsvSource s3CsvSource) {
            this.s3CsvSource = s3CsvSource;
            return this;
        }

        public final S3JsonSource.Builder getS3JsonSource() {
            return s3JsonSource != null ? s3JsonSource.toBuilder() : null;
        }

        public final void setS3JsonSource(S3JsonSource.BuilderImpl s3JsonSource) {
            this.s3JsonSource = s3JsonSource != null ? s3JsonSource.build() : null;
        }

        @Override
        public final Builder s3JsonSource(S3JsonSource s3JsonSource) {
            this.s3JsonSource = s3JsonSource;
            return this;
        }

        public final S3ParquetSource.Builder getS3ParquetSource() {
            return s3ParquetSource != null ? s3ParquetSource.toBuilder() : null;
        }

        public final void setS3ParquetSource(S3ParquetSource.BuilderImpl s3ParquetSource) {
            this.s3ParquetSource = s3ParquetSource != null ? s3ParquetSource.build() : null;
        }

        @Override
        public final Builder s3ParquetSource(S3ParquetSource s3ParquetSource) {
            this.s3ParquetSource = s3ParquetSource;
            return this;
        }

        public final RelationalCatalogSource.Builder getRelationalCatalogSource() {
            return relationalCatalogSource != null ? relationalCatalogSource.toBuilder() : null;
        }

        public final void setRelationalCatalogSource(RelationalCatalogSource.BuilderImpl relationalCatalogSource) {
            this.relationalCatalogSource = relationalCatalogSource != null ? relationalCatalogSource.build() : null;
        }

        @Override
        public final Builder relationalCatalogSource(RelationalCatalogSource relationalCatalogSource) {
            this.relationalCatalogSource = relationalCatalogSource;
            return this;
        }

        public final DynamoDBCatalogSource.Builder getDynamoDBCatalogSource() {
            return dynamoDBCatalogSource != null ? dynamoDBCatalogSource.toBuilder() : null;
        }

        public final void setDynamoDBCatalogSource(DynamoDBCatalogSource.BuilderImpl dynamoDBCatalogSource) {
            this.dynamoDBCatalogSource = dynamoDBCatalogSource != null ? dynamoDBCatalogSource.build() : null;
        }

        @Override
        public final Builder dynamoDBCatalogSource(DynamoDBCatalogSource dynamoDBCatalogSource) {
            this.dynamoDBCatalogSource = dynamoDBCatalogSource;
            return this;
        }

        public final JDBCConnectorTarget.Builder getJdbcConnectorTarget() {
            return jdbcConnectorTarget != null ? jdbcConnectorTarget.toBuilder() : null;
        }

        public final void setJdbcConnectorTarget(JDBCConnectorTarget.BuilderImpl jdbcConnectorTarget) {
            this.jdbcConnectorTarget = jdbcConnectorTarget != null ? jdbcConnectorTarget.build() : null;
        }

        @Override
        public final Builder jdbcConnectorTarget(JDBCConnectorTarget jdbcConnectorTarget) {
            this.jdbcConnectorTarget = jdbcConnectorTarget;
            return this;
        }

        public final SparkConnectorTarget.Builder getSparkConnectorTarget() {
            return sparkConnectorTarget != null ? sparkConnectorTarget.toBuilder() : null;
        }

        public final void setSparkConnectorTarget(SparkConnectorTarget.BuilderImpl sparkConnectorTarget) {
            this.sparkConnectorTarget = sparkConnectorTarget != null ? sparkConnectorTarget.build() : null;
        }

        @Override
        public final Builder sparkConnectorTarget(SparkConnectorTarget sparkConnectorTarget) {
            this.sparkConnectorTarget = sparkConnectorTarget;
            return this;
        }

        public final BasicCatalogTarget.Builder getCatalogTarget() {
            return catalogTarget != null ? catalogTarget.toBuilder() : null;
        }

        public final void setCatalogTarget(BasicCatalogTarget.BuilderImpl catalogTarget) {
            this.catalogTarget = catalogTarget != null ? catalogTarget.build() : null;
        }

        @Override
        public final Builder catalogTarget(BasicCatalogTarget catalogTarget) {
            this.catalogTarget = catalogTarget;
            return this;
        }

        public final RedshiftTarget.Builder getRedshiftTarget() {
            return redshiftTarget != null ? redshiftTarget.toBuilder() : null;
        }

        public final void setRedshiftTarget(RedshiftTarget.BuilderImpl redshiftTarget) {
            this.redshiftTarget = redshiftTarget != null ? redshiftTarget.build() : null;
        }

        @Override
        public final Builder redshiftTarget(RedshiftTarget redshiftTarget) {
            this.redshiftTarget = redshiftTarget;
            return this;
        }

        public final S3CatalogTarget.Builder getS3CatalogTarget() {
            return s3CatalogTarget != null ? s3CatalogTarget.toBuilder() : null;
        }

        public final void setS3CatalogTarget(S3CatalogTarget.BuilderImpl s3CatalogTarget) {
            this.s3CatalogTarget = s3CatalogTarget != null ? s3CatalogTarget.build() : null;
        }

        @Override
        public final Builder s3CatalogTarget(S3CatalogTarget s3CatalogTarget) {
            this.s3CatalogTarget = s3CatalogTarget;
            return this;
        }

        public final S3GlueParquetTarget.Builder getS3GlueParquetTarget() {
            return s3GlueParquetTarget != null ? s3GlueParquetTarget.toBuilder() : null;
        }

        public final void setS3GlueParquetTarget(S3GlueParquetTarget.BuilderImpl s3GlueParquetTarget) {
            this.s3GlueParquetTarget = s3GlueParquetTarget != null ? s3GlueParquetTarget.build() : null;
        }

        @Override
        public final Builder s3GlueParquetTarget(S3GlueParquetTarget s3GlueParquetTarget) {
            this.s3GlueParquetTarget = s3GlueParquetTarget;
            return this;
        }

        public final S3DirectTarget.Builder getS3DirectTarget() {
            return s3DirectTarget != null ? s3DirectTarget.toBuilder() : null;
        }

        public final void setS3DirectTarget(S3DirectTarget.BuilderImpl s3DirectTarget) {
            this.s3DirectTarget = s3DirectTarget != null ? s3DirectTarget.build() : null;
        }

        @Override
        public final Builder s3DirectTarget(S3DirectTarget s3DirectTarget) {
            this.s3DirectTarget = s3DirectTarget;
            return this;
        }

        public final ApplyMapping.Builder getApplyMapping() {
            return applyMapping != null ? applyMapping.toBuilder() : null;
        }

        public final void setApplyMapping(ApplyMapping.BuilderImpl applyMapping) {
            this.applyMapping = applyMapping != null ? applyMapping.build() : null;
        }

        @Override
        public final Builder applyMapping(ApplyMapping applyMapping) {
            this.applyMapping = applyMapping;
            return this;
        }

        public final SelectFields.Builder getSelectFields() {
            return selectFields != null ? selectFields.toBuilder() : null;
        }

        public final void setSelectFields(SelectFields.BuilderImpl selectFields) {
            this.selectFields = selectFields != null ? selectFields.build() : null;
        }

        @Override
        public final Builder selectFields(SelectFields selectFields) {
            this.selectFields = selectFields;
            return this;
        }

        public final DropFields.Builder getDropFields() {
            return dropFields != null ? dropFields.toBuilder() : null;
        }

        public final void setDropFields(DropFields.BuilderImpl dropFields) {
            this.dropFields = dropFields != null ? dropFields.build() : null;
        }

        @Override
        public final Builder dropFields(DropFields dropFields) {
            this.dropFields = dropFields;
            return this;
        }

        public final RenameField.Builder getRenameField() {
            return renameField != null ? renameField.toBuilder() : null;
        }

        public final void setRenameField(RenameField.BuilderImpl renameField) {
            this.renameField = renameField != null ? renameField.build() : null;
        }

        @Override
        public final Builder renameField(RenameField renameField) {
            this.renameField = renameField;
            return this;
        }

        public final Spigot.Builder getSpigot() {
            return spigot != null ? spigot.toBuilder() : null;
        }

        public final void setSpigot(Spigot.BuilderImpl spigot) {
            this.spigot = spigot != null ? spigot.build() : null;
        }

        @Override
        public final Builder spigot(Spigot spigot) {
            this.spigot = spigot;
            return this;
        }

        public final Join.Builder getJoin() {
            return join != null ? join.toBuilder() : null;
        }

        public final void setJoin(Join.BuilderImpl join) {
            this.join = join != null ? join.build() : null;
        }

        @Override
        public final Builder join(Join join) {
            this.join = join;
            return this;
        }

        public final SplitFields.Builder getSplitFields() {
            return splitFields != null ? splitFields.toBuilder() : null;
        }

        public final void setSplitFields(SplitFields.BuilderImpl splitFields) {
            this.splitFields = splitFields != null ? splitFields.build() : null;
        }

        @Override
        public final Builder splitFields(SplitFields splitFields) {
            this.splitFields = splitFields;
            return this;
        }

        public final SelectFromCollection.Builder getSelectFromCollection() {
            return selectFromCollection != null ? selectFromCollection.toBuilder() : null;
        }

        public final void setSelectFromCollection(SelectFromCollection.BuilderImpl selectFromCollection) {
            this.selectFromCollection = selectFromCollection != null ? selectFromCollection.build() : null;
        }

        @Override
        public final Builder selectFromCollection(SelectFromCollection selectFromCollection) {
            this.selectFromCollection = selectFromCollection;
            return this;
        }

        public final FillMissingValues.Builder getFillMissingValues() {
            return fillMissingValues != null ? fillMissingValues.toBuilder() : null;
        }

        public final void setFillMissingValues(FillMissingValues.BuilderImpl fillMissingValues) {
            this.fillMissingValues = fillMissingValues != null ? fillMissingValues.build() : null;
        }

        @Override
        public final Builder fillMissingValues(FillMissingValues fillMissingValues) {
            this.fillMissingValues = fillMissingValues;
            return this;
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final CustomCode.Builder getCustomCode() {
            return customCode != null ? customCode.toBuilder() : null;
        }

        public final void setCustomCode(CustomCode.BuilderImpl customCode) {
            this.customCode = customCode != null ? customCode.build() : null;
        }

        @Override
        public final Builder customCode(CustomCode customCode) {
            this.customCode = customCode;
            return this;
        }

        public final SparkSQL.Builder getSparkSQL() {
            return sparkSQL != null ? sparkSQL.toBuilder() : null;
        }

        public final void setSparkSQL(SparkSQL.BuilderImpl sparkSQL) {
            this.sparkSQL = sparkSQL != null ? sparkSQL.build() : null;
        }

        @Override
        public final Builder sparkSQL(SparkSQL sparkSQL) {
            this.sparkSQL = sparkSQL;
            return this;
        }

        public final DirectKinesisSource.Builder getDirectKinesisSource() {
            return directKinesisSource != null ? directKinesisSource.toBuilder() : null;
        }

        public final void setDirectKinesisSource(DirectKinesisSource.BuilderImpl directKinesisSource) {
            this.directKinesisSource = directKinesisSource != null ? directKinesisSource.build() : null;
        }

        @Override
        public final Builder directKinesisSource(DirectKinesisSource directKinesisSource) {
            this.directKinesisSource = directKinesisSource;
            return this;
        }

        public final DirectKafkaSource.Builder getDirectKafkaSource() {
            return directKafkaSource != null ? directKafkaSource.toBuilder() : null;
        }

        public final void setDirectKafkaSource(DirectKafkaSource.BuilderImpl directKafkaSource) {
            this.directKafkaSource = directKafkaSource != null ? directKafkaSource.build() : null;
        }

        @Override
        public final Builder directKafkaSource(DirectKafkaSource directKafkaSource) {
            this.directKafkaSource = directKafkaSource;
            return this;
        }

        public final CatalogKinesisSource.Builder getCatalogKinesisSource() {
            return catalogKinesisSource != null ? catalogKinesisSource.toBuilder() : null;
        }

        public final void setCatalogKinesisSource(CatalogKinesisSource.BuilderImpl catalogKinesisSource) {
            this.catalogKinesisSource = catalogKinesisSource != null ? catalogKinesisSource.build() : null;
        }

        @Override
        public final Builder catalogKinesisSource(CatalogKinesisSource catalogKinesisSource) {
            this.catalogKinesisSource = catalogKinesisSource;
            return this;
        }

        public final CatalogKafkaSource.Builder getCatalogKafkaSource() {
            return catalogKafkaSource != null ? catalogKafkaSource.toBuilder() : null;
        }

        public final void setCatalogKafkaSource(CatalogKafkaSource.BuilderImpl catalogKafkaSource) {
            this.catalogKafkaSource = catalogKafkaSource != null ? catalogKafkaSource.build() : null;
        }

        @Override
        public final Builder catalogKafkaSource(CatalogKafkaSource catalogKafkaSource) {
            this.catalogKafkaSource = catalogKafkaSource;
            return this;
        }

        public final DropNullFields.Builder getDropNullFields() {
            return dropNullFields != null ? dropNullFields.toBuilder() : null;
        }

        public final void setDropNullFields(DropNullFields.BuilderImpl dropNullFields) {
            this.dropNullFields = dropNullFields != null ? dropNullFields.build() : null;
        }

        @Override
        public final Builder dropNullFields(DropNullFields dropNullFields) {
            this.dropNullFields = dropNullFields;
            return this;
        }

        public final Merge.Builder getMerge() {
            return merge != null ? merge.toBuilder() : null;
        }

        public final void setMerge(Merge.BuilderImpl merge) {
            this.merge = merge != null ? merge.build() : null;
        }

        @Override
        public final Builder merge(Merge merge) {
            this.merge = merge;
            return this;
        }

        public final Union.Builder getUnion() {
            return union != null ? union.toBuilder() : null;
        }

        public final void setUnion(Union.BuilderImpl union) {
            this.union = union != null ? union.build() : null;
        }

        @Override
        public final Builder union(Union union) {
            this.union = union;
            return this;
        }

        public final PIIDetection.Builder getPiiDetection() {
            return piiDetection != null ? piiDetection.toBuilder() : null;
        }

        public final void setPiiDetection(PIIDetection.BuilderImpl piiDetection) {
            this.piiDetection = piiDetection != null ? piiDetection.build() : null;
        }

        @Override
        public final Builder piiDetection(PIIDetection piiDetection) {
            this.piiDetection = piiDetection;
            return this;
        }

        public final Aggregate.Builder getAggregate() {
            return aggregate != null ? aggregate.toBuilder() : null;
        }

        public final void setAggregate(Aggregate.BuilderImpl aggregate) {
            this.aggregate = aggregate != null ? aggregate.build() : null;
        }

        @Override
        public final Builder aggregate(Aggregate aggregate) {
            this.aggregate = aggregate;
            return this;
        }

        public final DropDuplicates.Builder getDropDuplicates() {
            return dropDuplicates != null ? dropDuplicates.toBuilder() : null;
        }

        public final void setDropDuplicates(DropDuplicates.BuilderImpl dropDuplicates) {
            this.dropDuplicates = dropDuplicates != null ? dropDuplicates.build() : null;
        }

        @Override
        public final Builder dropDuplicates(DropDuplicates dropDuplicates) {
            this.dropDuplicates = dropDuplicates;
            return this;
        }

        public final GovernedCatalogTarget.Builder getGovernedCatalogTarget() {
            return governedCatalogTarget != null ? governedCatalogTarget.toBuilder() : null;
        }

        public final void setGovernedCatalogTarget(GovernedCatalogTarget.BuilderImpl governedCatalogTarget) {
            this.governedCatalogTarget = governedCatalogTarget != null ? governedCatalogTarget.build() : null;
        }

        @Override
        public final Builder governedCatalogTarget(GovernedCatalogTarget governedCatalogTarget) {
            this.governedCatalogTarget = governedCatalogTarget;
            return this;
        }

        public final GovernedCatalogSource.Builder getGovernedCatalogSource() {
            return governedCatalogSource != null ? governedCatalogSource.toBuilder() : null;
        }

        public final void setGovernedCatalogSource(GovernedCatalogSource.BuilderImpl governedCatalogSource) {
            this.governedCatalogSource = governedCatalogSource != null ? governedCatalogSource.build() : null;
        }

        @Override
        public final Builder governedCatalogSource(GovernedCatalogSource governedCatalogSource) {
            this.governedCatalogSource = governedCatalogSource;
            return this;
        }

        public final MicrosoftSQLServerCatalogSource.Builder getMicrosoftSQLServerCatalogSource() {
            return microsoftSQLServerCatalogSource != null ? microsoftSQLServerCatalogSource.toBuilder() : null;
        }

        public final void setMicrosoftSQLServerCatalogSource(
                MicrosoftSQLServerCatalogSource.BuilderImpl microsoftSQLServerCatalogSource) {
            this.microsoftSQLServerCatalogSource = microsoftSQLServerCatalogSource != null ? microsoftSQLServerCatalogSource
                    .build() : null;
        }

        @Override
        public final Builder microsoftSQLServerCatalogSource(MicrosoftSQLServerCatalogSource microsoftSQLServerCatalogSource) {
            this.microsoftSQLServerCatalogSource = microsoftSQLServerCatalogSource;
            return this;
        }

        public final MySQLCatalogSource.Builder getMySQLCatalogSource() {
            return mySQLCatalogSource != null ? mySQLCatalogSource.toBuilder() : null;
        }

        public final void setMySQLCatalogSource(MySQLCatalogSource.BuilderImpl mySQLCatalogSource) {
            this.mySQLCatalogSource = mySQLCatalogSource != null ? mySQLCatalogSource.build() : null;
        }

        @Override
        public final Builder mySQLCatalogSource(MySQLCatalogSource mySQLCatalogSource) {
            this.mySQLCatalogSource = mySQLCatalogSource;
            return this;
        }

        public final OracleSQLCatalogSource.Builder getOracleSQLCatalogSource() {
            return oracleSQLCatalogSource != null ? oracleSQLCatalogSource.toBuilder() : null;
        }

        public final void setOracleSQLCatalogSource(OracleSQLCatalogSource.BuilderImpl oracleSQLCatalogSource) {
            this.oracleSQLCatalogSource = oracleSQLCatalogSource != null ? oracleSQLCatalogSource.build() : null;
        }

        @Override
        public final Builder oracleSQLCatalogSource(OracleSQLCatalogSource oracleSQLCatalogSource) {
            this.oracleSQLCatalogSource = oracleSQLCatalogSource;
            return this;
        }

        public final PostgreSQLCatalogSource.Builder getPostgreSQLCatalogSource() {
            return postgreSQLCatalogSource != null ? postgreSQLCatalogSource.toBuilder() : null;
        }

        public final void setPostgreSQLCatalogSource(PostgreSQLCatalogSource.BuilderImpl postgreSQLCatalogSource) {
            this.postgreSQLCatalogSource = postgreSQLCatalogSource != null ? postgreSQLCatalogSource.build() : null;
        }

        @Override
        public final Builder postgreSQLCatalogSource(PostgreSQLCatalogSource postgreSQLCatalogSource) {
            this.postgreSQLCatalogSource = postgreSQLCatalogSource;
            return this;
        }

        public final MicrosoftSQLServerCatalogTarget.Builder getMicrosoftSQLServerCatalogTarget() {
            return microsoftSQLServerCatalogTarget != null ? microsoftSQLServerCatalogTarget.toBuilder() : null;
        }

        public final void setMicrosoftSQLServerCatalogTarget(
                MicrosoftSQLServerCatalogTarget.BuilderImpl microsoftSQLServerCatalogTarget) {
            this.microsoftSQLServerCatalogTarget = microsoftSQLServerCatalogTarget != null ? microsoftSQLServerCatalogTarget
                    .build() : null;
        }

        @Override
        public final Builder microsoftSQLServerCatalogTarget(MicrosoftSQLServerCatalogTarget microsoftSQLServerCatalogTarget) {
            this.microsoftSQLServerCatalogTarget = microsoftSQLServerCatalogTarget;
            return this;
        }

        public final MySQLCatalogTarget.Builder getMySQLCatalogTarget() {
            return mySQLCatalogTarget != null ? mySQLCatalogTarget.toBuilder() : null;
        }

        public final void setMySQLCatalogTarget(MySQLCatalogTarget.BuilderImpl mySQLCatalogTarget) {
            this.mySQLCatalogTarget = mySQLCatalogTarget != null ? mySQLCatalogTarget.build() : null;
        }

        @Override
        public final Builder mySQLCatalogTarget(MySQLCatalogTarget mySQLCatalogTarget) {
            this.mySQLCatalogTarget = mySQLCatalogTarget;
            return this;
        }

        public final OracleSQLCatalogTarget.Builder getOracleSQLCatalogTarget() {
            return oracleSQLCatalogTarget != null ? oracleSQLCatalogTarget.toBuilder() : null;
        }

        public final void setOracleSQLCatalogTarget(OracleSQLCatalogTarget.BuilderImpl oracleSQLCatalogTarget) {
            this.oracleSQLCatalogTarget = oracleSQLCatalogTarget != null ? oracleSQLCatalogTarget.build() : null;
        }

        @Override
        public final Builder oracleSQLCatalogTarget(OracleSQLCatalogTarget oracleSQLCatalogTarget) {
            this.oracleSQLCatalogTarget = oracleSQLCatalogTarget;
            return this;
        }

        public final PostgreSQLCatalogTarget.Builder getPostgreSQLCatalogTarget() {
            return postgreSQLCatalogTarget != null ? postgreSQLCatalogTarget.toBuilder() : null;
        }

        public final void setPostgreSQLCatalogTarget(PostgreSQLCatalogTarget.BuilderImpl postgreSQLCatalogTarget) {
            this.postgreSQLCatalogTarget = postgreSQLCatalogTarget != null ? postgreSQLCatalogTarget.build() : null;
        }

        @Override
        public final Builder postgreSQLCatalogTarget(PostgreSQLCatalogTarget postgreSQLCatalogTarget) {
            this.postgreSQLCatalogTarget = postgreSQLCatalogTarget;
            return this;
        }

        @Override
        public CodeGenConfigurationNode build() {
            return new CodeGenConfigurationNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
