/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;

public class ListMLTransformsIterable
implements SdkIterable<ListMlTransformsResponse> {
    private final GlueClient client;
    private final ListMlTransformsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMLTransformsIterable(GlueClient client, ListMlTransformsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMlTransformsResponseFetcher();
    }

    public Iterator<ListMlTransformsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMlTransformsResponseFetcher
    implements SyncPageFetcher<ListMlTransformsResponse> {
        private ListMlTransformsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlTransformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMlTransformsResponse nextPage(ListMlTransformsResponse previousPage) {
            if (previousPage == null) {
                return ListMLTransformsIterable.this.client.listMLTransforms(ListMLTransformsIterable.this.firstRequest);
            }
            return ListMLTransformsIterable.this.client.listMLTransforms((ListMlTransformsRequest)((Object)ListMLTransformsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

