/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.PortRange;
import software.amazon.awssdk.services.globalaccelerator.model.PortRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomRoutingListenerRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, CreateCustomRoutingListenerRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(CreateCustomRoutingListenerRequest.getter(CreateCustomRoutingListenerRequest::acceleratorArn)).setter(CreateCustomRoutingListenerRequest.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(CreateCustomRoutingListenerRequest.getter(CreateCustomRoutingListenerRequest::portRanges)).setter(CreateCustomRoutingListenerRequest.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateCustomRoutingListenerRequest.getter(CreateCustomRoutingListenerRequest::idempotencyToken)).setter(CreateCustomRoutingListenerRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, PORT_RANGES_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String acceleratorArn;
    private final List<PortRange> portRanges;
    private final String idempotencyToken;

    private CreateCustomRoutingListenerRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.portRanges = builder.portRanges;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> portRanges() {
        return this.portRanges;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingListenerRequest)) {
            return false;
        }
        CreateCustomRoutingListenerRequest other = (CreateCustomRoutingListenerRequest)((Object)obj);
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomRoutingListenerRequest").add("AcceleratorArn", (Object)this.acceleratorArn()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomRoutingListenerRequest, T> g) {
        return obj -> g.apply((CreateCustomRoutingListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomRoutingListenerRequest model) {
            super(model);
            this.acceleratorArn(model.acceleratorArn);
            this.portRanges(model.portRanges);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomRoutingListenerRequest build() {
            return new CreateCustomRoutingListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomRoutingListenerRequest> {
        public Builder acceleratorArn(String var1);

        public Builder portRanges(Collection<PortRange> var1);

        public Builder portRanges(PortRange ... var1);

        public Builder portRanges(Consumer<PortRange.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

