/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientAffinity {
    NONE("NONE"),
    SOURCE_IP("SOURCE_IP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientAffinity> VALUE_MAP;
    private final String value;

    private ClientAffinity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientAffinity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientAffinity> knownValues() {
        EnumSet<ClientAffinity> knownValues = EnumSet.allOf(ClientAffinity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientAffinity.class, ClientAffinity::toString);
    }
}

