/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.services.glacier.GlacierBaseClientBuilder;
import software.amazon.awssdk.services.glacier.auth.scheme.GlacierAuthSchemeProvider;
import software.amazon.awssdk.services.glacier.auth.scheme.internal.GlacierAuthSchemeInterceptor;
import software.amazon.awssdk.services.glacier.endpoints.GlacierEndpointProvider;
import software.amazon.awssdk.services.glacier.endpoints.internal.GlacierRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.glacier.endpoints.internal.GlacierResolveEndpointInterceptor;
import software.amazon.awssdk.services.glacier.internal.AcceptJsonInterceptor;
import software.amazon.awssdk.services.glacier.internal.GlacierExecutionInterceptor;
import software.amazon.awssdk.services.glacier.internal.GlacierServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.glacier.internal.SdkClientConfigurationUtil;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultGlacierBaseClientBuilder<B extends GlacierBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultGlacierBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "glacier";
    }

    protected final String serviceName() {
        return "Glacier";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)this.defaultAuthSchemeProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new GlacierAuthSchemeInterceptor());
        endpointInterceptors.add(new GlacierResolveEndpointInterceptor());
        endpointInterceptors.add(new GlacierRequestSetEndpointInterceptor());
        endpointInterceptors.add(new AcceptJsonInterceptor());
        endpointInterceptors.add(new GlacierExecutionInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/glacier/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    protected final String signingName() {
        return "glacier";
    }

    private GlacierEndpointProvider defaultEndpointProvider() {
        return GlacierEndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(GlacierAuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return (B)((GlacierBaseClientBuilder)this.thisBuilder());
    }

    private GlacierAuthSchemeProvider defaultAuthSchemeProvider() {
        return GlacierAuthSchemeProvider.defaultProvider();
    }

    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((GlacierBaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap<String, Object> schemes = new HashMap<String, Object>(2 + this.additionalAuthSchemes.size());
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), awsV4AuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return Collections.unmodifiableMap(schemes);
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        ClientOverrideConfiguration overrideConfiguration = this.overrideConfiguration();
        if (overrideConfiguration == null) {
            return configuration;
        }
        return SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List plugins = this.plugins();
        if (plugins.isEmpty()) {
            return config;
        }
        GlacierServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = GlacierServiceClientConfigurationBuilder.builder(config.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.overrideConfiguration(serviceConfigBuilder.overrideConfiguration());
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
    }
}

