/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.PartListElement;

public class ListPartsIterable
implements SdkIterable<ListPartsResponse> {
    private final GlacierClient client;
    private final ListPartsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPartsIterable(GlacierClient client, ListPartsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPartsResponseFetcher();
    }

    public Iterator<ListPartsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PartListElement> parts() {
        Function<ListPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPartsResponseFetcher
    implements SyncPageFetcher<ListPartsResponse> {
        private ListPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListPartsResponse nextPage(ListPartsResponse previousPage) {
            if (previousPage == null) {
                return ListPartsIterable.this.client.listParts(ListPartsIterable.this.firstRequest);
            }
            return ListPartsIterable.this.client.listParts((ListPartsRequest)((Object)ListPartsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

