/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gamesparks.model.Section;
import software.amazon.awssdk.services.gamesparks.model.SectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameConfigurationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameConfigurationDetails> {
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(GameConfigurationDetails.getter(GameConfigurationDetails::created)).setter(GameConfigurationDetails.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(GameConfigurationDetails.getter(GameConfigurationDetails::lastUpdated)).setter(GameConfigurationDetails.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, Section>> SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Sections").getter(GameConfigurationDetails.getter(GameConfigurationDetails::sections)).setter(GameConfigurationDetails.setter(Builder::sections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sections").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Section::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, LAST_UPDATED_FIELD, SECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant created;
    private final Instant lastUpdated;
    private final Map<String, Section> sections;

    private GameConfigurationDetails(BuilderImpl builder) {
        this.created = builder.created;
        this.lastUpdated = builder.lastUpdated;
        this.sections = builder.sections;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final boolean hasSections() {
        return this.sections != null && !(this.sections instanceof SdkAutoConstructMap);
    }

    public final Map<String, Section> sections() {
        return this.sections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSections() ? this.sections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameConfigurationDetails)) {
            return false;
        }
        GameConfigurationDetails other = (GameConfigurationDetails)obj;
        return Objects.equals(this.created(), other.created()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && this.hasSections() == other.hasSections() && Objects.equals(this.sections(), other.sections());
    }

    public final String toString() {
        return ToString.builder((String)"GameConfigurationDetails").add("Created", (Object)this.created()).add("LastUpdated", (Object)this.lastUpdated()).add("Sections", this.hasSections() ? this.sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Sections": {
                return Optional.ofNullable(clazz.cast(this.sections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameConfigurationDetails, T> g) {
        return obj -> g.apply((GameConfigurationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant created;
        private Instant lastUpdated;
        private Map<String, Section> sections = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GameConfigurationDetails model) {
            this.created(model.created);
            this.lastUpdated(model.lastUpdated);
            this.sections(model.sections);
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Map<String, Section.Builder> getSections() {
            Map<String, Section.Builder> result = SectionsCopier.copyToBuilder(this.sections);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSections(Map<String, Section.BuilderImpl> sections) {
            this.sections = SectionsCopier.copyFromBuilder(sections);
        }

        @Override
        public final Builder sections(Map<String, Section> sections) {
            this.sections = SectionsCopier.copy(sections);
            return this;
        }

        public GameConfigurationDetails build() {
            return new GameConfigurationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameConfigurationDetails> {
        public Builder created(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder sections(Map<String, Section> var1);
    }
}

