/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentAction {
    DEPLOY("DEPLOY"),
    UNDEPLOY("UNDEPLOY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentAction> VALUE_MAP;
    private final String value;

    private DeploymentAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentAction> knownValues() {
        EnumSet<DeploymentAction> knownValues = EnumSet.allOf(DeploymentAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentAction.class, DeploymentAction::toString);
    }
}

