/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamesparks.model.GameSummary;
import software.amazon.awssdk.services.gamesparks.model.ListGamesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGamesResponse;

public class ListGamesIterable
implements SdkIterable<ListGamesResponse> {
    private final GameSparksClient client;
    private final ListGamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGamesIterable(GameSparksClient client, ListGamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGamesResponseFetcher();
    }

    public Iterator<ListGamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameSummary> games() {
        Function<ListGamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.games() != null) {
                return response.games().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGamesResponseFetcher
    implements SyncPageFetcher<ListGamesResponse> {
        private ListGamesResponseFetcher() {
        }

        public boolean hasNextPage(ListGamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGamesResponse nextPage(ListGamesResponse previousPage) {
            if (previousPage == null) {
                return ListGamesIterable.this.client.listGames(ListGamesIterable.this.firstRequest);
            }
            return ListGamesIterable.this.client.listGames((ListGamesRequest)((Object)ListGamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

