/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Generator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Generator> {
    private static final SdkField<String> GAME_SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSdkVersion").getter(Generator.getter(Generator::gameSdkVersion)).setter(Generator.setter(Builder::gameSdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSdkVersion").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(Generator.getter(Generator::language)).setter(Generator.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> TARGET_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetPlatform").getter(Generator.getter(Generator::targetPlatform)).setter(Generator.setter(Builder::targetPlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPlatform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SDK_VERSION_FIELD, LANGUAGE_FIELD, TARGET_PLATFORM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gameSdkVersion;
    private final String language;
    private final String targetPlatform;

    private Generator(BuilderImpl builder) {
        this.gameSdkVersion = builder.gameSdkVersion;
        this.language = builder.language;
        this.targetPlatform = builder.targetPlatform;
    }

    public final String gameSdkVersion() {
        return this.gameSdkVersion;
    }

    public final String language() {
        return this.language;
    }

    public final String targetPlatform() {
        return this.targetPlatform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPlatform());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Generator)) {
            return false;
        }
        Generator other = (Generator)obj;
        return Objects.equals(this.gameSdkVersion(), other.gameSdkVersion()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.targetPlatform(), other.targetPlatform());
    }

    public final String toString() {
        return ToString.builder((String)"Generator").add("GameSdkVersion", (Object)this.gameSdkVersion()).add("Language", (Object)this.language()).add("TargetPlatform", (Object)this.targetPlatform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSdkVersion": {
                return Optional.ofNullable(clazz.cast(this.gameSdkVersion()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "TargetPlatform": {
                return Optional.ofNullable(clazz.cast(this.targetPlatform()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Generator, T> g) {
        return obj -> g.apply((Generator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSdkVersion;
        private String language;
        private String targetPlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(Generator model) {
            this.gameSdkVersion(model.gameSdkVersion);
            this.language(model.language);
            this.targetPlatform(model.targetPlatform);
        }

        public final String getGameSdkVersion() {
            return this.gameSdkVersion;
        }

        public final void setGameSdkVersion(String gameSdkVersion) {
            this.gameSdkVersion = gameSdkVersion;
        }

        @Override
        public final Builder gameSdkVersion(String gameSdkVersion) {
            this.gameSdkVersion = gameSdkVersion;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getTargetPlatform() {
            return this.targetPlatform;
        }

        public final void setTargetPlatform(String targetPlatform) {
            this.targetPlatform = targetPlatform;
        }

        @Override
        public final Builder targetPlatform(String targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        public Generator build() {
            return new Generator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Generator> {
        public Builder gameSdkVersion(String var1);

        public Builder language(String var1);

        public Builder targetPlatform(String var1);
    }
}

