/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.gamesparks.model.SnapshotSummary;

public class ListSnapshotsPublisher
implements SdkPublisher<ListSnapshotsResponse> {
    private final GameSparksAsyncClient client;
    private final ListSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSnapshotsPublisher(GameSparksAsyncClient client, ListSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSnapshotsPublisher(GameSparksAsyncClient client, ListSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotSummary> snapshots() {
        Function<ListSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSnapshotsResponseFetcher
    implements AsyncPageFetcher<ListSnapshotsResponse> {
        private ListSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSnapshotsResponse> nextPage(ListSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotsPublisher.this.client.listSnapshots(ListSnapshotsPublisher.this.firstRequest);
            }
            return ListSnapshotsPublisher.this.client.listSnapshots((ListSnapshotsRequest)((Object)ListSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

