/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStageDeploymentRequest extends GameSparksRequest implements
        ToCopyableBuilder<StartStageDeploymentRequest.Builder, StartStageDeploymentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartStageDeploymentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> GAME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameName").getter(getter(StartStageDeploymentRequest::gameName)).setter(setter(Builder::gameName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(StartStageDeploymentRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(StartStageDeploymentRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("StageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GAME_NAME_FIELD, SNAPSHOT_ID_FIELD, STAGE_NAME_FIELD));

    private final String clientToken;

    private final String gameName;

    private final String snapshotId;

    private final String stageName;

    private StartStageDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gameName = builder.gameName;
        this.snapshotId = builder.snapshotId;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * A client-defined token. With an active client token in the request, this action is idempotent.
     * </p>
     * 
     * @return A client-defined token. With an active client token in the request, this action is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the game.
     * </p>
     * 
     * @return The name of the game.
     */
    public final String gameName() {
        return gameName;
    }

    /**
     * <p>
     * The identifier of the snapshot to deploy.
     * </p>
     * 
     * @return The identifier of the snapshot to deploy.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The name of the stage to deploy the snapshot onto.
     * </p>
     * 
     * @return The name of the stage to deploy the snapshot onto.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gameName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStageDeploymentRequest)) {
            return false;
        }
        StartStageDeploymentRequest other = (StartStageDeploymentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gameName(), other.gameName())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStageDeploymentRequest").add("ClientToken", clientToken()).add("GameName", gameName())
                .add("SnapshotId", snapshotId()).add("StageName", stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GameName":
            return Optional.ofNullable(clazz.cast(gameName()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStageDeploymentRequest, T> g) {
        return obj -> g.apply((StartStageDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartStageDeploymentRequest> {
        /**
         * <p>
         * A client-defined token. With an active client token in the request, this action is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A client-defined token. With an active client token in the request, this action is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the game.
         * </p>
         * 
         * @param gameName
         *        The name of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameName(String gameName);

        /**
         * <p>
         * The identifier of the snapshot to deploy.
         * </p>
         * 
         * @param snapshotId
         *        The identifier of the snapshot to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The name of the stage to deploy the snapshot onto.
         * </p>
         * 
         * @param stageName
         *        The name of the stage to deploy the snapshot onto.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gameName;

        private String snapshotId;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStageDeploymentRequest model) {
            super(model);
            clientToken(model.clientToken);
            gameName(model.gameName);
            snapshotId(model.snapshotId);
            stageName(model.stageName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGameName() {
            return gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStageDeploymentRequest build() {
            return new StartStageDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
