/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.DeploymentAction;
import software.amazon.awssdk.services.gamesparks.model.DeploymentResult;
import software.amazon.awssdk.services.gamesparks.model.DeploymentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageDeploymentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageDeploymentDetails> {
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(StageDeploymentDetails.getter(StageDeploymentDetails::created)).setter(StageDeploymentDetails.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEPLOYMENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentAction").getter(StageDeploymentDetails.getter(StageDeploymentDetails::deploymentActionAsString)).setter(StageDeploymentDetails.setter(Builder::deploymentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentAction").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(StageDeploymentDetails.getter(StageDeploymentDetails::deploymentId)).setter(StageDeploymentDetails.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<DeploymentResult> DEPLOYMENT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentResult").getter(StageDeploymentDetails.getter(StageDeploymentDetails::deploymentResult)).setter(StageDeploymentDetails.setter(Builder::deploymentResult)).constructor(DeploymentResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentResult").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentState").getter(StageDeploymentDetails.getter(StageDeploymentDetails::deploymentStateAsString)).setter(StageDeploymentDetails.setter(Builder::deploymentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentState").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(StageDeploymentDetails.getter(StageDeploymentDetails::lastUpdated)).setter(StageDeploymentDetails.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(StageDeploymentDetails.getter(StageDeploymentDetails::snapshotId)).setter(StageDeploymentDetails.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, DEPLOYMENT_ACTION_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_RESULT_FIELD, DEPLOYMENT_STATE_FIELD, LAST_UPDATED_FIELD, SNAPSHOT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant created;
    private final String deploymentAction;
    private final String deploymentId;
    private final DeploymentResult deploymentResult;
    private final String deploymentState;
    private final Instant lastUpdated;
    private final String snapshotId;

    private StageDeploymentDetails(BuilderImpl builder) {
        this.created = builder.created;
        this.deploymentAction = builder.deploymentAction;
        this.deploymentId = builder.deploymentId;
        this.deploymentResult = builder.deploymentResult;
        this.deploymentState = builder.deploymentState;
        this.lastUpdated = builder.lastUpdated;
        this.snapshotId = builder.snapshotId;
    }

    public final Instant created() {
        return this.created;
    }

    public final DeploymentAction deploymentAction() {
        return DeploymentAction.fromValue(this.deploymentAction);
    }

    public final String deploymentActionAsString() {
        return this.deploymentAction;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final DeploymentResult deploymentResult() {
        return this.deploymentResult;
    }

    public final DeploymentState deploymentState() {
        return DeploymentState.fromValue(this.deploymentState);
    }

    public final String deploymentStateAsString() {
        return this.deploymentState;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeploymentDetails)) {
            return false;
        }
        StageDeploymentDetails other = (StageDeploymentDetails)obj;
        return Objects.equals(this.created(), other.created()) && Objects.equals(this.deploymentActionAsString(), other.deploymentActionAsString()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentResult(), other.deploymentResult()) && Objects.equals(this.deploymentStateAsString(), other.deploymentStateAsString()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public final String toString() {
        return ToString.builder((String)"StageDeploymentDetails").add("Created", (Object)this.created()).add("DeploymentAction", (Object)this.deploymentActionAsString()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentResult", (Object)this.deploymentResult()).add("DeploymentState", (Object)this.deploymentStateAsString()).add("LastUpdated", (Object)this.lastUpdated()).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "DeploymentAction": {
                return Optional.ofNullable(clazz.cast(this.deploymentActionAsString()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "DeploymentResult": {
                return Optional.ofNullable(clazz.cast(this.deploymentResult()));
            }
            case "DeploymentState": {
                return Optional.ofNullable(clazz.cast(this.deploymentStateAsString()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageDeploymentDetails, T> g) {
        return obj -> g.apply((StageDeploymentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant created;
        private String deploymentAction;
        private String deploymentId;
        private DeploymentResult deploymentResult;
        private String deploymentState;
        private Instant lastUpdated;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeploymentDetails model) {
            this.created(model.created);
            this.deploymentAction(model.deploymentAction);
            this.deploymentId(model.deploymentId);
            this.deploymentResult(model.deploymentResult);
            this.deploymentState(model.deploymentState);
            this.lastUpdated(model.lastUpdated);
            this.snapshotId(model.snapshotId);
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDeploymentAction() {
            return this.deploymentAction;
        }

        public final void setDeploymentAction(String deploymentAction) {
            this.deploymentAction = deploymentAction;
        }

        @Override
        public final Builder deploymentAction(String deploymentAction) {
            this.deploymentAction = deploymentAction;
            return this;
        }

        @Override
        public final Builder deploymentAction(DeploymentAction deploymentAction) {
            this.deploymentAction(deploymentAction == null ? null : deploymentAction.toString());
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final DeploymentResult.Builder getDeploymentResult() {
            return this.deploymentResult != null ? this.deploymentResult.toBuilder() : null;
        }

        public final void setDeploymentResult(DeploymentResult.BuilderImpl deploymentResult) {
            this.deploymentResult = deploymentResult != null ? deploymentResult.build() : null;
        }

        @Override
        public final Builder deploymentResult(DeploymentResult deploymentResult) {
            this.deploymentResult = deploymentResult;
            return this;
        }

        public final String getDeploymentState() {
            return this.deploymentState;
        }

        public final void setDeploymentState(String deploymentState) {
            this.deploymentState = deploymentState;
        }

        @Override
        public final Builder deploymentState(String deploymentState) {
            this.deploymentState = deploymentState;
            return this;
        }

        @Override
        public final Builder deploymentState(DeploymentState deploymentState) {
            this.deploymentState(deploymentState == null ? null : deploymentState.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public StageDeploymentDetails build() {
            return new StageDeploymentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageDeploymentDetails> {
        public Builder created(Instant var1);

        public Builder deploymentAction(String var1);

        public Builder deploymentAction(DeploymentAction var1);

        public Builder deploymentId(String var1);

        public Builder deploymentResult(DeploymentResult var1);

        default public Builder deploymentResult(Consumer<DeploymentResult.Builder> deploymentResult) {
            return this.deploymentResult((DeploymentResult)((DeploymentResult.Builder)DeploymentResult.builder().applyMutation(deploymentResult)).build());
        }

        public Builder deploymentState(String var1);

        public Builder deploymentState(DeploymentState var1);

        public Builder lastUpdated(Instant var1);

        public Builder snapshotId(String var1);
    }
}

