/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fsx.DefaultFSxBaseClientBuilder;
import software.amazon.awssdk.services.fsx.DefaultFSxClient;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.FSxClientBuilder;
import software.amazon.awssdk.services.fsx.FSxServiceClientConfiguration;
import software.amazon.awssdk.services.fsx.endpoints.FSxEndpointProvider;

@SdkInternalApi
final class DefaultFSxClientBuilder
extends DefaultFSxBaseClientBuilder<FSxClientBuilder, FSxClient>
implements FSxClientBuilder {
    DefaultFSxClientBuilder() {
    }

    @Override
    public DefaultFSxClientBuilder endpointProvider(FSxEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FSxClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFSxClientBuilder.validateClientOptions(clientConfiguration);
        FSxServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFSxClient client = new DefaultFSxClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FSxServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FSxServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

