/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and
 * file shares on the Amazon FSx for Windows File Server file system. For more information, see <a
 * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html"> File access auditing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WindowsAuditLogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WindowsAuditLogConfiguration.Builder, WindowsAuditLogConfiguration> {
    private static final SdkField<String> FILE_ACCESS_AUDIT_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileAccessAuditLogLevel").getter(getter(WindowsAuditLogConfiguration::fileAccessAuditLogLevelAsString))
            .setter(setter(Builder::fileAccessAuditLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileAccessAuditLogLevel").build())
            .build();

    private static final SdkField<String> FILE_SHARE_ACCESS_AUDIT_LOG_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FileShareAccessAuditLogLevel")
            .getter(getter(WindowsAuditLogConfiguration::fileShareAccessAuditLogLevelAsString))
            .setter(setter(Builder::fileShareAccessAuditLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareAccessAuditLogLevel")
                    .build()).build();

    private static final SdkField<String> AUDIT_LOG_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditLogDestination").getter(getter(WindowsAuditLogConfiguration::auditLogDestination))
            .setter(setter(Builder::auditLogDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_ACCESS_AUDIT_LOG_LEVEL_FIELD, FILE_SHARE_ACCESS_AUDIT_LOG_LEVEL_FIELD, AUDIT_LOG_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileAccessAuditLogLevel;

    private final String fileShareAccessAuditLogLevel;

    private final String auditLogDestination;

    private WindowsAuditLogConfiguration(BuilderImpl builder) {
        this.fileAccessAuditLogLevel = builder.fileAccessAuditLogLevel;
        this.fileShareAccessAuditLogLevel = builder.fileShareAccessAuditLogLevel;
        this.auditLogDestination = builder.auditLogDestination;
    }

    /**
     * <p>
     * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are
     * logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - access auditing of files and folders is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileAccessAuditLogLevel} will return {@link WindowsAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #fileAccessAuditLogLevelAsString}.
     * </p>
     * 
     * @return Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or
     *         folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - access auditing of files and folders is turned off.
     *         </p>
     *         </li>
     * @see WindowsAccessAuditLogLevel
     */
    public final WindowsAccessAuditLogLevel fileAccessAuditLogLevel() {
        return WindowsAccessAuditLogLevel.fromValue(fileAccessAuditLogLevel);
    }

    /**
     * <p>
     * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are
     * logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - access auditing of files and folders is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileAccessAuditLogLevel} will return {@link WindowsAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #fileAccessAuditLogLevelAsString}.
     * </p>
     * 
     * @return Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or
     *         folders are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - access auditing of files and folders is turned off.
     *         </p>
     *         </li>
     * @see WindowsAccessAuditLogLevel
     */
    public final String fileAccessAuditLogLevelAsString() {
        return fileAccessAuditLogLevel;
    }

    /**
     * <p>
     * Sets which attempt type is logged by Amazon FSx for file share accesses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - access auditing of file shares is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileShareAccessAuditLogLevel} will return {@link WindowsAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #fileShareAccessAuditLogLevelAsString}.
     * </p>
     * 
     * @return Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are
     *         logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - access auditing of file shares is turned off.
     *         </p>
     *         </li>
     * @see WindowsAccessAuditLogLevel
     */
    public final WindowsAccessAuditLogLevel fileShareAccessAuditLogLevel() {
        return WindowsAccessAuditLogLevel.fromValue(fileShareAccessAuditLogLevel);
    }

    /**
     * <p>
     * Sets which attempt type is logged by Amazon FSx for file share accesses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - access auditing of file shares is turned off.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileShareAccessAuditLogLevel} will return {@link WindowsAccessAuditLogLevel#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #fileShareAccessAuditLogLevelAsString}.
     * </p>
     * 
     * @return Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are
     *         logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - access auditing of file shares is turned off.
     *         </p>
     *         </li>
     * @see WindowsAccessAuditLogLevel
     */
    public final String fileShareAccessAuditLogLevelAsString() {
        return fileShareAccessAuditLogLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon
     * CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
     * </p>
     * <p>
     * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of
     * the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
     * </p>
     * <p>
     * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the
     * same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon
     * FSx file system.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon
     *         CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.</p>
     *         <p>
     *         The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The
     *         name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
     *         </p>
     *         <p>
     *         The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be
     *         in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as
     *         your Amazon FSx file system.
     */
    public final String auditLogDestination() {
        return auditLogDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileAccessAuditLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareAccessAuditLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsAuditLogConfiguration)) {
            return false;
        }
        WindowsAuditLogConfiguration other = (WindowsAuditLogConfiguration) obj;
        return Objects.equals(fileAccessAuditLogLevelAsString(), other.fileAccessAuditLogLevelAsString())
                && Objects.equals(fileShareAccessAuditLogLevelAsString(), other.fileShareAccessAuditLogLevelAsString())
                && Objects.equals(auditLogDestination(), other.auditLogDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WindowsAuditLogConfiguration").add("FileAccessAuditLogLevel", fileAccessAuditLogLevelAsString())
                .add("FileShareAccessAuditLogLevel", fileShareAccessAuditLogLevelAsString())
                .add("AuditLogDestination", auditLogDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileAccessAuditLogLevel":
            return Optional.ofNullable(clazz.cast(fileAccessAuditLogLevelAsString()));
        case "FileShareAccessAuditLogLevel":
            return Optional.ofNullable(clazz.cast(fileShareAccessAuditLogLevelAsString()));
        case "AuditLogDestination":
            return Optional.ofNullable(clazz.cast(auditLogDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowsAuditLogConfiguration, T> g) {
        return obj -> g.apply((WindowsAuditLogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WindowsAuditLogConfiguration> {
        /**
         * <p>
         * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders
         * are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - access auditing of files and folders is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileAccessAuditLogLevel
         *        Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or
         *        folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - access auditing of files and folders is turned off.
         *        </p>
         *        </li>
         * @see WindowsAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsAccessAuditLogLevel
         */
        Builder fileAccessAuditLogLevel(String fileAccessAuditLogLevel);

        /**
         * <p>
         * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders
         * are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - access auditing of files and folders is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileAccessAuditLogLevel
         *        Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or
         *        folders are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - access auditing of files and folders is turned off.
         *        </p>
         *        </li>
         * @see WindowsAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsAccessAuditLogLevel
         */
        Builder fileAccessAuditLogLevel(WindowsAccessAuditLogLevel fileAccessAuditLogLevel);

        /**
         * <p>
         * Sets which attempt type is logged by Amazon FSx for file share accesses.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are
         * logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - access auditing of file shares is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileShareAccessAuditLogLevel
         *        Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares
         *        are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - access auditing of file shares is turned off.
         *        </p>
         *        </li>
         * @see WindowsAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsAccessAuditLogLevel
         */
        Builder fileShareAccessAuditLogLevel(String fileShareAccessAuditLogLevel);

        /**
         * <p>
         * Sets which attempt type is logged by Amazon FSx for file share accesses.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are
         * logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - access auditing of file shares is turned off.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileShareAccessAuditLogLevel
         *        Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares
         *        are logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - access auditing of file shares is turned off.
         *        </p>
         *        </li>
         * @see WindowsAccessAuditLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsAccessAuditLogLevel
         */
        Builder fileShareAccessAuditLogLevel(WindowsAccessAuditLogLevel fileShareAccessAuditLogLevel);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon
         * CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
         * </p>
         * <p>
         * The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name
         * of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code> prefix.
         * </p>
         * <p>
         * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in
         * the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your
         * Amazon FSx file system.
         * </p>
         * 
         * @param auditLogDestination
         *        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any
         *        Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.</p>
         *        <p>
         *        The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The
         *        name of the Amazon Kinesis Data Firehose delivery stream must begin with the <code>aws-fsx</code>
         *        prefix.
         *        </p>
         *        <p>
         *        The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must
         *        be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services
         *        account as your Amazon FSx file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogDestination(String auditLogDestination);
    }

    static final class BuilderImpl implements Builder {
        private String fileAccessAuditLogLevel;

        private String fileShareAccessAuditLogLevel;

        private String auditLogDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsAuditLogConfiguration model) {
            fileAccessAuditLogLevel(model.fileAccessAuditLogLevel);
            fileShareAccessAuditLogLevel(model.fileShareAccessAuditLogLevel);
            auditLogDestination(model.auditLogDestination);
        }

        public final String getFileAccessAuditLogLevel() {
            return fileAccessAuditLogLevel;
        }

        public final void setFileAccessAuditLogLevel(String fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
        }

        @Override
        public final Builder fileAccessAuditLogLevel(String fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
            return this;
        }

        @Override
        public final Builder fileAccessAuditLogLevel(WindowsAccessAuditLogLevel fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel(fileAccessAuditLogLevel == null ? null : fileAccessAuditLogLevel.toString());
            return this;
        }

        public final String getFileShareAccessAuditLogLevel() {
            return fileShareAccessAuditLogLevel;
        }

        public final void setFileShareAccessAuditLogLevel(String fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
        }

        @Override
        public final Builder fileShareAccessAuditLogLevel(String fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
            return this;
        }

        @Override
        public final Builder fileShareAccessAuditLogLevel(WindowsAccessAuditLogLevel fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel(fileShareAccessAuditLogLevel == null ? null : fileShareAccessAuditLogLevel
                    .toString());
            return this;
        }

        public final String getAuditLogDestination() {
            return auditLogDestination;
        }

        public final void setAuditLogDestination(String auditLogDestination) {
            this.auditLogDestination = auditLogDestination;
        }

        @Override
        public final Builder auditLogDestination(String auditLogDestination) {
            this.auditLogDestination = auditLogDestination;
            return this;
        }

        @Override
        public WindowsAuditLogConfiguration build() {
            return new WindowsAuditLogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
