/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use to specify skipping a final backup, adding tags to a final backup, or bypassing the retention period of an FSx
 * for ONTAP SnapLock Enterprise volume when deleting an FSx for ONTAP volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVolumeOntapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteVolumeOntapConfiguration.Builder, DeleteVolumeOntapConfiguration> {
    private static final SdkField<Boolean> SKIP_FINAL_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalBackup").getter(getter(DeleteVolumeOntapConfiguration::skipFinalBackup))
            .setter(setter(Builder::skipFinalBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalBackup").build()).build();

    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("FinalBackupTags")
            .getter(getter(DeleteVolumeOntapConfiguration::finalBackupTags))
            .setter(setter(Builder::finalBackupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> BYPASS_SNAPLOCK_ENTERPRISE_RETENTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BypassSnaplockEnterpriseRetention")
            .getter(getter(DeleteVolumeOntapConfiguration::bypassSnaplockEnterpriseRetention))
            .setter(setter(Builder::bypassSnaplockEnterpriseRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassSnaplockEnterpriseRetention")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_FINAL_BACKUP_FIELD,
            FINAL_BACKUP_TAGS_FIELD, BYPASS_SNAPLOCK_ENTERPRISE_RETENTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean skipFinalBackup;

    private final List<Tag> finalBackupTags;

    private final Boolean bypassSnaplockEnterpriseRetention;

    private DeleteVolumeOntapConfiguration(BuilderImpl builder) {
        this.skipFinalBackup = builder.skipFinalBackup;
        this.finalBackupTags = builder.finalBackupTags;
        this.bypassSnaplockEnterpriseRetention = builder.bypassSnaplockEnterpriseRetention;
    }

    /**
     * <p>
     * Set to true if you want to skip taking a final backup of the volume you are deleting.
     * </p>
     * 
     * @return Set to true if you want to skip taking a final backup of the volume you are deleting.
     */
    public final Boolean skipFinalBackup() {
        return skipFinalBackup;
    }

    /**
     * For responses, this returns true if the service returned a value for the FinalBackupTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFinalBackupTags() {
        return finalBackupTags != null && !(finalBackupTags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the FinalBackupTags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFinalBackupTags} method.
     * </p>
     * 
     * @return The value of the FinalBackupTags property for this object.
     */
    public final List<Tag> finalBackupTags() {
        return finalBackupTags;
    }

    /**
     * <p>
     * Setting this to <code>true</code> allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise
     * volume with unexpired write once, read many (WORM) files. The IAM permission
     * <code>fsx:BypassSnaplockEnterpriseRetention</code> is also required to delete SnapLock Enterprise volumes with
     * unexpired WORM files. The default value is <code>false</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html"> Deleting a SnapLock
     * volume</a>.
     * </p>
     * 
     * @return Setting this to <code>true</code> allows a SnapLock administrator to delete an FSx for ONTAP SnapLock
     *         Enterprise volume with unexpired write once, read many (WORM) files. The IAM permission
     *         <code>fsx:BypassSnaplockEnterpriseRetention</code> is also required to delete SnapLock Enterprise volumes
     *         with unexpired WORM files. The default value is <code>false</code>. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html"> Deleting a SnapLock
     *         volume</a>.
     */
    public final Boolean bypassSnaplockEnterpriseRetention() {
        return bypassSnaplockEnterpriseRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalBackup());
        hashCode = 31 * hashCode + Objects.hashCode(hasFinalBackupTags() ? finalBackupTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bypassSnaplockEnterpriseRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeOntapConfiguration)) {
            return false;
        }
        DeleteVolumeOntapConfiguration other = (DeleteVolumeOntapConfiguration) obj;
        return Objects.equals(skipFinalBackup(), other.skipFinalBackup()) && hasFinalBackupTags() == other.hasFinalBackupTags()
                && Objects.equals(finalBackupTags(), other.finalBackupTags())
                && Objects.equals(bypassSnaplockEnterpriseRetention(), other.bypassSnaplockEnterpriseRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVolumeOntapConfiguration").add("SkipFinalBackup", skipFinalBackup())
                .add("FinalBackupTags", hasFinalBackupTags() ? finalBackupTags() : null)
                .add("BypassSnaplockEnterpriseRetention", bypassSnaplockEnterpriseRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkipFinalBackup":
            return Optional.ofNullable(clazz.cast(skipFinalBackup()));
        case "FinalBackupTags":
            return Optional.ofNullable(clazz.cast(finalBackupTags()));
        case "BypassSnaplockEnterpriseRetention":
            return Optional.ofNullable(clazz.cast(bypassSnaplockEnterpriseRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeOntapConfiguration, T> g) {
        return obj -> g.apply((DeleteVolumeOntapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteVolumeOntapConfiguration> {
        /**
         * <p>
         * Set to true if you want to skip taking a final backup of the volume you are deleting.
         * </p>
         * 
         * @param skipFinalBackup
         *        Set to true if you want to skip taking a final backup of the volume you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalBackup(Boolean skipFinalBackup);

        /**
         * Sets the value of the FinalBackupTags property for this object.
         *
         * @param finalBackupTags
         *        The new value for the FinalBackupTags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Collection<Tag> finalBackupTags);

        /**
         * Sets the value of the FinalBackupTags property for this object.
         *
         * @param finalBackupTags
         *        The new value for the FinalBackupTags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Tag... finalBackupTags);

        /**
         * Sets the value of the FinalBackupTags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #finalBackupTags(List<Tag>)}.
         * 
         * @param finalBackupTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalBackupTags(java.util.Collection<Tag>)
         */
        Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags);

        /**
         * <p>
         * Setting this to <code>true</code> allows a SnapLock administrator to delete an FSx for ONTAP SnapLock
         * Enterprise volume with unexpired write once, read many (WORM) files. The IAM permission
         * <code>fsx:BypassSnaplockEnterpriseRetention</code> is also required to delete SnapLock Enterprise volumes
         * with unexpired WORM files. The default value is <code>false</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html"> Deleting a SnapLock
         * volume</a>.
         * </p>
         * 
         * @param bypassSnaplockEnterpriseRetention
         *        Setting this to <code>true</code> allows a SnapLock administrator to delete an FSx for ONTAP SnapLock
         *        Enterprise volume with unexpired write once, read many (WORM) files. The IAM permission
         *        <code>fsx:BypassSnaplockEnterpriseRetention</code> is also required to delete SnapLock Enterprise
         *        volumes with unexpired WORM files. The default value is <code>false</code>. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html"> Deleting a
         *        SnapLock volume</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassSnaplockEnterpriseRetention(Boolean bypassSnaplockEnterpriseRetention);
    }

    static final class BuilderImpl implements Builder {
        private Boolean skipFinalBackup;

        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private Boolean bypassSnaplockEnterpriseRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeOntapConfiguration model) {
            skipFinalBackup(model.skipFinalBackup);
            finalBackupTags(model.finalBackupTags);
            bypassSnaplockEnterpriseRetention(model.bypassSnaplockEnterpriseRetention);
        }

        public final Boolean getSkipFinalBackup() {
            return skipFinalBackup;
        }

        public final void setSkipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
        }

        @Override
        public final Builder skipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
            return this;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Tag... finalBackupTags) {
            finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags) {
            finalBackupTags(Stream.of(finalBackupTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getBypassSnaplockEnterpriseRetention() {
            return bypassSnaplockEnterpriseRetention;
        }

        public final void setBypassSnaplockEnterpriseRetention(Boolean bypassSnaplockEnterpriseRetention) {
            this.bypassSnaplockEnterpriseRetention = bypassSnaplockEnterpriseRetention;
        }

        @Override
        public final Builder bypassSnaplockEnterpriseRetention(Boolean bypassSnaplockEnterpriseRetention) {
            this.bypassSnaplockEnterpriseRetention = bypassSnaplockEnterpriseRetention;
            return this;
        }

        @Override
        public DeleteVolumeOntapConfiguration build() {
            return new DeleteVolumeOntapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
