/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The system generated response showing the DNS aliases that Amazon FSx is attempting to associate with the file
 * system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system. It
 * can take up to 2.5 minutes for the alias status to change from <code>CREATING</code> to <code>AVAILABLE</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFileSystemAliasesResponse extends FSxResponse implements
        ToCopyableBuilder<AssociateFileSystemAliasesResponse.Builder, AssociateFileSystemAliasesResponse> {
    private static final SdkField<List<Alias>> ALIASES_FIELD = SdkField
            .<List<Alias>> builder(MarshallingType.LIST)
            .memberName("Aliases")
            .getter(getter(AssociateFileSystemAliasesResponse::aliases))
            .setter(setter(Builder::aliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Alias> builder(MarshallingType.SDK_POJO)
                                            .constructor(Alias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIASES_FIELD));

    private final List<Alias> aliases;

    private AssociateFileSystemAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.aliases = builder.aliases;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aliases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAliases() {
        return aliases != null && !(aliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the DNS aliases that Amazon FSx is associating with the file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliases} method.
     * </p>
     * 
     * @return An array of the DNS aliases that Amazon FSx is associating with the file system.
     */
    public final List<Alias> aliases() {
        return aliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAliases() ? aliases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFileSystemAliasesResponse)) {
            return false;
        }
        AssociateFileSystemAliasesResponse other = (AssociateFileSystemAliasesResponse) obj;
        return hasAliases() == other.hasAliases() && Objects.equals(aliases(), other.aliases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFileSystemAliasesResponse").add("Aliases", hasAliases() ? aliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFileSystemAliasesResponse, T> g) {
        return obj -> g.apply((AssociateFileSystemAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateFileSystemAliasesResponse> {
        /**
         * <p>
         * An array of the DNS aliases that Amazon FSx is associating with the file system.
         * </p>
         * 
         * @param aliases
         *        An array of the DNS aliases that Amazon FSx is associating with the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Collection<Alias> aliases);

        /**
         * <p>
         * An array of the DNS aliases that Amazon FSx is associating with the file system.
         * </p>
         * 
         * @param aliases
         *        An array of the DNS aliases that Amazon FSx is associating with the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Alias... aliases);

        /**
         * <p>
         * An array of the DNS aliases that Amazon FSx is associating with the file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Alias.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Alias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Alias.Builder#build()}
         * is called immediately and its result is passed to {@link #aliases(List<Alias>)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Alias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(java.util.Collection<Alias>)
         */
        Builder aliases(Consumer<Alias.Builder>... aliases);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private List<Alias> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFileSystemAliasesResponse model) {
            super(model);
            aliases(model.aliases);
        }

        public final List<Alias.Builder> getAliases() {
            List<Alias.Builder> result = AliasesCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasesCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias... aliases) {
            aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<Alias.Builder>... aliases) {
            aliases(Stream.of(aliases).map(c -> Alias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociateFileSystemAliasesResponse build() {
            return new AssociateFileSystemAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
