/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateForecastRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateForecastRequest.Builder, CreateForecastRequest> {
    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastName").getter(getter(CreateForecastRequest::forecastName)).setter(setter(Builder::forecastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(CreateForecastRequest::predictorArn)).setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(CreateForecastRequest::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateForecastRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeSeriesSelector> TIME_SERIES_SELECTOR_FIELD = SdkField
            .<TimeSeriesSelector> builder(MarshallingType.SDK_POJO).memberName("TimeSeriesSelector")
            .getter(getter(CreateForecastRequest::timeSeriesSelector)).setter(setter(Builder::timeSeriesSelector))
            .constructor(TimeSeriesSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSelector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_NAME_FIELD,
            PREDICTOR_ARN_FIELD, FORECAST_TYPES_FIELD, TAGS_FIELD, TIME_SERIES_SELECTOR_FIELD));

    private final String forecastName;

    private final String predictorArn;

    private final List<String> forecastTypes;

    private final List<Tag> tags;

    private final TimeSeriesSelector timeSeriesSelector;

    private CreateForecastRequest(BuilderImpl builder) {
        super(builder);
        this.forecastName = builder.forecastName;
        this.predictorArn = builder.predictorArn;
        this.forecastTypes = builder.forecastTypes;
        this.tags = builder.tags;
        this.timeSeriesSelector = builder.timeSeriesSelector;
    }

    /**
     * <p>
     * A name for the forecast.
     * </p>
     * 
     * @return A name for the forecast.
     */
    public final String forecastName() {
        return forecastName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5 quantiles per
     * forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only) and <code>mean</code>.
     * The mean forecast is different from the median (0.50) when the distribution is not symmetric (for example, Beta
     * and Negative Binomial).
     * </p>
     * <p>
     * The default quantiles are the quantiles you specified during predictor creation. If you didn't specify quantiles,
     * the default values are <code>["0.1", "0.5", "0.9"]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5
     *         quantiles per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only)
     *         and <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is not
     *         symmetric (for example, Beta and Negative Binomial). </p>
     *         <p>
     *         The default quantiles are the quantiles you specified during predictor creation. If you didn't specify
     *         quantiles, the default values are <code>["0.1", "0.5", "0.9"]</code>.
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values
     * can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast
     * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
     * <code>aws</code> do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with
     *         this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key
     *         does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags
     *         with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Defines the set of time series that are used to create the forecasts in a <code>TimeSeriesIdentifiers</code>
     * object.
     * </p>
     * <p>
     * The <code>TimeSeriesIdentifiers</code> object needs the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Format</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the set of time series that are used to create the forecasts in a
     *         <code>TimeSeriesIdentifiers</code> object.</p>
     *         <p>
     *         The <code>TimeSeriesIdentifiers</code> object needs the following information:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DataSource</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Format</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Schema</code>
     *         </p>
     *         </li>
     */
    public final TimeSeriesSelector timeSeriesSelector() {
        return timeSeriesSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastRequest)) {
            return false;
        }
        CreateForecastRequest other = (CreateForecastRequest) obj;
        return Objects.equals(forecastName(), other.forecastName()) && Objects.equals(predictorArn(), other.predictorArn())
                && hasForecastTypes() == other.hasForecastTypes() && Objects.equals(forecastTypes(), other.forecastTypes())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(timeSeriesSelector(), other.timeSeriesSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateForecastRequest").add("ForecastName", forecastName()).add("PredictorArn", predictorArn())
                .add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null).add("Tags", hasTags() ? tags() : null)
                .add("TimeSeriesSelector", timeSeriesSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastName":
            return Optional.ofNullable(clazz.cast(forecastName()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TimeSeriesSelector":
            return Optional.ofNullable(clazz.cast(timeSeriesSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastRequest, T> g) {
        return obj -> g.apply((CreateForecastRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateForecastRequest> {
        /**
         * <p>
         * A name for the forecast.
         * </p>
         * 
         * @param forecastName
         *        A name for the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastName(String forecastName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5 quantiles
         * per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only) and
         * <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is not
         * symmetric (for example, Beta and Negative Binomial).
         * </p>
         * <p>
         * The default quantiles are the quantiles you specified during predictor creation. If you didn't specify
         * quantiles, the default values are <code>["0.1", "0.5", "0.9"]</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5
         *        quantiles per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only)
         *        and <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is
         *        not symmetric (for example, Beta and Negative Binomial). </p>
         *        <p>
         *        The default quantiles are the quantiles you specified during predictor creation. If you didn't specify
         *        quantiles, the default values are <code>["0.1", "0.5", "0.9"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5 quantiles
         * per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only) and
         * <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is not
         * symmetric (for example, Beta and Negative Binomial).
         * </p>
         * <p>
         * The default quantiles are the quantiles you specified during predictor creation. If you didn't specify
         * quantiles, the default values are <code>["0.1", "0.5", "0.9"]</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5
         *        quantiles per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only)
         *        and <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is
         *        not symmetric (for example, Beta and Negative Binomial). </p>
         *        <p>
         *        The default quantiles are the quantiles you specified during predictor creation. If you didn't specify
         *        quantiles, the default values are <code>["0.1", "0.5", "0.9"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);

        /**
         * <p>
         * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then
         * Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key
         * prefix of <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the forecast to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with
         *        this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the
         *        key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then
         * Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key
         * prefix of <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the forecast to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with
         *        this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the
         *        key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then
         * Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key
         * prefix of <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.forecast.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Defines the set of time series that are used to create the forecasts in a <code>TimeSeriesIdentifiers</code>
         * object.
         * </p>
         * <p>
         * The <code>TimeSeriesIdentifiers</code> object needs the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Format</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Schema</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param timeSeriesSelector
         *        Defines the set of time series that are used to create the forecasts in a
         *        <code>TimeSeriesIdentifiers</code> object.</p>
         *        <p>
         *        The <code>TimeSeriesIdentifiers</code> object needs the following information:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Format</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Schema</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector);

        /**
         * <p>
         * Defines the set of time series that are used to create the forecasts in a <code>TimeSeriesIdentifiers</code>
         * object.
         * </p>
         * <p>
         * The <code>TimeSeriesIdentifiers</code> object needs the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Format</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Schema</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link TimeSeriesSelector.Builder} avoiding the
         * need to create one manually via {@link TimeSeriesSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #timeSeriesSelector(TimeSeriesSelector)}.
         * 
         * @param timeSeriesSelector
         *        a consumer that will call methods on {@link TimeSeriesSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesSelector(TimeSeriesSelector)
         */
        default Builder timeSeriesSelector(Consumer<TimeSeriesSelector.Builder> timeSeriesSelector) {
            return timeSeriesSelector(TimeSeriesSelector.builder().applyMutation(timeSeriesSelector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String forecastName;

        private String predictorArn;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private TimeSeriesSelector timeSeriesSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastRequest model) {
            super(model);
            forecastName(model.forecastName);
            predictorArn(model.predictorArn);
            forecastTypes(model.forecastTypes);
            tags(model.tags);
            timeSeriesSelector(model.timeSeriesSelector);
        }

        public final String getForecastName() {
            return forecastName;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeSeriesSelector.Builder getTimeSeriesSelector() {
            return timeSeriesSelector != null ? timeSeriesSelector.toBuilder() : null;
        }

        public final void setTimeSeriesSelector(TimeSeriesSelector.BuilderImpl timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector != null ? timeSeriesSelector.build() : null;
        }

        @Override
        public final Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateForecastRequest build() {
            return new CreateForecastRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
