/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.model.AppsListDataSummary;
import software.amazon.awssdk.services.fms.model.ListAppsListsRequest;
import software.amazon.awssdk.services.fms.model.ListAppsListsResponse;

public class ListAppsListsIterable
implements SdkIterable<ListAppsListsResponse> {
    private final FmsClient client;
    private final ListAppsListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppsListsIterable(FmsClient client, ListAppsListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppsListsResponseFetcher();
    }

    public Iterator<ListAppsListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AppsListDataSummary> appsLists() {
        Function<ListAppsListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appsLists() != null) {
                return response.appsLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppsListsResponseFetcher
    implements SyncPageFetcher<ListAppsListsResponse> {
        private ListAppsListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppsListsResponse nextPage(ListAppsListsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsListsIterable.this.client.listAppsLists(ListAppsListsIterable.this.firstRequest);
            }
            return ListAppsListsIterable.this.client.listAppsLists((ListAppsListsRequest)((Object)ListAppsListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

