/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetType {
    GATEWAY("GATEWAY"),
    CARRIER_GATEWAY("CARRIER_GATEWAY"),
    INSTANCE("INSTANCE"),
    LOCAL_GATEWAY("LOCAL_GATEWAY"),
    NAT_GATEWAY("NAT_GATEWAY"),
    NETWORK_INTERFACE("NETWORK_INTERFACE"),
    VPC_ENDPOINT("VPC_ENDPOINT"),
    VPC_PEERING_CONNECTION("VPC_PEERING_CONNECTION"),
    EGRESS_ONLY_INTERNET_GATEWAY("EGRESS_ONLY_INTERNET_GATEWAY"),
    TRANSIT_GATEWAY("TRANSIT_GATEWAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetType> VALUE_MAP;
    private final String value;

    private TargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetType> knownValues() {
        EnumSet<TargetType> knownValues = EnumSet.allOf(TargetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetType.class, TargetType::toString);
    }
}

