/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAdminScopeResponse extends FmsResponse implements
        ToCopyableBuilder<GetAdminScopeResponse.Builder, GetAdminScopeResponse> {
    private static final SdkField<AdminScope> ADMIN_SCOPE_FIELD = SdkField.<AdminScope> builder(MarshallingType.SDK_POJO)
            .memberName("AdminScope").getter(getter(GetAdminScopeResponse::adminScope)).setter(setter(Builder::adminScope))
            .constructor(AdminScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminScope").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetAdminScopeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_SCOPE_FIELD,
            STATUS_FIELD));

    private final AdminScope adminScope;

    private final String status;

    private GetAdminScopeResponse(BuilderImpl builder) {
        super(builder);
        this.adminScope = builder.adminScope;
        this.status = builder.status;
    }

    /**
     * <p>
     * Contains details about the administrative scope of the requested account.
     * </p>
     * 
     * @return Contains details about the administrative scope of the requested account.
     */
    public final AdminScope adminScope() {
        return adminScope;
    }

    /**
     * <p>
     * The current status of the request to onboard a member account as an Firewall Manager administator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request to onboard a member account as an Firewall Manager administator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     *         administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     * @see OrganizationStatus
     */
    public final OrganizationStatus status() {
        return OrganizationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the request to onboard a member account as an Firewall Manager administator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request to onboard a member account as an Firewall Manager administator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     *         administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     * @see OrganizationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminScope());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdminScopeResponse)) {
            return false;
        }
        GetAdminScopeResponse other = (GetAdminScopeResponse) obj;
        return Objects.equals(adminScope(), other.adminScope()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAdminScopeResponse").add("AdminScope", adminScope()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminScope":
            return Optional.ofNullable(clazz.cast(adminScope()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAdminScopeResponse, T> g) {
        return obj -> g.apply((GetAdminScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAdminScopeResponse> {
        /**
         * <p>
         * Contains details about the administrative scope of the requested account.
         * </p>
         * 
         * @param adminScope
         *        Contains details about the administrative scope of the requested account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminScope(AdminScope adminScope);

        /**
         * <p>
         * Contains details about the administrative scope of the requested account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdminScope.Builder} avoiding the need to
         * create one manually via {@link AdminScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdminScope.Builder#build()} is called immediately and its result
         * is passed to {@link #adminScope(AdminScope)}.
         * 
         * @param adminScope
         *        a consumer that will call methods on {@link AdminScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminScope(AdminScope)
         */
        default Builder adminScope(Consumer<AdminScope.Builder> adminScope) {
            return adminScope(AdminScope.builder().applyMutation(adminScope).build());
        }

        /**
         * <p>
         * The current status of the request to onboard a member account as an Firewall Manager administator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the request to onboard a member account as an Firewall Manager administator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         *        administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         * @see OrganizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the request to onboard a member account as an Firewall Manager administator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the request to onboard a member account as an Firewall Manager administator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         *        administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         * @see OrganizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationStatus
         */
        Builder status(OrganizationStatus status);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private AdminScope adminScope;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdminScopeResponse model) {
            super(model);
            adminScope(model.adminScope);
            status(model.status);
        }

        public final AdminScope.Builder getAdminScope() {
            return adminScope != null ? adminScope.toBuilder() : null;
        }

        public final void setAdminScope(AdminScope.BuilderImpl adminScope) {
            this.adminScope = adminScope != null ? adminScope.build() : null;
        }

        @Override
        public final Builder adminScope(AdminScope adminScope) {
            this.adminScope = adminScope;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAdminScopeResponse build() {
            return new GetAdminScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
