/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTargetResourceTypeResponse extends FisResponse implements
        ToCopyableBuilder<GetTargetResourceTypeResponse.Builder, GetTargetResourceTypeResponse> {
    private static final SdkField<TargetResourceType> TARGET_RESOURCE_TYPE_FIELD = SdkField
            .<TargetResourceType> builder(MarshallingType.SDK_POJO).memberName("targetResourceType")
            .getter(getter(GetTargetResourceTypeResponse::targetResourceType)).setter(setter(Builder::targetResourceType))
            .constructor(TargetResourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_TYPE_FIELD));

    private final TargetResourceType targetResourceType;

    private GetTargetResourceTypeResponse(BuilderImpl builder) {
        super(builder);
        this.targetResourceType = builder.targetResourceType;
    }

    /**
     * <p>
     * Information about the resource type.
     * </p>
     * 
     * @return Information about the resource type.
     */
    public final TargetResourceType targetResourceType() {
        return targetResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTargetResourceTypeResponse)) {
            return false;
        }
        GetTargetResourceTypeResponse other = (GetTargetResourceTypeResponse) obj;
        return Objects.equals(targetResourceType(), other.targetResourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTargetResourceTypeResponse").add("TargetResourceType", targetResourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetResourceType":
            return Optional.ofNullable(clazz.cast(targetResourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTargetResourceTypeResponse, T> g) {
        return obj -> g.apply((GetTargetResourceTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTargetResourceTypeResponse> {
        /**
         * <p>
         * Information about the resource type.
         * </p>
         * 
         * @param targetResourceType
         *        Information about the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceType(TargetResourceType targetResourceType);

        /**
         * <p>
         * Information about the resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetResourceType.Builder} avoiding the
         * need to create one manually via {@link TargetResourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResourceType.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResourceType(TargetResourceType)}.
         * 
         * @param targetResourceType
         *        a consumer that will call methods on {@link TargetResourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceType(TargetResourceType)
         */
        default Builder targetResourceType(Consumer<TargetResourceType.Builder> targetResourceType) {
            return targetResourceType(TargetResourceType.builder().applyMutation(targetResourceType).build());
        }
    }

    static final class BuilderImpl extends FisResponse.BuilderImpl implements Builder {
        private TargetResourceType targetResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTargetResourceTypeResponse model) {
            super(model);
            targetResourceType(model.targetResourceType);
        }

        public final TargetResourceType.Builder getTargetResourceType() {
            return targetResourceType != null ? targetResourceType.toBuilder() : null;
        }

        public final void setTargetResourceType(TargetResourceType.BuilderImpl targetResourceType) {
            this.targetResourceType = targetResourceType != null ? targetResourceType.build() : null;
        }

        @Override
        public final Builder targetResourceType(TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public GetTargetResourceTypeResponse build() {
            return new GetTargetResourceTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
