/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.CreateExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.DeleteExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.DeleteExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.GetActionRequest;
import software.amazon.awssdk.services.fis.model.GetActionResponse;
import software.amazon.awssdk.services.fis.model.GetExperimentRequest;
import software.amazon.awssdk.services.fis.model.GetExperimentResponse;
import software.amazon.awssdk.services.fis.model.GetExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.GetExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.model.GetTargetResourceTypeRequest;
import software.amazon.awssdk.services.fis.model.GetTargetResourceTypeResponse;
import software.amazon.awssdk.services.fis.model.ListActionsRequest;
import software.amazon.awssdk.services.fis.model.ListActionsResponse;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse;
import software.amazon.awssdk.services.fis.model.ListExperimentsRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentsResponse;
import software.amazon.awssdk.services.fis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse;
import software.amazon.awssdk.services.fis.model.StartExperimentRequest;
import software.amazon.awssdk.services.fis.model.StartExperimentResponse;
import software.amazon.awssdk.services.fis.model.StopExperimentRequest;
import software.amazon.awssdk.services.fis.model.StopExperimentResponse;
import software.amazon.awssdk.services.fis.model.TagResourceRequest;
import software.amazon.awssdk.services.fis.model.TagResourceResponse;
import software.amazon.awssdk.services.fis.model.UntagResourceRequest;
import software.amazon.awssdk.services.fis.model.UntagResourceResponse;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateRequest;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateResponse;
import software.amazon.awssdk.services.fis.paginators.ListActionsPublisher;
import software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesPublisher;
import software.amazon.awssdk.services.fis.paginators.ListExperimentsPublisher;
import software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesPublisher;

/**
 * Service client for accessing FIS asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Fault Injection Simulator is a managed service that enables you to perform fault injection experiments on your Amazon
 * Web Services workloads. For more information, see the <a
 * href="https://docs.aws.amazon.com/fis/latest/userguide/">Fault Injection Simulator User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FisAsyncClient extends AwsClient {
    String SERVICE_NAME = "fis";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "fis";

    /**
     * <p>
     * Creates an experiment template.
     * </p>
     * <p>
     * An experiment template includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more
     * resources that match criteria that you specify, for example, resources that have specific tags.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each
     * action, and when to start each action during an experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is
     * automatically stopped. You can define a stop condition as a CloudWatch alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the
     * <i>Fault Injection Simulator User Guide</i>.
     * </p>
     *
     * @param createExperimentTemplateRequest
     * @return A Java Future containing the result of the CreateExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ConflictException The request could not be processed because of a conflict.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.CreateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExperimentTemplateResponse> createExperimentTemplate(
            CreateExperimentTemplateRequest createExperimentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an experiment template.
     * </p>
     * <p>
     * An experiment template includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more
     * resources that match criteria that you specify, for example, resources that have specific tags.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each
     * action, and when to start each action during an experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is
     * automatically stopped. You can define a stop condition as a CloudWatch alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the
     * <i>Fault Injection Simulator User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param createExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.CreateExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ConflictException The request could not be processed because of a conflict.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.CreateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExperimentTemplateResponse> createExperimentTemplate(
            Consumer<CreateExperimentTemplateRequest.Builder> createExperimentTemplateRequest) {
        return createExperimentTemplate(CreateExperimentTemplateRequest.builder().applyMutation(createExperimentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified experiment template.
     * </p>
     *
     * @param deleteExperimentTemplateRequest
     * @return A Java Future containing the result of the DeleteExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.DeleteExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExperimentTemplateResponse> deleteExperimentTemplate(
            DeleteExperimentTemplateRequest deleteExperimentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param deleteExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.DeleteExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.DeleteExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExperimentTemplateResponse> deleteExperimentTemplate(
            Consumer<DeleteExperimentTemplateRequest.Builder> deleteExperimentTemplateRequest) {
        return deleteExperimentTemplate(DeleteExperimentTemplateRequest.builder().applyMutation(deleteExperimentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified FIS action.
     * </p>
     *
     * @param getActionRequest
     * @return A Java Future containing the result of the GetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActionResponse> getAction(GetActionRequest getActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified FIS action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActionRequest.Builder} avoiding the need to
     * create one manually via {@link GetActionRequest#builder()}
     * </p>
     *
     * @param getActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.GetActionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetActionResponse> getAction(Consumer<GetActionRequest.Builder> getActionRequest) {
        return getAction(GetActionRequest.builder().applyMutation(getActionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified experiment.
     * </p>
     *
     * @param getExperimentRequest
     * @return A Java Future containing the result of the GetExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExperimentResponse> getExperiment(GetExperimentRequest getExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link GetExperimentRequest#builder()}
     * </p>
     *
     * @param getExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.GetExperimentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExperimentResponse> getExperiment(Consumer<GetExperimentRequest.Builder> getExperimentRequest) {
        return getExperiment(GetExperimentRequest.builder().applyMutation(getExperimentRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified experiment template.
     * </p>
     *
     * @param getExperimentTemplateRequest
     * @return A Java Future containing the result of the GetExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExperimentTemplateResponse> getExperimentTemplate(
            GetExperimentTemplateRequest getExperimentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param getExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.GetExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExperimentTemplateResponse> getExperimentTemplate(
            Consumer<GetExperimentTemplateRequest.Builder> getExperimentTemplateRequest) {
        return getExperimentTemplate(GetExperimentTemplateRequest.builder().applyMutation(getExperimentTemplateRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified resource type.
     * </p>
     *
     * @param getTargetResourceTypeRequest
     * @return A Java Future containing the result of the GetTargetResourceType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetTargetResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTargetResourceTypeResponse> getTargetResourceType(
            GetTargetResourceTypeRequest getTargetResourceTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTargetResourceTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetTargetResourceTypeRequest#builder()}
     * </p>
     *
     * @param getTargetResourceTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.GetTargetResourceTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTargetResourceType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.GetTargetResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetTargetResourceType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTargetResourceTypeResponse> getTargetResourceType(
            Consumer<GetTargetResourceTypeRequest.Builder> getTargetResourceTypeRequest) {
        return getTargetResourceType(GetTargetResourceTypeRequest.builder().applyMutation(getTargetResourceTypeRequest).build());
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     *
     * @param listActionsRequest
     * @return A Java Future containing the result of the ListActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActionsResponse> listActions(ListActionsRequest listActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListActionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActionsResponse> listActions(Consumer<ListActionsRequest.Builder> listActionsRequest) {
        return listActions(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsPublisher listActionsPaginator(ListActionsRequest listActionsRequest) {
        return new ListActionsPublisher(this, listActionsRequest);
    }

    /**
     * <p>
     * Lists the available FIS actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.fis.model.ListActionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListActionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsPublisher listActionsPaginator(Consumer<ListActionsRequest.Builder> listActionsRequest) {
        return listActionsPaginator(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     *
     * @param listExperimentTemplatesRequest
     * @return A Java Future containing the result of the ListExperimentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExperimentTemplatesResponse> listExperimentTemplates(
            ListExperimentTemplatesRequest listExperimentTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListExperimentTemplatesRequest#builder()}
     * </p>
     *
     * @param listExperimentTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListExperimentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExperimentTemplatesResponse> listExperimentTemplates(
            Consumer<ListExperimentTemplatesRequest.Builder> listExperimentTemplatesRequest) {
        return listExperimentTemplates(ListExperimentTemplatesRequest.builder().applyMutation(listExperimentTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesPublisher publisher = client.listExperimentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesPublisher publisher = client.listExperimentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExperimentTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesPublisher listExperimentTemplatesPaginator(
            ListExperimentTemplatesRequest listExperimentTemplatesRequest) {
        return new ListExperimentTemplatesPublisher(this, listExperimentTemplatesRequest);
    }

    /**
     * <p>
     * Lists your experiment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesPublisher publisher = client.listExperimentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentTemplatesPublisher publisher = client.listExperimentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperimentTemplates(software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListExperimentTemplatesRequest#builder()}
     * </p>
     *
     * @param listExperimentTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperimentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperimentTemplatesPublisher listExperimentTemplatesPaginator(
            Consumer<ListExperimentTemplatesRequest.Builder> listExperimentTemplatesRequest) {
        return listExperimentTemplatesPaginator(ListExperimentTemplatesRequest.builder()
                .applyMutation(listExperimentTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     *
     * @param listExperimentsRequest
     * @return A Java Future containing the result of the ListExperiments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExperimentsResponse> listExperiments(ListExperimentsRequest listExperimentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListExperimentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExperiments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExperimentsResponse> listExperiments(
            Consumer<ListExperimentsRequest.Builder> listExperimentsRequest) {
        return listExperiments(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListExperimentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListExperimentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)} operation.</b>
     * </p>
     *
     * @param listExperimentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsPublisher listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest) {
        return new ListExperimentsPublisher(this, listExperimentsRequest);
    }

    /**
     * <p>
     * Lists your experiments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListExperimentsPublisher publisher = client.listExperimentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListExperimentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListExperimentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.fis.model.ListExperimentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListExperimentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsPublisher listExperimentsPaginator(Consumer<ListExperimentsRequest.Builder> listExperimentsRequest) {
        return listExperimentsPaginator(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     *
     * @param listTargetResourceTypesRequest
     * @return A Java Future containing the result of the ListTargetResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetResourceTypesResponse> listTargetResourceTypes(
            ListTargetResourceTypesRequest listTargetResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTargetResourceTypesRequest#builder()}
     * </p>
     *
     * @param listTargetResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTargetResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetResourceTypesResponse> listTargetResourceTypes(
            Consumer<ListTargetResourceTypesRequest.Builder> listTargetResourceTypesRequest) {
        return listTargetResourceTypes(ListTargetResourceTypesRequest.builder().applyMutation(listTargetResourceTypesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesPublisher publisher = client.listTargetResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesPublisher publisher = client.listTargetResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetResourceTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesPublisher listTargetResourceTypesPaginator(
            ListTargetResourceTypesRequest listTargetResourceTypesRequest) {
        return new ListTargetResourceTypesPublisher(this, listTargetResourceTypesRequest);
    }

    /**
     * <p>
     * Lists the target resource types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesPublisher publisher = client.listTargetResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fis.paginators.ListTargetResourceTypesPublisher publisher = client.listTargetResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetResourceTypes(software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTargetResourceTypesRequest#builder()}
     * </p>
     *
     * @param listTargetResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.ListTargetResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTargetResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetResourceTypesPublisher listTargetResourceTypesPaginator(
            Consumer<ListTargetResourceTypesRequest.Builder> listTargetResourceTypesRequest) {
        return listTargetResourceTypesPaginator(ListTargetResourceTypesRequest.builder()
                .applyMutation(listTargetResourceTypesRequest).build());
    }

    /**
     * <p>
     * Starts running an experiment from the specified experiment template.
     * </p>
     *
     * @param startExperimentRequest
     * @return A Java Future containing the result of the StartExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ConflictException The request could not be processed because of a conflict.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExperimentResponse> startExperiment(StartExperimentRequest startExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts running an experiment from the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link StartExperimentRequest#builder()}
     * </p>
     *
     * @param startExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.StartExperimentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ConflictException The request could not be processed because of a conflict.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExperimentResponse> startExperiment(
            Consumer<StartExperimentRequest.Builder> startExperimentRequest) {
        return startExperiment(StartExperimentRequest.builder().applyMutation(startExperimentRequest).build());
    }

    /**
     * <p>
     * Stops the specified experiment.
     * </p>
     *
     * @param stopExperimentRequest
     * @return A Java Future containing the result of the StopExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopExperimentResponse> stopExperiment(StopExperimentRequest stopExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link StopExperimentRequest#builder()}
     * </p>
     *
     * @param stopExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.StopExperimentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopExperimentResponse> stopExperiment(Consumer<StopExperimentRequest.Builder> stopExperimentRequest) {
        return stopExperiment(StopExperimentRequest.builder().applyMutation(stopExperimentRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified experiment template.
     * </p>
     *
     * @param updateExperimentTemplateRequest
     * @return A Java Future containing the result of the UpdateExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.UpdateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateExperimentTemplateResponse> updateExperimentTemplate(
            UpdateExperimentTemplateRequest updateExperimentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified experiment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExperimentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateExperimentTemplateRequest#builder()}
     * </p>
     *
     * @param updateExperimentTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateExperimentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The specified input is not valid, or fails to satisfy the constraints for the
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FisException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample FisAsyncClient.UpdateExperimentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateExperimentTemplateResponse> updateExperimentTemplate(
            Consumer<UpdateExperimentTemplateRequest.Builder> updateExperimentTemplateRequest) {
        return updateExperimentTemplate(UpdateExperimentTemplateRequest.builder().applyMutation(updateExperimentTemplateRequest)
                .build());
    }

    @Override
    default FisServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link FisAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FisAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FisAsyncClient}.
     */
    static FisAsyncClientBuilder builder() {
        return new DefaultFisAsyncClientBuilder();
    }
}
