/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExperimentTemplateResponse extends FisResponse implements
        ToCopyableBuilder<GetExperimentTemplateResponse.Builder, GetExperimentTemplateResponse> {
    private static final SdkField<ExperimentTemplate> EXPERIMENT_TEMPLATE_FIELD = SdkField
            .<ExperimentTemplate> builder(MarshallingType.SDK_POJO).memberName("experimentTemplate")
            .getter(getter(GetExperimentTemplateResponse::experimentTemplate)).setter(setter(Builder::experimentTemplate))
            .constructor(ExperimentTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_TEMPLATE_FIELD));

    private final ExperimentTemplate experimentTemplate;

    private GetExperimentTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.experimentTemplate = builder.experimentTemplate;
    }

    /**
     * <p>
     * Information about the experiment template.
     * </p>
     * 
     * @return Information about the experiment template.
     */
    public final ExperimentTemplate experimentTemplate() {
        return experimentTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentTemplateResponse)) {
            return false;
        }
        GetExperimentTemplateResponse other = (GetExperimentTemplateResponse) obj;
        return Objects.equals(experimentTemplate(), other.experimentTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExperimentTemplateResponse").add("ExperimentTemplate", experimentTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experimentTemplate":
            return Optional.ofNullable(clazz.cast(experimentTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExperimentTemplateResponse, T> g) {
        return obj -> g.apply((GetExperimentTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExperimentTemplateResponse> {
        /**
         * <p>
         * Information about the experiment template.
         * </p>
         * 
         * @param experimentTemplate
         *        Information about the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentTemplate(ExperimentTemplate experimentTemplate);

        /**
         * <p>
         * Information about the experiment template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentTemplate.Builder} avoiding the
         * need to create one manually via {@link ExperimentTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentTemplate(ExperimentTemplate)}.
         * 
         * @param experimentTemplate
         *        a consumer that will call methods on {@link ExperimentTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentTemplate(ExperimentTemplate)
         */
        default Builder experimentTemplate(Consumer<ExperimentTemplate.Builder> experimentTemplate) {
            return experimentTemplate(ExperimentTemplate.builder().applyMutation(experimentTemplate).build());
        }
    }

    static final class BuilderImpl extends FisResponse.BuilderImpl implements Builder {
        private ExperimentTemplate experimentTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExperimentTemplateResponse model) {
            super(model);
            experimentTemplate(model.experimentTemplate);
        }

        public final ExperimentTemplate.Builder getExperimentTemplate() {
            return experimentTemplate != null ? experimentTemplate.toBuilder() : null;
        }

        public final void setExperimentTemplate(ExperimentTemplate.BuilderImpl experimentTemplate) {
            this.experimentTemplate = experimentTemplate != null ? experimentTemplate.build() : null;
        }

        @Override
        public final Builder experimentTemplate(ExperimentTemplate experimentTemplate) {
            this.experimentTemplate = experimentTemplate;
            return this;
        }

        @Override
        public GetExperimentTemplateResponse build() {
            return new GetExperimentTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
