/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target for an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentTarget.Builder, ExperimentTarget> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ExperimentTarget::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(ExperimentTarget::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceTags")
            .getter(getter(ExperimentTarget::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ExperimentTargetFilter>> FILTERS_FIELD = SdkField
            .<List<ExperimentTargetFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ExperimentTarget::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentTargetFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTargetFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionMode").getter(getter(ExperimentTarget::selectionMode)).setter(setter(Builder::selectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ExperimentTarget::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ARNS_FIELD, RESOURCE_TAGS_FIELD, FILTERS_FIELD, SELECTION_MODE_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final List<String> resourceArns;

    private final Map<String, String> resourceTags;

    private final List<ExperimentTargetFilter> filters;

    private final String selectionMode;

    private final Map<String, String> parameters;

    private ExperimentTarget(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceArns = builder.resourceArns;
        this.resourceTags = builder.resourceTags;
        this.filters = builder.filters;
        this.selectionMode = builder.selectionMode;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the resources.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the target resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return The tags for the target resources.
     */
    public final Map<String, String> resourceTags() {
        return resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to apply to identify target resources using specific attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters to apply to identify target resources using specific attributes.
     */
    public final List<ExperimentTargetFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Scopes the identified resources to a specific count or percentage.
     * </p>
     * 
     * @return Scopes the identified resources to a specific count or percentage.
     */
    public final String selectionMode() {
        return selectionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The resource type parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The resource type parameters.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectionMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTarget)) {
            return false;
        }
        ExperimentTarget other = (ExperimentTarget) obj;
        return Objects.equals(resourceType(), other.resourceType()) && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(selectionMode(), other.selectionMode())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTarget").add("ResourceType", resourceType())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("Filters", hasFilters() ? filters() : null)
                .add("SelectionMode", selectionMode()).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "selectionMode":
            return Optional.ofNullable(clazz.cast(selectionMode()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTarget, T> g) {
        return obj -> g.apply((ExperimentTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTarget> {
        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the resources.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARNs) of the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the resources.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARNs) of the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The tags for the target resources.
         * </p>
         * 
         * @param resourceTags
         *        The tags for the target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String> resourceTags);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * 
         * @param filters
         *        The filters to apply to identify target resources using specific attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ExperimentTargetFilter> filters);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * 
         * @param filters
         *        The filters to apply to identify target resources using specific attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ExperimentTargetFilter... filters);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTargetFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fis.model.ExperimentTargetFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTargetFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ExperimentTargetFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.ExperimentTargetFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ExperimentTargetFilter>)
         */
        Builder filters(Consumer<ExperimentTargetFilter.Builder>... filters);

        /**
         * <p>
         * Scopes the identified resources to a specific count or percentage.
         * </p>
         * 
         * @param selectionMode
         *        Scopes the identified resources to a specific count or percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionMode(String selectionMode);

        /**
         * <p>
         * The resource type parameters.
         * </p>
         * 
         * @param parameters
         *        The resource type parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private List<ExperimentTargetFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String selectionMode;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTarget model) {
            resourceType(model.resourceType);
            resourceArns(model.resourceArns);
            resourceTags(model.resourceTags);
            filters(model.filters);
            selectionMode(model.selectionMode);
            parameters(model.parameters);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
            return this;
        }

        public final List<ExperimentTargetFilter.Builder> getFilters() {
            List<ExperimentTargetFilter.Builder> result = ExperimentTargetFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ExperimentTargetFilter.BuilderImpl> filters) {
            this.filters = ExperimentTargetFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ExperimentTargetFilter> filters) {
            this.filters = ExperimentTargetFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExperimentTargetFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExperimentTargetFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ExperimentTargetFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSelectionMode() {
            return selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentTargetParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentTargetParameterMapCopier.copy(parameters);
            return this;
        }

        @Override
        public ExperimentTarget build() {
            return new ExperimentTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
