/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchDestinationConfiguration.Builder, ElasticsearchDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(ElasticsearchDestinationConfiguration::roleARN))
            .setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainARN").getter(getter(ElasticsearchDestinationConfiguration::domainARN))
            .setter(setter(Builder::domainARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()).build();

    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterEndpoint").getter(getter(ElasticsearchDestinationConfiguration::clusterEndpoint))
            .setter(setter(Builder::clusterEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ElasticsearchDestinationConfiguration::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ElasticsearchDestinationConfiguration::typeName))
            .setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexRotationPeriod").getter(getter(ElasticsearchDestinationConfiguration::indexRotationPeriodAsString))
            .setter(setter(Builder::indexRotationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build())
            .build();

    private static final SdkField<ElasticsearchBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<ElasticsearchBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(ElasticsearchDestinationConfiguration::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(ElasticsearchBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<ElasticsearchRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<ElasticsearchRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(ElasticsearchDestinationConfiguration::retryOptions)).setter(setter(Builder::retryOptions))
            .constructor(ElasticsearchRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(ElasticsearchDestinationConfiguration::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(ElasticsearchDestinationConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(ElasticsearchDestinationConfiguration::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(ElasticsearchDestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(ElasticsearchDestinationConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD,
            BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD,
            PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String domainARN;

    private final String clusterEndpoint;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final ElasticsearchBufferingHints bufferingHints;

    private final ElasticsearchRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationConfiguration s3Configuration;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final VpcConfiguration vpcConfiguration;

    private ElasticsearchDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES
     * Configuration API and for indexing documents. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
     * Firehose Access to an Amazon S3 Destination</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and Amazon Web Services Service Namespaces</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the
     *         Amazon ES Configuration API and for indexing documents. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis
     *         Data Firehose Access to an Amazon S3 Destination</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and Amazon Web Services Service Namespaces</a>.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeDomain</code>,
     * <code>DescribeDomains</code>, and <code>DescribeDomainConfig</code> after assuming the role specified in
     * <b>RoleARN</b>. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and Amazon Web Services Service Namespaces</a>.
     * </p>
     * <p>
     * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
     * </p>
     * 
     * @return The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeDomain</code>,
     *         <code>DescribeDomains</code>, and <code>DescribeDomainConfig</code> after assuming the role specified in
     *         <b>RoleARN</b>. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
     *         <p>
     *         Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
     */
    public final String domainARN() {
        return domainARN;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or the
     * <code>DomainARN</code> field.
     * </p>
     * 
     * @return The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code>
     *         or the <code>DomainARN</code> field.
     */
    public final String clusterEndpoint() {
        return clusterEndpoint;
    }

    /**
     * <p>
     * The Elasticsearch index name.
     * </p>
     * 
     * @return The Elasticsearch index name.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a
     * new type for an existing index that already has another type, Kinesis Data Firehose returns an error during run
     * time.
     * </p>
     * <p>
     * For Elasticsearch 7.x, don't specify a <code>TypeName</code>.
     * </p>
     * 
     * @return The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to
     *         specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an
     *         error during run time.</p>
     *         <p>
     *         For Elasticsearch 7.x, don't specify a <code>TypeName</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code> to
     * facilitate the expiration of old data. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code>
     *         to facilitate the expiration of old data. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
     *         Rotation for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public final ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(indexRotationPeriod);
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code> to
     * facilitate the expiration of old data. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code>
     *         to facilitate the expiration of old data. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
     *         Rotation for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public final String indexRotationPeriodAsString() {
        return indexRotationPeriod;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, the default values for <code>ElasticsearchBufferingHints</code>
     * are used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, the default values for
     *         <code>ElasticsearchBufferingHints</code> are used.
     */
    public final ElasticsearchBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default value
     * is 300 (5 minutes).
     * </p>
     * 
     * @return The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
     *         value is 300 (5 minutes).
     */
    public final ElasticsearchRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When it is set to <code>FailedDocumentsOnly</code>,
     * Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination,
     * with <code>AmazonOpenSearchService-failed/</code> appended to the key prefix. When set to
     * <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes
     * failed documents with <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more information,
     * see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     * for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.
     * </p>
     * <p>
     * You can't change this backup mode after you create the delivery stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When it is set to
     *         <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could not be indexed to
     *         the configured Amazon S3 destination, with <code>AmazonOpenSearchService-failed/</code> appended to the
     *         key prefix. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to
     *         Amazon S3, and also writes failed documents with <code>AmazonOpenSearchService-failed/</code> appended to
     *         the prefix. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     *         for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.</p>
     *         <p>
     *         You can't change this backup mode after you create the delivery stream.
     * @see ElasticsearchS3BackupMode
     */
    public final ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When it is set to <code>FailedDocumentsOnly</code>,
     * Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination,
     * with <code>AmazonOpenSearchService-failed/</code> appended to the key prefix. When set to
     * <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes
     * failed documents with <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more information,
     * see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     * for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.
     * </p>
     * <p>
     * You can't change this backup mode after you create the delivery stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When it is set to
     *         <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could not be indexed to
     *         the configured Amazon S3 destination, with <code>AmazonOpenSearchService-failed/</code> appended to the
     *         key prefix. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to
     *         Amazon S3, and also writes failed documents with <code>AmazonOpenSearchService-failed/</code> appended to
     *         the prefix. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     *         for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.</p>
     *         <p>
     *         You can't change this backup mode after you create the delivery stream.
     * @see ElasticsearchS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The configuration for the backup Amazon S3 location.
     * </p>
     * 
     * @return The configuration for the backup Amazon S3 location.
     */
    public final S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The Amazon CloudWatch logging options for your delivery stream.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The details of the VPC of the Amazon ES destination.
     * </p>
     * 
     * @return The details of the VPC of the Amazon ES destination.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationConfiguration)) {
            return false;
        }
        ElasticsearchDestinationConfiguration other = (ElasticsearchDestinationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(domainARN(), other.domainARN())
                && Objects.equals(clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(typeName(), other.typeName())
                && Objects.equals(indexRotationPeriodAsString(), other.indexRotationPeriodAsString())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchDestinationConfiguration").add("RoleARN", roleARN()).add("DomainARN", domainARN())
                .add("ClusterEndpoint", clusterEndpoint()).add("IndexName", indexName()).add("TypeName", typeName())
                .add("IndexRotationPeriod", indexRotationPeriodAsString()).add("BufferingHints", bufferingHints())
                .add("RetryOptions", retryOptions()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3Configuration", s3Configuration()).add("ProcessingConfiguration", processingConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "DomainARN":
            return Optional.ofNullable(clazz.cast(domainARN()));
        case "ClusterEndpoint":
            return Optional.ofNullable(clazz.cast(clusterEndpoint()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "IndexRotationPeriod":
            return Optional.ofNullable(clazz.cast(indexRotationPeriodAsString()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDestinationConfiguration, T> g) {
        return obj -> g.apply((ElasticsearchDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon
         * ES Configuration API and for indexing documents. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis
         * Data Firehose Access to an Amazon S3 Destination</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the
         *        Amazon ES Configuration API and for indexing documents. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant
         *        Kinesis Data Firehose Access to an Amazon S3 Destination</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeDomain</code>,
         * <code>DescribeDomains</code>, and <code>DescribeDomainConfig</code> after assuming the role specified in
         * <b>RoleARN</b>. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * <p>
         * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
         * </p>
         * 
         * @param domainARN
         *        The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeDomain</code>,
         *        <code>DescribeDomains</code>, and <code>DescribeDomainConfig</code> after assuming the role specified
         *        in <b>RoleARN</b>. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
         *        <p>
         *        Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * <p>
         * The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or
         * the <code>DomainARN</code> field.
         * </p>
         * 
         * @param clusterEndpoint
         *        The endpoint to use when communicating with the cluster. Specify either this
         *        <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoint(String clusterEndpoint);

        /**
         * <p>
         * The Elasticsearch index name.
         * </p>
         * 
         * @param indexName
         *        The Elasticsearch index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to
         * specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an
         * error during run time.
         * </p>
         * <p>
         * For Elasticsearch 7.x, don't specify a <code>TypeName</code>.
         * </p>
         * 
         * @param typeName
         *        The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try
         *        to specify a new type for an existing index that already has another type, Kinesis Data Firehose
         *        returns an error during run time.</p>
         *        <p>
         *        For Elasticsearch 7.x, don't specify a <code>TypeName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code> to
         * facilitate the expiration of old data. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
         * for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to the
         *        <code>IndexName</code> to facilitate the expiration of old data. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code> to
         * facilitate the expiration of old data. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
         * for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to the
         *        <code>IndexName</code> to facilitate the expiration of old data. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod);

        /**
         * <p>
         * The buffering options. If no value is specified, the default values for
         * <code>ElasticsearchBufferingHints</code> are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options. If no value is specified, the default values for
         *        <code>ElasticsearchBufferingHints</code> are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(ElasticsearchBufferingHints bufferingHints);

        /**
         * <p>
         * The buffering options. If no value is specified, the default values for
         * <code>ElasticsearchBufferingHints</code> are used.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchBufferingHints.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchBufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchBufferingHints.Builder#build()} is called
         * immediately and its result is passed to {@link #bufferingHints(ElasticsearchBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link ElasticsearchBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(ElasticsearchBufferingHints)
         */
        default Builder bufferingHints(Consumer<ElasticsearchBufferingHints.Builder> bufferingHints) {
            return bufferingHints(ElasticsearchBufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
         * value is 300 (5 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The
         *        default value is 300 (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(ElasticsearchRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
         * value is 300 (5 minutes).
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchRetryOptions.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchRetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchRetryOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #retryOptions(ElasticsearchRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link ElasticsearchRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(ElasticsearchRetryOptions)
         */
        default Builder retryOptions(Consumer<ElasticsearchRetryOptions.Builder> retryOptions) {
            return retryOptions(ElasticsearchRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When it is set to <code>FailedDocumentsOnly</code>,
         * Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination,
         * with <code>AmazonOpenSearchService-failed/</code> appended to the key prefix. When set to
         * <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes
         * failed documents with <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for
         * the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.
         * </p>
         * <p>
         * You can't change this backup mode after you create the delivery stream.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When it is set to
         *        <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could not be indexed
         *        to the configured Amazon S3 destination, with <code>AmazonOpenSearchService-failed/</code> appended to
         *        the key prefix. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming
         *        records to Amazon S3, and also writes failed documents with
         *        <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3
         *        Backup for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.</p>
         *        <p>
         *        You can't change this backup mode after you create the delivery stream.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When it is set to <code>FailedDocumentsOnly</code>,
         * Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination,
         * with <code>AmazonOpenSearchService-failed/</code> appended to the key prefix. When set to
         * <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes
         * failed documents with <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for
         * the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.
         * </p>
         * <p>
         * You can't change this backup mode after you create the delivery stream.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When it is set to
         *        <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could not be indexed
         *        to the configured Amazon S3 destination, with <code>AmazonOpenSearchService-failed/</code> appended to
         *        the key prefix. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming
         *        records to Amazon S3, and also writes failed documents with
         *        <code>AmazonOpenSearchService-failed/</code> appended to the prefix. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3
         *        Backup for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.</p>
         *        <p>
         *        You can't change this backup mode after you create the delivery stream.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode);

        /**
         * <p>
         * The configuration for the backup Amazon S3 location.
         * </p>
         * 
         * @param s3Configuration
         *        The configuration for the backup Amazon S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * <p>
         * The configuration for the backup Amazon S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DestinationConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DestinationConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DestinationConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The Amazon CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The Amazon CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * <p>
         * The details of the VPC of the Amazon ES destination.
         * </p>
         * 
         * @param vpcConfiguration
         *        The details of the VPC of the Amazon ES destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The details of the VPC of the Amazon ES destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String clusterEndpoint;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private ElasticsearchBufferingHints bufferingHints;

        private ElasticsearchRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationConfiguration s3Configuration;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationConfiguration model) {
            roleARN(model.roleARN);
            domainARN(model.domainARN);
            clusterEndpoint(model.clusterEndpoint);
            indexName(model.indexName);
            typeName(model.typeName);
            indexRotationPeriod(model.indexRotationPeriod);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Configuration(model.s3Configuration);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public ElasticsearchDestinationConfiguration build() {
            return new ElasticsearchDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
