/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.firehose.DefaultFirehoseBaseClientBuilder;
import software.amazon.awssdk.services.firehose.DefaultFirehoseClient;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.FirehoseClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseServiceClientConfiguration;
import software.amazon.awssdk.services.firehose.endpoints.FirehoseEndpointProvider;

@SdkInternalApi
final class DefaultFirehoseClientBuilder
extends DefaultFirehoseBaseClientBuilder<FirehoseClientBuilder, FirehoseClient>
implements FirehoseClientBuilder {
    DefaultFirehoseClientBuilder() {
    }

    @Override
    public DefaultFirehoseClientBuilder endpointProvider(FirehoseEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FirehoseClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFirehoseClientBuilder.validateClientOptions(clientConfiguration);
        FirehoseServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFirehoseClient client = new DefaultFirehoseClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FirehoseServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FirehoseServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

