/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.OrcSerDe;
import software.amazon.awssdk.services.firehose.model.ParquetSerDe;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Serializer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Serializer> {
    private static final SdkField<ParquetSerDe> PARQUET_SER_DE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParquetSerDe").getter(Serializer.getter(Serializer::parquetSerDe)).setter(Serializer.setter(Builder::parquetSerDe)).constructor(ParquetSerDe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetSerDe").build()}).build();
    private static final SdkField<OrcSerDe> ORC_SER_DE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrcSerDe").getter(Serializer.getter(Serializer::orcSerDe)).setter(Serializer.setter(Builder::orcSerDe)).constructor(OrcSerDe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrcSerDe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARQUET_SER_DE_FIELD, ORC_SER_DE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ParquetSerDe parquetSerDe;
    private final OrcSerDe orcSerDe;

    private Serializer(BuilderImpl builder) {
        this.parquetSerDe = builder.parquetSerDe;
        this.orcSerDe = builder.orcSerDe;
    }

    public final ParquetSerDe parquetSerDe() {
        return this.parquetSerDe;
    }

    public final OrcSerDe orcSerDe() {
        return this.orcSerDe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetSerDe());
        hashCode = 31 * hashCode + Objects.hashCode(this.orcSerDe());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Serializer)) {
            return false;
        }
        Serializer other = (Serializer)obj;
        return Objects.equals(this.parquetSerDe(), other.parquetSerDe()) && Objects.equals(this.orcSerDe(), other.orcSerDe());
    }

    public final String toString() {
        return ToString.builder((String)"Serializer").add("ParquetSerDe", (Object)this.parquetSerDe()).add("OrcSerDe", (Object)this.orcSerDe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParquetSerDe": {
                return Optional.ofNullable(clazz.cast(this.parquetSerDe()));
            }
            case "OrcSerDe": {
                return Optional.ofNullable(clazz.cast(this.orcSerDe()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Serializer, T> g) {
        return obj -> g.apply((Serializer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ParquetSerDe parquetSerDe;
        private OrcSerDe orcSerDe;

        private BuilderImpl() {
        }

        private BuilderImpl(Serializer model) {
            this.parquetSerDe(model.parquetSerDe);
            this.orcSerDe(model.orcSerDe);
        }

        public final ParquetSerDe.Builder getParquetSerDe() {
            return this.parquetSerDe != null ? this.parquetSerDe.toBuilder() : null;
        }

        public final void setParquetSerDe(ParquetSerDe.BuilderImpl parquetSerDe) {
            this.parquetSerDe = parquetSerDe != null ? parquetSerDe.build() : null;
        }

        @Override
        public final Builder parquetSerDe(ParquetSerDe parquetSerDe) {
            this.parquetSerDe = parquetSerDe;
            return this;
        }

        public final OrcSerDe.Builder getOrcSerDe() {
            return this.orcSerDe != null ? this.orcSerDe.toBuilder() : null;
        }

        public final void setOrcSerDe(OrcSerDe.BuilderImpl orcSerDe) {
            this.orcSerDe = orcSerDe != null ? orcSerDe.build() : null;
        }

        @Override
        public final Builder orcSerDe(OrcSerDe orcSerDe) {
            this.orcSerDe = orcSerDe;
            return this;
        }

        public Serializer build() {
            return new Serializer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Serializer> {
        public Builder parquetSerDe(ParquetSerDe var1);

        default public Builder parquetSerDe(Consumer<ParquetSerDe.Builder> parquetSerDe) {
            return this.parquetSerDe((ParquetSerDe)((ParquetSerDe.Builder)ParquetSerDe.builder().applyMutation(parquetSerDe)).build());
        }

        public Builder orcSerDe(OrcSerDe var1);

        default public Builder orcSerDe(Consumer<OrcSerDe.Builder> orcSerDe) {
            return this.orcSerDe((OrcSerDe)((OrcSerDe.Builder)OrcSerDe.builder().applyMutation(orcSerDe)).build());
        }
    }
}

