/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse;

public class ListKxClusterNodesPublisher
implements SdkPublisher<ListKxClusterNodesResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxClusterNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxClusterNodesPublisher(FinspaceAsyncClient client, ListKxClusterNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxClusterNodesPublisher(FinspaceAsyncClient client, ListKxClusterNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxClusterNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxClusterNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListKxClusterNodesResponseFetcher
    implements AsyncPageFetcher<ListKxClusterNodesResponse> {
        private ListKxClusterNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListKxClusterNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxClusterNodesResponse> nextPage(ListKxClusterNodesResponse previousPage) {
            if (previousPage == null) {
                return ListKxClusterNodesPublisher.this.client.listKxClusterNodes(ListKxClusterNodesPublisher.this.firstRequest);
            }
            return ListKxClusterNodesPublisher.this.client.listKxClusterNodes((ListKxClusterNodesRequest)((Object)ListKxClusterNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

