/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of changeset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxChangesetListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<KxChangesetListEntry.Builder, KxChangesetListEntry> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(KxChangesetListEntry::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(KxChangesetListEntry::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> ACTIVE_FROM_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("activeFromTimestamp").getter(getter(KxChangesetListEntry::activeFromTimestamp))
            .setter(setter(Builder::activeFromTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeFromTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(KxChangesetListEntry::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KxChangesetListEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD,
            CREATED_TIMESTAMP_FIELD, ACTIVE_FROM_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changesetId;

    private final Instant createdTimestamp;

    private final Instant activeFromTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String status;

    private KxChangesetListEntry(BuilderImpl builder) {
        this.changesetId = builder.changesetId;
        this.createdTimestamp = builder.createdTimestamp;
        this.activeFromTimestamp = builder.activeFromTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * <p>
     * The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For
     * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds.
     *         For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant activeFromTimestamp() {
        return activeFromTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the changeset was modified. The value is determined as epoch time in milliseconds. For
     * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the changeset was modified. The value is determined as epoch time in milliseconds.
     *         For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * Status of the changeset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending – Changeset creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Processing – Changeset creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – Changeset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Complete – Changeset creation has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the changeset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending – Changeset creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Processing – Changeset creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – Changeset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Complete – Changeset creation has succeeded.
     *         </p>
     *         </li>
     * @see ChangesetStatus
     */
    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the changeset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending – Changeset creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Processing – Changeset creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – Changeset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Complete – Changeset creation has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the changeset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending – Changeset creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Processing – Changeset creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – Changeset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Complete – Changeset creation has succeeded.
     *         </p>
     *         </li>
     * @see ChangesetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(activeFromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxChangesetListEntry)) {
            return false;
        }
        KxChangesetListEntry other = (KxChangesetListEntry) obj;
        return Objects.equals(changesetId(), other.changesetId()) && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(activeFromTimestamp(), other.activeFromTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxChangesetListEntry").add("ChangesetId", changesetId())
                .add("CreatedTimestamp", createdTimestamp()).add("ActiveFromTimestamp", activeFromTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "activeFromTimestamp":
            return Optional.ofNullable(clazz.cast(activeFromTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxChangesetListEntry, T> g) {
        return obj -> g.apply((KxChangesetListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxChangesetListEntry> {
        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param activeFromTimestamp
         *        Beginning time from which the changeset is active. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeFromTimestamp(Instant activeFromTimestamp);

        /**
         * <p>
         * The timestamp at which the changeset was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The timestamp at which the changeset was modified. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * Status of the changeset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending – Changeset creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Processing – Changeset creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – Changeset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Complete – Changeset creation has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the changeset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending – Changeset creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Processing – Changeset creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – Changeset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Complete – Changeset creation has succeeded.
         *        </p>
         *        </li>
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the changeset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending – Changeset creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Processing – Changeset creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – Changeset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Complete – Changeset creation has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the changeset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending – Changeset creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Processing – Changeset creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – Changeset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Complete – Changeset creation has succeeded.
         *        </p>
         *        </li>
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(ChangesetStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String changesetId;

        private Instant createdTimestamp;

        private Instant activeFromTimestamp;

        private Instant lastModifiedTimestamp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(KxChangesetListEntry model) {
            changesetId(model.changesetId);
            createdTimestamp(model.createdTimestamp);
            activeFromTimestamp(model.activeFromTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            status(model.status);
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getActiveFromTimestamp() {
            return activeFromTimestamp;
        }

        public final void setActiveFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
        }

        @Override
        public final Builder activeFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public KxChangesetListEntry build() {
            return new KxChangesetListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
