/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDatabaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDatabaseConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(KxDatabaseConfiguration.getter(KxDatabaseConfiguration::databaseName)).setter(KxDatabaseConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<List<KxDatabaseCacheConfiguration>> CACHE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheConfigurations").getter(KxDatabaseConfiguration.getter(KxDatabaseConfiguration::cacheConfigurations)).setter(KxDatabaseConfiguration.setter(Builder::cacheConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDatabaseCacheConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(KxDatabaseConfiguration.getter(KxDatabaseConfiguration::changesetId)).setter(KxDatabaseConfiguration.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, CACHE_CONFIGURATIONS_FIELD, CHANGESET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final List<KxDatabaseCacheConfiguration> cacheConfigurations;
    private final String changesetId;

    private KxDatabaseConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.cacheConfigurations = builder.cacheConfigurations;
        this.changesetId = builder.changesetId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final boolean hasCacheConfigurations() {
        return this.cacheConfigurations != null && !(this.cacheConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDatabaseCacheConfiguration> cacheConfigurations() {
        return this.cacheConfigurations;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheConfigurations() ? this.cacheConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDatabaseConfiguration)) {
            return false;
        }
        KxDatabaseConfiguration other = (KxDatabaseConfiguration)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && this.hasCacheConfigurations() == other.hasCacheConfigurations() && Objects.equals(this.cacheConfigurations(), other.cacheConfigurations()) && Objects.equals(this.changesetId(), other.changesetId());
    }

    public final String toString() {
        return ToString.builder((String)"KxDatabaseConfiguration").add("DatabaseName", (Object)this.databaseName()).add("CacheConfigurations", this.hasCacheConfigurations() ? this.cacheConfigurations() : null).add("ChangesetId", (Object)this.changesetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "cacheConfigurations": {
                return Optional.ofNullable(clazz.cast(this.cacheConfigurations()));
            }
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxDatabaseConfiguration, T> g) {
        return obj -> g.apply((KxDatabaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private List<KxDatabaseCacheConfiguration> cacheConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String changesetId;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDatabaseConfiguration model) {
            this.databaseName(model.databaseName);
            this.cacheConfigurations(model.cacheConfigurations);
            this.changesetId(model.changesetId);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final List<KxDatabaseCacheConfiguration.Builder> getCacheConfigurations() {
            List<KxDatabaseCacheConfiguration.Builder> result = KxDatabaseCacheConfigurationsCopier.copyToBuilder(this.cacheConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheConfigurations(Collection<KxDatabaseCacheConfiguration.BuilderImpl> cacheConfigurations) {
            this.cacheConfigurations = KxDatabaseCacheConfigurationsCopier.copyFromBuilder(cacheConfigurations);
        }

        @Override
        public final Builder cacheConfigurations(Collection<KxDatabaseCacheConfiguration> cacheConfigurations) {
            this.cacheConfigurations = KxDatabaseCacheConfigurationsCopier.copy(cacheConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheConfigurations(KxDatabaseCacheConfiguration ... cacheConfigurations) {
            this.cacheConfigurations(Arrays.asList(cacheConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheConfigurations(Consumer<KxDatabaseCacheConfiguration.Builder> ... cacheConfigurations) {
            this.cacheConfigurations(Stream.of(cacheConfigurations).map(c -> (KxDatabaseCacheConfiguration)((KxDatabaseCacheConfiguration.Builder)KxDatabaseCacheConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public KxDatabaseConfiguration build() {
            return new KxDatabaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDatabaseConfiguration> {
        public Builder databaseName(String var1);

        public Builder cacheConfigurations(Collection<KxDatabaseCacheConfiguration> var1);

        public Builder cacheConfigurations(KxDatabaseCacheConfiguration ... var1);

        public Builder cacheConfigurations(Consumer<KxDatabaseCacheConfiguration.Builder> ... var1);

        public Builder changesetId(String var1);
    }
}

