/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolutionTechniques implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolutionTechniques.Builder, ResolutionTechniques> {
    private static final SdkField<ProviderProperties> PROVIDER_PROPERTIES_FIELD = SdkField
            .<ProviderProperties> builder(MarshallingType.SDK_POJO).memberName("providerProperties")
            .getter(getter(ResolutionTechniques::providerProperties)).setter(setter(Builder::providerProperties))
            .constructor(ProviderProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerProperties").build())
            .build();

    private static final SdkField<String> RESOLUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionType").getter(getter(ResolutionTechniques::resolutionTypeAsString))
            .setter(setter(Builder::resolutionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionType").build()).build();

    private static final SdkField<RuleBasedProperties> RULE_BASED_PROPERTIES_FIELD = SdkField
            .<RuleBasedProperties> builder(MarshallingType.SDK_POJO).memberName("ruleBasedProperties")
            .getter(getter(ResolutionTechniques::ruleBasedProperties)).setter(setter(Builder::ruleBasedProperties))
            .constructor(RuleBasedProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleBasedProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_PROPERTIES_FIELD,
            RESOLUTION_TYPE_FIELD, RULE_BASED_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProviderProperties providerProperties;

    private final String resolutionType;

    private final RuleBasedProperties ruleBasedProperties;

    private ResolutionTechniques(BuilderImpl builder) {
        this.providerProperties = builder.providerProperties;
        this.resolutionType = builder.resolutionType;
        this.ruleBasedProperties = builder.ruleBasedProperties;
    }

    /**
     * <p>
     * The properties of the provider service.
     * </p>
     * 
     * @return The properties of the provider service.
     */
    public final ProviderProperties providerProperties() {
        return providerProperties;
    }

    /**
     * <p>
     * The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and <code>ML_MATCHING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
     *         <code>ML_MATCHING</code>.
     * @see ResolutionType
     */
    public final ResolutionType resolutionType() {
        return ResolutionType.fromValue(resolutionType);
    }

    /**
     * <p>
     * The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and <code>ML_MATCHING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
     *         <code>ML_MATCHING</code>.
     * @see ResolutionType
     */
    public final String resolutionTypeAsString() {
        return resolutionType;
    }

    /**
     * <p>
     * An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a list of
     * rule objects.
     * </p>
     * 
     * @return An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a
     *         list of rule objects.
     */
    public final RuleBasedProperties ruleBasedProperties() {
        return ruleBasedProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleBasedProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionTechniques)) {
            return false;
        }
        ResolutionTechniques other = (ResolutionTechniques) obj;
        return Objects.equals(providerProperties(), other.providerProperties())
                && Objects.equals(resolutionTypeAsString(), other.resolutionTypeAsString())
                && Objects.equals(ruleBasedProperties(), other.ruleBasedProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolutionTechniques").add("ProviderProperties", providerProperties())
                .add("ResolutionType", resolutionTypeAsString()).add("RuleBasedProperties", ruleBasedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerProperties":
            return Optional.ofNullable(clazz.cast(providerProperties()));
        case "resolutionType":
            return Optional.ofNullable(clazz.cast(resolutionTypeAsString()));
        case "ruleBasedProperties":
            return Optional.ofNullable(clazz.cast(ruleBasedProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolutionTechniques, T> g) {
        return obj -> g.apply((ResolutionTechniques) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolutionTechniques> {
        /**
         * <p>
         * The properties of the provider service.
         * </p>
         * 
         * @param providerProperties
         *        The properties of the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerProperties(ProviderProperties providerProperties);

        /**
         * <p>
         * The properties of the provider service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderProperties.Builder} avoiding the
         * need to create one manually via {@link ProviderProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #providerProperties(ProviderProperties)}.
         * 
         * @param providerProperties
         *        a consumer that will call methods on {@link ProviderProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerProperties(ProviderProperties)
         */
        default Builder providerProperties(Consumer<ProviderProperties.Builder> providerProperties) {
            return providerProperties(ProviderProperties.builder().applyMutation(providerProperties).build());
        }

        /**
         * <p>
         * The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
         * <code>ML_MATCHING</code>.
         * </p>
         * 
         * @param resolutionType
         *        The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
         *        <code>ML_MATCHING</code>.
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(String resolutionType);

        /**
         * <p>
         * The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
         * <code>ML_MATCHING</code>.
         * </p>
         * 
         * @param resolutionType
         *        The type of matching. There are two types of matching: <code>RULE_MATCHING</code> and
         *        <code>ML_MATCHING</code>.
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(ResolutionType resolutionType);

        /**
         * <p>
         * An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a list
         * of rule objects.
         * </p>
         * 
         * @param ruleBasedProperties
         *        An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is
         *        a list of rule objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleBasedProperties(RuleBasedProperties ruleBasedProperties);

        /**
         * <p>
         * An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a list
         * of rule objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleBasedProperties.Builder} avoiding the
         * need to create one manually via {@link RuleBasedProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleBasedProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #ruleBasedProperties(RuleBasedProperties)}.
         * 
         * @param ruleBasedProperties
         *        a consumer that will call methods on {@link RuleBasedProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleBasedProperties(RuleBasedProperties)
         */
        default Builder ruleBasedProperties(Consumer<RuleBasedProperties.Builder> ruleBasedProperties) {
            return ruleBasedProperties(RuleBasedProperties.builder().applyMutation(ruleBasedProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProviderProperties providerProperties;

        private String resolutionType;

        private RuleBasedProperties ruleBasedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolutionTechniques model) {
            providerProperties(model.providerProperties);
            resolutionType(model.resolutionType);
            ruleBasedProperties(model.ruleBasedProperties);
        }

        public final ProviderProperties.Builder getProviderProperties() {
            return providerProperties != null ? providerProperties.toBuilder() : null;
        }

        public final void setProviderProperties(ProviderProperties.BuilderImpl providerProperties) {
            this.providerProperties = providerProperties != null ? providerProperties.build() : null;
        }

        @Override
        public final Builder providerProperties(ProviderProperties providerProperties) {
            this.providerProperties = providerProperties;
            return this;
        }

        public final String getResolutionType() {
            return resolutionType;
        }

        public final void setResolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
        }

        @Override
        public final Builder resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public final Builder resolutionType(ResolutionType resolutionType) {
            this.resolutionType(resolutionType == null ? null : resolutionType.toString());
            return this;
        }

        public final RuleBasedProperties.Builder getRuleBasedProperties() {
            return ruleBasedProperties != null ? ruleBasedProperties.toBuilder() : null;
        }

        public final void setRuleBasedProperties(RuleBasedProperties.BuilderImpl ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties != null ? ruleBasedProperties.build() : null;
        }

        @Override
        public final Builder ruleBasedProperties(RuleBasedProperties ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties;
            return this;
        }

        @Override
        public ResolutionTechniques build() {
            return new ResolutionTechniques(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
