/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output source for the ID mapping workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingWorkflowOutputSource implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingWorkflowOutputSource.Builder, IdMappingWorkflowOutputSource> {
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSArn")
            .getter(getter(IdMappingWorkflowOutputSource::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()).build();

    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Path").getter(getter(IdMappingWorkflowOutputSource::outputS3Path))
            .setter(setter(Builder::outputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ARN_FIELD,
            OUTPUT_S3_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsArn;

    private final String outputS3Path;

    private IdMappingWorkflowOutputSource(BuilderImpl builder) {
        this.kmsArn = builder.kmsArn;
        this.outputS3Path = builder.outputS3Path;
    }

    /**
     * <p>
     * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
     * </p>
     * 
     * @return Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
     *         KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The S3 path to which Entity Resolution will write the output table.
     * </p>
     * 
     * @return The S3 path to which Entity Resolution will write the output table.
     */
    public final String outputS3Path() {
        return outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingWorkflowOutputSource)) {
            return false;
        }
        IdMappingWorkflowOutputSource other = (IdMappingWorkflowOutputSource) obj;
        return Objects.equals(kmsArn(), other.kmsArn()) && Objects.equals(outputS3Path(), other.outputS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingWorkflowOutputSource").add("KMSArn", kmsArn()).add("OutputS3Path", outputS3Path())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "outputS3Path":
            return Optional.ofNullable(clazz.cast(outputS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdMappingWorkflowOutputSource, T> g) {
        return obj -> g.apply((IdMappingWorkflowOutputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingWorkflowOutputSource> {
        /**
         * <p>
         * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS
         * key.
         * </p>
         * 
         * @param kmsArn
         *        Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
         *        KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The S3 path to which Entity Resolution will write the output table.
         * </p>
         * 
         * @param outputS3Path
         *        The S3 path to which Entity Resolution will write the output table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Path(String outputS3Path);
    }

    static final class BuilderImpl implements Builder {
        private String kmsArn;

        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingWorkflowOutputSource model) {
            kmsArn(model.kmsArn);
            outputS3Path(model.outputS3Path);
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getOutputS3Path() {
            return outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        @Override
        public IdMappingWorkflowOutputSource build() {
            return new IdMappingWorkflowOutputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
