/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>InputRecords</code>, <code>TotalRecordsProcessed</code>, <code>MatchIDs</code>, and
 * <code>RecordsNotProcessed</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingJobMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingJobMetrics.Builder, IdMappingJobMetrics> {
    private static final SdkField<Integer> INPUT_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inputRecords").getter(getter(IdMappingJobMetrics::inputRecords)).setter(setter(Builder::inputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputRecords").build()).build();

    private static final SdkField<Integer> RECORDS_NOT_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordsNotProcessed").getter(getter(IdMappingJobMetrics::recordsNotProcessed))
            .setter(setter(Builder::recordsNotProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsNotProcessed").build())
            .build();

    private static final SdkField<Integer> TOTAL_RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecordsProcessed").getter(getter(IdMappingJobMetrics::totalRecordsProcessed))
            .setter(setter(Builder::totalRecordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsProcessed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_RECORDS_FIELD,
            RECORDS_NOT_PROCESSED_FIELD, TOTAL_RECORDS_PROCESSED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer inputRecords;

    private final Integer recordsNotProcessed;

    private final Integer totalRecordsProcessed;

    private IdMappingJobMetrics(BuilderImpl builder) {
        this.inputRecords = builder.inputRecords;
        this.recordsNotProcessed = builder.recordsNotProcessed;
        this.totalRecordsProcessed = builder.totalRecordsProcessed;
    }

    /**
     * <p>
     * The total number of input records.
     * </p>
     * 
     * @return The total number of input records.
     */
    public final Integer inputRecords() {
        return inputRecords;
    }

    /**
     * <p>
     * The total number of records that did not get processed.
     * </p>
     * 
     * @return The total number of records that did not get processed.
     */
    public final Integer recordsNotProcessed() {
        return recordsNotProcessed;
    }

    /**
     * <p>
     * The total number of records processed.
     * </p>
     * 
     * @return The total number of records processed.
     */
    public final Integer totalRecordsProcessed() {
        return totalRecordsProcessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(recordsNotProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordsProcessed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingJobMetrics)) {
            return false;
        }
        IdMappingJobMetrics other = (IdMappingJobMetrics) obj;
        return Objects.equals(inputRecords(), other.inputRecords())
                && Objects.equals(recordsNotProcessed(), other.recordsNotProcessed())
                && Objects.equals(totalRecordsProcessed(), other.totalRecordsProcessed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingJobMetrics").add("InputRecords", inputRecords())
                .add("RecordsNotProcessed", recordsNotProcessed()).add("TotalRecordsProcessed", totalRecordsProcessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputRecords":
            return Optional.ofNullable(clazz.cast(inputRecords()));
        case "recordsNotProcessed":
            return Optional.ofNullable(clazz.cast(recordsNotProcessed()));
        case "totalRecordsProcessed":
            return Optional.ofNullable(clazz.cast(totalRecordsProcessed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdMappingJobMetrics, T> g) {
        return obj -> g.apply((IdMappingJobMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingJobMetrics> {
        /**
         * <p>
         * The total number of input records.
         * </p>
         * 
         * @param inputRecords
         *        The total number of input records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecords(Integer inputRecords);

        /**
         * <p>
         * The total number of records that did not get processed.
         * </p>
         * 
         * @param recordsNotProcessed
         *        The total number of records that did not get processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsNotProcessed(Integer recordsNotProcessed);

        /**
         * <p>
         * The total number of records processed.
         * </p>
         * 
         * @param totalRecordsProcessed
         *        The total number of records processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordsProcessed(Integer totalRecordsProcessed);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputRecords;

        private Integer recordsNotProcessed;

        private Integer totalRecordsProcessed;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingJobMetrics model) {
            inputRecords(model.inputRecords);
            recordsNotProcessed(model.recordsNotProcessed);
            totalRecordsProcessed(model.totalRecordsProcessed);
        }

        public final Integer getInputRecords() {
            return inputRecords;
        }

        public final void setInputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
        }

        @Override
        public final Builder inputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
            return this;
        }

        public final Integer getRecordsNotProcessed() {
            return recordsNotProcessed;
        }

        public final void setRecordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
        }

        @Override
        public final Builder recordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
            return this;
        }

        public final Integer getTotalRecordsProcessed() {
            return totalRecordsProcessed;
        }

        public final void setTotalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
        }

        @Override
        public final Builder totalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
            return this;
        }

        @Override
        public IdMappingJobMetrics build() {
            return new IdMappingJobMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
