/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a job template parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateParameterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateParameterConfiguration.Builder, TemplateParameterConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TemplateParameterConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(TemplateParameterConfiguration::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String defaultValue;

    private TemplateParameterConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateParameterDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
     * @see TemplateParameterDataType
     */
    public final TemplateParameterDataType type() {
        return TemplateParameterDataType.fromValue(type);
    }

    /**
     * <p>
     * The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateParameterDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
     * @see TemplateParameterDataType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The default value for the job template parameter.
     * </p>
     * 
     * @return The default value for the job template parameter.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameterConfiguration)) {
            return false;
        }
        TemplateParameterConfiguration other = (TemplateParameterConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateParameterConfiguration").add("Type", typeAsString()).add("DefaultValue", defaultValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateParameterConfiguration, T> g) {
        return obj -> g.apply((TemplateParameterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateParameterConfiguration> {
        /**
         * <p>
         * The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
         * </p>
         * 
         * @param type
         *        The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
         * @see TemplateParameterDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateParameterDataType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
         * </p>
         * 
         * @param type
         *        The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
         * @see TemplateParameterDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateParameterDataType
         */
        Builder type(TemplateParameterDataType type);

        /**
         * <p>
         * The default value for the job template parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value for the job template parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameterConfiguration model) {
            type(model.type);
            defaultValue(model.defaultValue);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TemplateParameterDataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public TemplateParameterConfiguration build() {
            return new TemplateParameterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
