/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest;
import software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse;

public class ListSupportedInstanceTypesPublisher
implements SdkPublisher<ListSupportedInstanceTypesResponse> {
    private final EmrAsyncClient client;
    private final ListSupportedInstanceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSupportedInstanceTypesPublisher(EmrAsyncClient client, ListSupportedInstanceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSupportedInstanceTypesPublisher(EmrAsyncClient client, ListSupportedInstanceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSupportedInstanceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSupportedInstanceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSupportedInstanceTypesResponseFetcher
    implements AsyncPageFetcher<ListSupportedInstanceTypesResponse> {
        private ListSupportedInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSupportedInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListSupportedInstanceTypesResponse> nextPage(ListSupportedInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSupportedInstanceTypesPublisher.this.client.listSupportedInstanceTypes(ListSupportedInstanceTypesPublisher.this.firstRequest);
            }
            return ListSupportedInstanceTypesPublisher.this.client.listSupportedInstanceTypes((ListSupportedInstanceTypesRequest)((Object)ListSupportedInstanceTypesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

