/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlacementGroupStrategy {
    SPREAD("SPREAD"),
    PARTITION("PARTITION"),
    CLUSTER("CLUSTER"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlacementGroupStrategy> VALUE_MAP;
    private final String value;

    private PlacementGroupStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlacementGroupStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlacementGroupStrategy> knownValues() {
        EnumSet<PlacementGroupStrategy> knownValues = EnumSet.allOf(PlacementGroupStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlacementGroupStrategy.class, PlacementGroupStrategy::toString);
    }
}

