/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLbCookieStickinessPolicyRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateLbCookieStickinessPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(CreateLbCookieStickinessPolicyRequest.getter(CreateLbCookieStickinessPolicyRequest::loadBalancerName)).setter(CreateLbCookieStickinessPolicyRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(CreateLbCookieStickinessPolicyRequest.getter(CreateLbCookieStickinessPolicyRequest::policyName)).setter(CreateLbCookieStickinessPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<Long> COOKIE_EXPIRATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CookieExpirationPeriod").getter(CreateLbCookieStickinessPolicyRequest.getter(CreateLbCookieStickinessPolicyRequest::cookieExpirationPeriod)).setter(CreateLbCookieStickinessPolicyRequest.setter(Builder::cookieExpirationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieExpirationPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, POLICY_NAME_FIELD, COOKIE_EXPIRATION_PERIOD_FIELD));
    private final String loadBalancerName;
    private final String policyName;
    private final Long cookieExpirationPeriod;

    private CreateLbCookieStickinessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final Long cookieExpirationPeriod() {
        return this.cookieExpirationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieExpirationPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLbCookieStickinessPolicyRequest)) {
            return false;
        }
        CreateLbCookieStickinessPolicyRequest other = (CreateLbCookieStickinessPolicyRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieExpirationPeriod(), other.cookieExpirationPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLbCookieStickinessPolicyRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("PolicyName", (Object)this.policyName()).add("CookieExpirationPeriod", (Object)this.cookieExpirationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "CookieExpirationPeriod": {
                return Optional.ofNullable(clazz.cast(this.cookieExpirationPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLbCookieStickinessPolicyRequest, T> g) {
        return obj -> g.apply((CreateLbCookieStickinessPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private Long cookieExpirationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLbCookieStickinessPolicyRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
            this.cookieExpirationPeriod(model.cookieExpirationPeriod);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Long getCookieExpirationPeriod() {
            return this.cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLbCookieStickinessPolicyRequest build() {
            return new CreateLbCookieStickinessPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLbCookieStickinessPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder cookieExpirationPeriod(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

