/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationVersionStatus {
    PROCESSED("Processed"),
    UNPROCESSED("Unprocessed"),
    FAILED("Failed"),
    PROCESSING("Processing"),
    BUILDING("Building"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationVersionStatus> VALUE_MAP;
    private final String value;

    private ApplicationVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationVersionStatus> knownValues() {
        EnumSet<ApplicationVersionStatus> knownValues = EnumSet.allOf(ApplicationVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationVersionStatus.class, ApplicationVersionStatus::toString);
    }
}

