/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationSeverity {
    ERROR("error"),
    WARNING("warning"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationSeverity> VALUE_MAP;
    private final String value;

    private ValidationSeverity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationSeverity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationSeverity> knownValues() {
        EnumSet<ValidationSeverity> knownValues = EnumSet.allOf(ValidationSeverity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationSeverity.class, ValidationSeverity::toString);
    }
}

