/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEksAnywhereSubscriptionsRequest extends EksRequest implements
        ToCopyableBuilder<ListEksAnywhereSubscriptionsRequest.Builder, ListEksAnywhereSubscriptionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEksAnywhereSubscriptionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEksAnywhereSubscriptionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> INCLUDE_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("includeStatus")
            .getter(getter(ListEksAnywhereSubscriptionsRequest::includeStatusAsStrings))
            .setter(setter(Builder::includeStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, INCLUDE_STATUS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> includeStatus;

    private ListEksAnywhereSubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeStatus = builder.includeStatus;
    }

    /**
     * <p>
     * The maximum number of cluster results returned by ListEksAnywhereSubscriptions in paginated output. When you use
     * this parameter, ListEksAnywhereSubscriptions returns only maxResults results in a single page along with a
     * nextToken response element. You can see the remaining results of the initial request by sending another
     * ListEksAnywhereSubscriptions request with the returned nextToken value. This value can be between 1 and 100. If
     * you don't use this parameter, ListEksAnywhereSubscriptions returns up to 10 results and a nextToken value if
     * applicable.
     * </p>
     * 
     * @return The maximum number of cluster results returned by ListEksAnywhereSubscriptions in paginated output. When
     *         you use this parameter, ListEksAnywhereSubscriptions returns only maxResults results in a single page
     *         along with a nextToken response element. You can see the remaining results of the initial request by
     *         sending another ListEksAnywhereSubscriptions request with the returned nextToken value. This value can be
     *         between 1 and 100. If you don't use this parameter, ListEksAnywhereSubscriptions returns up to 10 results
     *         and a nextToken value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The nextToken value to include in a future ListEksAnywhereSubscriptions request. When the results of a
     * ListEksAnywhereSubscriptions request exceed maxResults, you can use this value to retrieve the next page of
     * results. This value is null when there are no more results to return.
     * </p>
     * 
     * @return The nextToken value to include in a future ListEksAnywhereSubscriptions request. When the results of a
     *         ListEksAnywhereSubscriptions request exceed maxResults, you can use this value to retrieve the next page
     *         of results. This value is null when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An array of subscription statuses to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeStatus} method.
     * </p>
     * 
     * @return An array of subscription statuses to filter on.
     */
    public final List<EksAnywhereSubscriptionStatus> includeStatus() {
        return EksAnywhereSubscriptionStatusValuesCopier.copyStringToEnum(includeStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeStatus() {
        return includeStatus != null && !(includeStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of subscription statuses to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeStatus} method.
     * </p>
     * 
     * @return An array of subscription statuses to filter on.
     */
    public final List<String> includeStatusAsStrings() {
        return includeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeStatus() ? includeStatusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEksAnywhereSubscriptionsRequest)) {
            return false;
        }
        ListEksAnywhereSubscriptionsRequest other = (ListEksAnywhereSubscriptionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasIncludeStatus() == other.hasIncludeStatus()
                && Objects.equals(includeStatusAsStrings(), other.includeStatusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEksAnywhereSubscriptionsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("IncludeStatus", hasIncludeStatus() ? includeStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "includeStatus":
            return Optional.ofNullable(clazz.cast(includeStatusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEksAnywhereSubscriptionsRequest, T> g) {
        return obj -> g.apply((ListEksAnywhereSubscriptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEksAnywhereSubscriptionsRequest> {
        /**
         * <p>
         * The maximum number of cluster results returned by ListEksAnywhereSubscriptions in paginated output. When you
         * use this parameter, ListEksAnywhereSubscriptions returns only maxResults results in a single page along with
         * a nextToken response element. You can see the remaining results of the initial request by sending another
         * ListEksAnywhereSubscriptions request with the returned nextToken value. This value can be between 1 and 100.
         * If you don't use this parameter, ListEksAnywhereSubscriptions returns up to 10 results and a nextToken value
         * if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster results returned by ListEksAnywhereSubscriptions in paginated output.
         *        When you use this parameter, ListEksAnywhereSubscriptions returns only maxResults results in a single
         *        page along with a nextToken response element. You can see the remaining results of the initial request
         *        by sending another ListEksAnywhereSubscriptions request with the returned nextToken value. This value
         *        can be between 1 and 100. If you don't use this parameter, ListEksAnywhereSubscriptions returns up to
         *        10 results and a nextToken value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The nextToken value to include in a future ListEksAnywhereSubscriptions request. When the results of a
         * ListEksAnywhereSubscriptions request exceed maxResults, you can use this value to retrieve the next page of
         * results. This value is null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The nextToken value to include in a future ListEksAnywhereSubscriptions request. When the results of a
         *        ListEksAnywhereSubscriptions request exceed maxResults, you can use this value to retrieve the next
         *        page of results. This value is null when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of subscription statuses to filter on.
         * </p>
         * 
         * @param includeStatus
         *        An array of subscription statuses to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatusWithStrings(Collection<String> includeStatus);

        /**
         * <p>
         * An array of subscription statuses to filter on.
         * </p>
         * 
         * @param includeStatus
         *        An array of subscription statuses to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatusWithStrings(String... includeStatus);

        /**
         * <p>
         * An array of subscription statuses to filter on.
         * </p>
         * 
         * @param includeStatus
         *        An array of subscription statuses to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatus(Collection<EksAnywhereSubscriptionStatus> includeStatus);

        /**
         * <p>
         * An array of subscription statuses to filter on.
         * </p>
         * 
         * @param includeStatus
         *        An array of subscription statuses to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatus(EksAnywhereSubscriptionStatus... includeStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> includeStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEksAnywhereSubscriptionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            includeStatusWithStrings(model.includeStatus);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getIncludeStatus() {
            if (includeStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return includeStatus;
        }

        public final void setIncludeStatus(Collection<String> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copy(includeStatus);
        }

        @Override
        public final Builder includeStatusWithStrings(Collection<String> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copy(includeStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeStatusWithStrings(String... includeStatus) {
            includeStatusWithStrings(Arrays.asList(includeStatus));
            return this;
        }

        @Override
        public final Builder includeStatus(Collection<EksAnywhereSubscriptionStatus> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copyEnumToString(includeStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeStatus(EksAnywhereSubscriptionStatus... includeStatus) {
            includeStatus(Arrays.asList(includeStatus));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEksAnywhereSubscriptionsRequest build() {
            return new ListEksAnywhereSubscriptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
