/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An EKS Anywhere subscription authorizing the customer to support for licensed clusters and access to EKS Anywhere
 * Curated Packages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksAnywhereSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<EksAnywhereSubscription.Builder, EksAnywhereSubscription> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EksAnywhereSubscription::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EksAnywhereSubscription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EksAnywhereSubscription::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveDate").getter(getter(EksAnywhereSubscription::effectiveDate))
            .setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate").getter(getter(EksAnywhereSubscription::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final SdkField<Integer> LICENSE_QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("licenseQuantity").getter(getter(EksAnywhereSubscription::licenseQuantity))
            .setter(setter(Builder::licenseQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseQuantity").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseType").getter(getter(EksAnywhereSubscription::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()).build();

    private static final SdkField<EksAnywhereSubscriptionTerm> TERM_FIELD = SdkField
            .<EksAnywhereSubscriptionTerm> builder(MarshallingType.SDK_POJO).memberName("term")
            .getter(getter(EksAnywhereSubscription::term)).setter(setter(Builder::term))
            .constructor(EksAnywhereSubscriptionTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EksAnywhereSubscription::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoRenew").getter(getter(EksAnywhereSubscription::autoRenew)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRenew").build()).build();

    private static final SdkField<List<String>> LICENSE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("licenseArns")
            .getter(getter(EksAnywhereSubscription::licenseArns))
            .setter(setter(Builder::licenseArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(EksAnywhereSubscription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, LICENSE_QUANTITY_FIELD, LICENSE_TYPE_FIELD,
            TERM_FIELD, STATUS_FIELD, AUTO_RENEW_FIELD, LICENSE_ARNS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final Instant createdAt;

    private final Instant effectiveDate;

    private final Instant expirationDate;

    private final Integer licenseQuantity;

    private final String licenseType;

    private final EksAnywhereSubscriptionTerm term;

    private final String status;

    private final Boolean autoRenew;

    private final List<String> licenseArns;

    private final Map<String, String> tags;

    private EksAnywhereSubscription(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.licenseQuantity = builder.licenseQuantity;
        this.licenseType = builder.licenseType;
        this.term = builder.term;
        this.status = builder.status;
        this.autoRenew = builder.autoRenew;
        this.licenseArns = builder.licenseArns;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * UUID identifying a subscription.
     * </p>
     * 
     * @return UUID identifying a subscription.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the subscription.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the subscription.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Unix timestamp in seconds for when the subscription was created.
     * </p>
     * 
     * @return The Unix timestamp in seconds for when the subscription was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp in seconds for when the subscription is effective.
     * </p>
     * 
     * @return The Unix timestamp in seconds for when the subscription is effective.
     */
    public final Instant effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto renew
     * configuration of the subscription object.
     * </p>
     * 
     * @return The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto
     *         renew configuration of the subscription object.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The number of licenses included in a subscription. Valid values are between 1 and 1000.
     * </p>
     * 
     * @return The number of licenses included in a subscription. Valid values are between 1 and 1000.
     */
    public final Integer licenseQuantity() {
        return licenseQuantity;
    }

    /**
     * <p>
     * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each
     * license covers support for a single EKS Anywhere cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link EksAnywhereSubscriptionLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
     *         each license covers support for a single EKS Anywhere cluster.
     * @see EksAnywhereSubscriptionLicenseType
     */
    public final EksAnywhereSubscriptionLicenseType licenseType() {
        return EksAnywhereSubscriptionLicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each
     * license covers support for a single EKS Anywhere cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link EksAnywhereSubscriptionLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
     *         each license covers support for a single EKS Anywhere cluster.
     * @see EksAnywhereSubscriptionLicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * An EksAnywhereSubscriptionTerm object.
     * </p>
     * 
     * @return An EksAnywhereSubscriptionTerm object.
     */
    public final EksAnywhereSubscriptionTerm term() {
        return term;
    }

    /**
     * <p>
     * The status of a subscription.
     * </p>
     * 
     * @return The status of a subscription.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A boolean indicating whether or not a subscription will auto renew when it expires.
     * </p>
     * 
     * @return A boolean indicating whether or not a subscription will auto renew when it expires.
     */
    public final Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseArns() {
        return licenseArns != null && !(licenseArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License Manager License ARNs associated with the subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseArns} method.
     * </p>
     * 
     * @return License Manager License ARNs associated with the subscription.
     */
    public final List<String> licenseArns() {
        return licenseArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an
     * optional value. Subscription tags do not propagate to any other resources associated with the subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata for a subscription to assist with categorization and organization. Each tag consists of a
     *         key and an optional value. Subscription tags do not propagate to any other resources associated with the
     *         subscription.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(licenseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseArns() ? licenseArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksAnywhereSubscription)) {
            return false;
        }
        EksAnywhereSubscription other = (EksAnywhereSubscription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(licenseQuantity(), other.licenseQuantity())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(term(), other.term())
                && Objects.equals(status(), other.status()) && Objects.equals(autoRenew(), other.autoRenew())
                && hasLicenseArns() == other.hasLicenseArns() && Objects.equals(licenseArns(), other.licenseArns())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksAnywhereSubscription").add("Id", id()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("EffectiveDate", effectiveDate()).add("ExpirationDate", expirationDate())
                .add("LicenseQuantity", licenseQuantity()).add("LicenseType", licenseTypeAsString()).add("Term", term())
                .add("Status", status()).add("AutoRenew", autoRenew())
                .add("LicenseArns", hasLicenseArns() ? licenseArns() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "effectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "licenseQuantity":
            return Optional.ofNullable(clazz.cast(licenseQuantity()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "autoRenew":
            return Optional.ofNullable(clazz.cast(autoRenew()));
        case "licenseArns":
            return Optional.ofNullable(clazz.cast(licenseArns()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksAnywhereSubscription, T> g) {
        return obj -> g.apply((EksAnywhereSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksAnywhereSubscription> {
        /**
         * <p>
         * UUID identifying a subscription.
         * </p>
         * 
         * @param id
         *        UUID identifying a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the subscription.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Unix timestamp in seconds for when the subscription was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp in seconds for when the subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp in seconds for when the subscription is effective.
         * </p>
         * 
         * @param effectiveDate
         *        The Unix timestamp in seconds for when the subscription is effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(Instant effectiveDate);

        /**
         * <p>
         * The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto
         * renew configuration of the subscription object.
         * </p>
         * 
         * @param expirationDate
         *        The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the
         *        auto renew configuration of the subscription object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The number of licenses included in a subscription. Valid values are between 1 and 1000.
         * </p>
         * 
         * @param licenseQuantity
         *        The number of licenses included in a subscription. Valid values are between 1 and 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseQuantity(Integer licenseQuantity);

        /**
         * <p>
         * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
         * each license covers support for a single EKS Anywhere cluster.
         * </p>
         * 
         * @param licenseType
         *        The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license
         *        type, each license covers support for a single EKS Anywhere cluster.
         * @see EksAnywhereSubscriptionLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksAnywhereSubscriptionLicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
         * each license covers support for a single EKS Anywhere cluster.
         * </p>
         * 
         * @param licenseType
         *        The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license
         *        type, each license covers support for a single EKS Anywhere cluster.
         * @see EksAnywhereSubscriptionLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksAnywhereSubscriptionLicenseType
         */
        Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType);

        /**
         * <p>
         * An EksAnywhereSubscriptionTerm object.
         * </p>
         * 
         * @param term
         *        An EksAnywhereSubscriptionTerm object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(EksAnywhereSubscriptionTerm term);

        /**
         * <p>
         * An EksAnywhereSubscriptionTerm object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksAnywhereSubscriptionTerm.Builder}
         * avoiding the need to create one manually via {@link EksAnywhereSubscriptionTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksAnywhereSubscriptionTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #term(EksAnywhereSubscriptionTerm)}.
         * 
         * @param term
         *        a consumer that will call methods on {@link EksAnywhereSubscriptionTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #term(EksAnywhereSubscriptionTerm)
         */
        default Builder term(Consumer<EksAnywhereSubscriptionTerm.Builder> term) {
            return term(EksAnywhereSubscriptionTerm.builder().applyMutation(term).build());
        }

        /**
         * <p>
         * The status of a subscription.
         * </p>
         * 
         * @param status
         *        The status of a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A boolean indicating whether or not a subscription will auto renew when it expires.
         * </p>
         * 
         * @param autoRenew
         *        A boolean indicating whether or not a subscription will auto renew when it expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * License Manager License ARNs associated with the subscription.
         * </p>
         * 
         * @param licenseArns
         *        License Manager License ARNs associated with the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArns(Collection<String> licenseArns);

        /**
         * <p>
         * License Manager License ARNs associated with the subscription.
         * </p>
         * 
         * @param licenseArns
         *        License Manager License ARNs associated with the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArns(String... licenseArns);

        /**
         * <p>
         * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key
         * and an optional value. Subscription tags do not propagate to any other resources associated with the
         * subscription.
         * </p>
         * 
         * @param tags
         *        The metadata for a subscription to assist with categorization and organization. Each tag consists of a
         *        key and an optional value. Subscription tags do not propagate to any other resources associated with
         *        the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private Instant createdAt;

        private Instant effectiveDate;

        private Instant expirationDate;

        private Integer licenseQuantity;

        private String licenseType;

        private EksAnywhereSubscriptionTerm term;

        private String status;

        private Boolean autoRenew;

        private List<String> licenseArns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EksAnywhereSubscription model) {
            id(model.id);
            arn(model.arn);
            createdAt(model.createdAt);
            effectiveDate(model.effectiveDate);
            expirationDate(model.expirationDate);
            licenseQuantity(model.licenseQuantity);
            licenseType(model.licenseType);
            term(model.term);
            status(model.status);
            autoRenew(model.autoRenew);
            licenseArns(model.licenseArns);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEffectiveDate() {
            return effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Integer getLicenseQuantity() {
            return licenseQuantity;
        }

        public final void setLicenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
        }

        @Override
        public final Builder licenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final EksAnywhereSubscriptionTerm.Builder getTerm() {
            return term != null ? term.toBuilder() : null;
        }

        public final void setTerm(EksAnywhereSubscriptionTerm.BuilderImpl term) {
            this.term = term != null ? term.build() : null;
        }

        @Override
        public final Builder term(EksAnywhereSubscriptionTerm term) {
            this.term = term;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final Collection<String> getLicenseArns() {
            if (licenseArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseArns;
        }

        public final void setLicenseArns(Collection<String> licenseArns) {
            this.licenseArns = StringListCopier.copy(licenseArns);
        }

        @Override
        public final Builder licenseArns(Collection<String> licenseArns) {
            this.licenseArns = StringListCopier.copy(licenseArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseArns(String... licenseArns) {
            licenseArns(Arrays.asList(licenseArns));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EksAnywhereSubscription build() {
            return new EksAnywhereSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
