/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpFamily {
    IPV4("ipv4"),
    IPV6("ipv6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpFamily> VALUE_MAP;
    private final String value;

    private IpFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpFamily> knownValues() {
        EnumSet<IpFamily> knownValues = EnumSet.allOf(IpFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpFamily.class, IpFamily::toString);
    }
}

