/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eks.DefaultEksAsyncClient;
import software.amazon.awssdk.services.eks.DefaultEksBaseClientBuilder;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.EksAsyncClientBuilder;
import software.amazon.awssdk.services.eks.EksServiceClientConfiguration;
import software.amazon.awssdk.services.eks.endpoints.EksEndpointProvider;

@SdkInternalApi
final class DefaultEksAsyncClientBuilder
extends DefaultEksBaseClientBuilder<EksAsyncClientBuilder, EksAsyncClient>
implements EksAsyncClientBuilder {
    DefaultEksAsyncClientBuilder() {
    }

    @Override
    public DefaultEksAsyncClientBuilder endpointProvider(EksEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EksAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEksAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EksServiceClientConfiguration serviceClientConfiguration = EksServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEksAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

