/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MarketplaceInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<MarketplaceInformation.Builder, MarketplaceInformation> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productId").getter(getter(MarketplaceInformation::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productId").build()).build();

    private static final SdkField<String> PRODUCT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productUrl").getter(getter(MarketplaceInformation::productUrl)).setter(setter(Builder::productUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD,
            PRODUCT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productId;

    private final String productUrl;

    private MarketplaceInformation(BuilderImpl builder) {
        this.productId = builder.productId;
        this.productUrl = builder.productUrl;
    }

    /**
     * <p>
     * The product ID from the Amazon Web Services Marketplace.
     * </p>
     * 
     * @return The product ID from the Amazon Web Services Marketplace.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The product URL from the Amazon Web Services Marketplace.
     * </p>
     * 
     * @return The product URL from the Amazon Web Services Marketplace.
     */
    public final String productUrl() {
        return productUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarketplaceInformation)) {
            return false;
        }
        MarketplaceInformation other = (MarketplaceInformation) obj;
        return Objects.equals(productId(), other.productId()) && Objects.equals(productUrl(), other.productUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MarketplaceInformation").add("ProductId", productId()).add("ProductUrl", productUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "productId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "productUrl":
            return Optional.ofNullable(clazz.cast(productUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MarketplaceInformation, T> g) {
        return obj -> g.apply((MarketplaceInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MarketplaceInformation> {
        /**
         * <p>
         * The product ID from the Amazon Web Services Marketplace.
         * </p>
         * 
         * @param productId
         *        The product ID from the Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The product URL from the Amazon Web Services Marketplace.
         * </p>
         * 
         * @param productUrl
         *        The product URL from the Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUrl(String productUrl);
    }

    static final class BuilderImpl implements Builder {
        private String productId;

        private String productUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(MarketplaceInformation model) {
            productId(model.productId);
            productUrl(model.productUrl);
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductUrl() {
            return productUrl;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        @Override
        public MarketplaceInformation build() {
            return new MarketplaceInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
