/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersRequest extends EksRequest implements
        ToCopyableBuilder<ListClustersRequest.Builder, ListClustersRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListClustersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListClustersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(ListClustersRequest::include))
            .setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, INCLUDE_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> include;

    private ListClustersRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.include = builder.include;
    }

    /**
     * <p>
     * The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use
     * this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along
     * with a <code>nextToken</code> response element. You can see the remaining results of the initial request by
     * sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can
     * be between 1 and 100. If you don't use this parameter, <code>ListClusters</code> returns up to 100 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you
     *         use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single
     *         page along with a <code>nextToken</code> response element. You can see the remaining results of the
     *         initial request by sending another <code>ListClusters</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
     *         <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return connected
     * clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase otherwise an error
     * occurs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return
     *         connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase
     *         otherwise an error occurs.
     */
    public final List<String> include() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? include() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasInclude() == other.hasInclude() && Objects.equals(include(), other.include());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Include", hasInclude() ? include() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "include":
            return Optional.ofNullable(clazz.cast(include()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersRequest, T> g) {
        return obj -> g.apply((ListClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersRequest> {
        /**
         * <p>
         * The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use
         * this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along
         * with a <code>nextToken</code> response element. You can see the remaining results of the initial request by
         * sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value
         * can be between 1 and 100. If you don't use this parameter, <code>ListClusters</code> returns up to 100
         * results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When
         *        you use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a
         *        single page along with a <code>nextToken</code> response element. You can see the remaining results of
         *        the initial request by sending another <code>ListClusters</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
         *        <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return
         * connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase
         * otherwise an error occurs.
         * </p>
         * 
         * @param include
         *        Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to
         *        return connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in
         *        lowercase otherwise an error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<String> include);

        /**
         * <p>
         * Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return
         * connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase
         * otherwise an error occurs.
         * </p>
         * 
         * @param include
         *        Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to
         *        return connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in
         *        lowercase otherwise an error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(String... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            include(model.include);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = IncludeClustersListCopier.copy(include);
        }

        @Override
        public final Builder include(Collection<String> include) {
            this.include = IncludeClustersListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(String... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
